/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.IDParams;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.RenderConfig;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermissions;
import com.dtstep.lighthouse.insights.dto.ChangeStatStateParam;
import com.dtstep.lighthouse.insights.dto.StatFilterConfigParam;
import com.dtstep.lighthouse.insights.dto.StatQueryParam;
import com.dtstep.lighthouse.insights.dto.StatRenderConfigParam;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.vo.ResultData;
import com.dtstep.lighthouse.insights.vo.StatExtendVO;
import com.dtstep.lighthouse.insights.vo.StatVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@CrossOrigin(origins={"*"}, allowedHeaders={"*"})
public class StatController {
    private static final Logger logger = LoggerFactory.getLogger(StatController.class);
    @Autowired
    private StatService statService;

    @RequestMapping(value={"/stat/list"})
    public ResultData<ListData<StatVO>> list(@Validated @RequestBody ListSearchObject<StatQueryParam> searchObject) {
        StatQueryParam queryParam = (StatQueryParam)searchObject.getQueryParamOrDefault((Object)new StatQueryParam());
        ListData listData = this.statService.queryList(queryParam, Integer.valueOf(searchObject.getPagination().getPageNum()), Integer.valueOf(searchObject.getPagination().getPageSize()));
        return ResultData.success((Object)listData);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="projectId")
    @RequestMapping(value={"/stat/create"})
    public ResultData<Integer> create(@Validated @RequestBody Stat createParam) throws Exception {
        ResultCode resultCode = this.statService.create(createParam);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="projectId")
    @RequestMapping(value={"/stat/update"})
    public ResultData<Integer> update(@Validated @RequestBody Stat createParam) {
        ResultCode resultCode = this.statService.update(createParam);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermissions(value={@AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="projectId"), @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)})
    @RequestMapping(value={"/stat/changeState"})
    public ResultData<Integer> changeState(@Validated @RequestBody ChangeStatStateParam changeParam) throws Exception {
        Integer id = changeParam.getId();
        StatVO stat = this.statService.queryById(id);
        Validate.notNull((Object)stat);
        this.statService.changeState((Stat)stat, changeParam.getState());
        return ResultData.success();
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.STAT_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/stat/deleteById"})
    public ResultData<Integer> deleteById(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        StatVO stat = this.statService.queryById(id);
        Validate.notNull((Object)stat);
        int result = this.statService.delete((Stat)stat);
        if (result > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @RequestMapping(value={"/stat/queryById"})
    public ResultData<StatExtendVO> queryById(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        StatVO stat = this.statService.queryById(id);
        if (stat == null) {
            return ResultData.result((ResultCode)ResultCode.elementNotFound);
        }
        RenderConfig renderConfig = this.statService.getStatRenderConfig(stat);
        StatExtendVO statExtendDto = new StatExtendVO(stat);
        statExtendDto.setRenderConfig(renderConfig);
        Validate.notNull((Object)stat);
        return ResultData.success((Object)statExtendDto);
    }

    @RequestMapping(value={"/stat/queryByIds"})
    public ResultData<List<StatExtendVO>> queryByIds(@Validated @RequestBody IDParams idParams) throws Exception {
        List ids = idParams.getIds();
        List voList = this.statService.queryByIds(ids);
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return ResultData.result((ResultCode)ResultCode.elementNotFound);
        }
        ArrayList<StatExtendVO> extendVOList = new ArrayList<StatExtendVO>();
        for (StatVO stat : voList) {
            RenderConfig renderConfig = this.statService.getStatRenderConfig(stat);
            StatExtendVO statExtendDto = new StatExtendVO(stat);
            statExtendDto.setRenderConfig(renderConfig);
            extendVOList.add(statExtendDto);
        }
        return ResultData.success(extendVOList);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.STAT_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/stat/filterConfig"})
    public ResultData<Integer> filterConfig(@Validated @RequestBody StatFilterConfigParam filterConfigParam) throws Exception {
        Integer id = filterConfigParam.getId();
        StatVO stat = this.statService.queryById(id);
        Validate.notNull((Object)stat);
        List configList = filterConfigParam.getFilters();
        ResultCode resultCode = this.statService.filterConfig(stat, configList);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.STAT_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/stat/filterReset"})
    public ResultData<Integer> filterReset(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        StatVO stat = this.statService.queryById(id);
        Validate.notNull((Object)stat);
        RenderConfig renderConfig = stat.getRenderConfig();
        renderConfig.setFilters(null);
        ResultCode resultCode = this.statService.update((Stat)stat);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.STAT_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/stat/renderConfig"})
    public ResultData<Integer> renderConfig(@Validated @RequestBody StatRenderConfigParam renderConfigParam) throws Exception {
        Integer id = renderConfigParam.getId();
        StatVO stat = this.statService.queryById(id);
        Validate.notNull((Object)stat);
        List chartConfigs = renderConfigParam.getCharts();
        ResultCode resultCode = CollectionUtils.isNotEmpty((Collection)chartConfigs) ? this.statService.chartsConfig(stat, chartConfigs) : ResultCode.renderConfigConfigCannotBeEmpty;
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.STAT_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/stat/renderReset"})
    public ResultData<Integer> renderReset(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        StatVO stat = this.statService.queryById(id);
        Validate.notNull((Object)stat);
        RenderConfig renderConfig = stat.getRenderConfig();
        renderConfig.setCharts(null);
        renderConfig.setDatepicker(null);
        ResultCode resultCode = this.statService.update((Stat)stat);
        return ResultData.result((ResultCode)resultCode);
    }
}

