/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.enums.UserStateEnum;
import com.dtstep.lighthouse.common.modal.Department;
import com.dtstep.lighthouse.common.modal.Domain;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.IDParams;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.Pagination;
import com.dtstep.lighthouse.common.modal.Permission;
import com.dtstep.lighthouse.common.modal.Project;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.util.BeanCopyUtil;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.insights.config.SeedAuthenticationToken;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.dto.ChangePasswordParam;
import com.dtstep.lighthouse.insights.dto.ChangeUserStateParam;
import com.dtstep.lighthouse.insights.dto.TextParam;
import com.dtstep.lighthouse.insights.dto.UserCreateParam;
import com.dtstep.lighthouse.insights.dto.UserQueryParam;
import com.dtstep.lighthouse.insights.dto.UserUpdateParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.DomainService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.ResultData;
import com.dtstep.lighthouse.insights.vo.UserVO;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private BaseService baseService;
    @Autowired
    private DomainService domainService;

    @RequestMapping(value={"/user/register"})
    public ResultData<Integer> register(@Validated @RequestBody UserCreateParam createParam) throws Exception {
        String userName = createParam.getUsername();
        boolean isExist = this.userService.isUserNameExist(userName);
        if (isExist) {
            return ResultData.result((ResultCode)ResultCode.registerUserNameExist);
        }
        User user = new User();
        BeanCopyUtil.copy((Object)createParam, (Object)user);
        int result = this.userService.create(user, true);
        if (result > 0) {
            return ResultData.success((Object)result);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @RequestMapping(value={"/user/fetchUserInfo"})
    public ResultData<UserVO> fetchUserInfo() {
        SeedAuthenticationToken authentication = (SeedAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        Integer userId = authentication.getUserId();
        User user = this.userService.queryById(userId.intValue());
        Validate.notNull((Object)user);
        UserVO userVO = new UserVO(user);
        Domain domain = this.domainService.queryDefault();
        userVO.setDefaultDomain(domain);
        Set permissionEnumSets = this.userService.getUserPermissions(userId);
        userVO.setPermissions(permissionEnumSets);
        return ResultData.success((Object)userVO);
    }

    @RequestMapping(value={"/user/updateById"})
    public ResultData<Integer> updateById(@Validated @RequestBody UserUpdateParam updateParam) {
        Integer userId = updateParam.getId();
        SeedAuthenticationToken authentication = (SeedAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        Integer currentUserId = authentication.getUserId();
        if (currentUserId.intValue() != userId.intValue()) {
            return ResultData.result((ResultCode)ResultCode.systemError);
        }
        User userInfo = new User();
        userInfo.setId(userId);
        userInfo.setEmail(updateParam.getEmail());
        userInfo.setPhone(updateParam.getPhone());
        userInfo.setDepartmentId(updateParam.getDepartmentId());
        int id = this.userService.update(userInfo);
        if (id > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @RequestMapping(value={"/user/changePassword"})
    public ResultData<Integer> changePassword(@Validated @RequestBody ChangePasswordParam updateParam) {
        Integer userId = updateParam.getId();
        SeedAuthenticationToken authentication = (SeedAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        Integer currentUserId = authentication.getUserId();
        if (currentUserId.intValue() != userId.intValue()) {
            return ResultData.result((ResultCode)ResultCode.paramValidateFailed);
        }
        String username = updateParam.getUsername();
        User dbUser = this.userService.queryAllInfoByUserName(username);
        String originPassword = updateParam.getOriginPassword();
        if (dbUser == null || dbUser.getState() != UserStateEnum.USER_NORMAL || dbUser.getId().intValue() != userId.intValue()) {
            return ResultData.result((ResultCode)ResultCode.unauthorized);
        }
        if (!this.passwordEncoder.matches((CharSequence)originPassword, dbUser.getPassword())) {
            return ResultData.result((ResultCode)ResultCode.userChangePasswordWrong);
        }
        User userInfo = new User();
        userInfo.setId(userId);
        userInfo.setPassword(this.passwordEncoder.encode((CharSequence)updateParam.getPassword()));
        int id = this.userService.update(userInfo);
        if (id > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)
    @RequestMapping(value={"/user/changeState"})
    public ResultData<Integer> changeState(@Validated @RequestBody ChangeUserStateParam changeParam) {
        Integer id = changeParam.getId();
        UserStateEnum userStateEnum = changeParam.getState();
        Validate.notNull((Object)id);
        Validate.notNull((Object)userStateEnum);
        User dbUser = this.userService.queryById(id.intValue());
        Validate.notNull((Object)dbUser);
        User user = new User();
        user.setState(userStateEnum);
        user.setId(id);
        int result = this.userService.update(user);
        if (id > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)
    @RequestMapping(value={"/user/resetPasswd"})
    public ResultData<Integer> resetPasswd(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        User dbUser = this.userService.queryById(id.intValue());
        Validate.notNull((Object)dbUser);
        User userInfo = new User();
        userInfo.setId(id);
        userInfo.setPassword(this.passwordEncoder.encode((CharSequence)Md5Util.getMD5((String)"123456")));
        int result = this.userService.update(userInfo);
        if (result > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)
    @RequestMapping(value={"/user/deleteById"})
    public ResultData<Integer> delete(@Validated @RequestBody IDParam idParam) {
        int result;
        Integer roleId;
        ResourceDto resource;
        Integer id = idParam.getId();
        int currentUserId = this.baseService.getCurrentUserId();
        if (id == currentUserId) {
            return ResultData.result((ResultCode)ResultCode.userDelErrorCannotDelCurrentUser);
        }
        List permissions = this.permissionService.queryUserManagePermission(id, Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)permissions) && (resource = this.resourceService.queryByRoleId(roleId = ((Permission)permissions.get(0)).getRoleId())) != null) {
            ResourceTypeEnum resourceTypeEnum = resource.getResourceType();
            if (resourceTypeEnum == ResourceTypeEnum.Department) {
                return ResultData.result((ResultCode)ResultCode.userDelErrorExistDepartPermission, (Object[])new Object[]{((Department)resource.getData()).getName()});
            }
            if (resourceTypeEnum == ResourceTypeEnum.Project) {
                return ResultData.result((ResultCode)ResultCode.userDelErrorExistProjectPermission, (Object[])new Object[]{((Project)resource.getData()).getTitle()});
            }
            if (resourceTypeEnum == ResourceTypeEnum.Group) {
                return ResultData.result((ResultCode)ResultCode.userDelErrorExistGroupPermission, (Object[])new Object[]{((Group)resource.getData()).getToken()});
            }
            if (resourceTypeEnum == ResourceTypeEnum.Stat) {
                return ResultData.result((ResultCode)ResultCode.userDelErrorExistStatPermission, (Object[])new Object[]{((Stat)resource.getData()).getTitle()});
            }
        }
        if ((result = this.userService.deleteById(id.intValue())) > 0) {
            return ResultData.success();
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)
    @PostMapping(value={"/user/list"})
    public ResultData<ListData<UserVO>> list(@Validated @RequestBody ListSearchObject<UserQueryParam> searchObject) {
        Pagination pagination = searchObject.getPagination();
        ListData listData = this.userService.queryList((UserQueryParam)searchObject.getQueryParams(), Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }

    @PostMapping(value={"/user/termList"})
    public ResultData<List<User>> termList(@RequestBody TextParam text) {
        String search = text.getText();
        if (!StringUtil.isLetterNumOrUnderLine((String)search)) {
            return ResultData.result((ResultCode)ResultCode.paramValidateFailed);
        }
        List users = this.userService.termQuery(search);
        return ResultData.success((Object)users);
    }

    @PostMapping(value={"/user/termQueryByIds"})
    public ResultData<List<User>> termQueryByIds(@RequestBody IDParams idParams) {
        List users = this.userService.termQueryByIds(idParams.getIds());
        return ResultData.success((Object)users);
    }
}

