/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.Owner;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.insights.config.CallerKeyAuthenticationToken;
import com.dtstep.lighthouse.insights.config.SeedAuthenticationToken;
import com.dtstep.lighthouse.insights.service.BaseService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class BaseServiceImpl
implements BaseService {
    public Integer getCurrentUserId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication.getClass() != SeedAuthenticationToken.class) {
            return null;
        }
        return (Integer)authentication.getPrincipal();
    }

    public Owner getCurrentOwner() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        if (authentication.getClass() == SeedAuthenticationToken.class) {
            Owner owner = new Owner();
            owner.setOwnerId((Integer)authentication.getPrincipal());
            owner.setOwnerType(OwnerTypeEnum.USER);
            return owner;
        }
        if (authentication.getClass() == CallerKeyAuthenticationToken.class) {
            Owner owner = new Owner();
            owner.setOwnerId((Integer)authentication.getPrincipal());
            owner.setOwnerType(OwnerTypeEnum.CALLER);
            return owner;
        }
        return null;
    }
}

