/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.enums.CallerStateEnum;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Caller;
import com.dtstep.lighthouse.common.modal.CallerQueryParam;
import com.dtstep.lighthouse.common.modal.Domain;
import com.dtstep.lighthouse.common.modal.Permission;
import com.dtstep.lighthouse.common.modal.PermissionEnum;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.RolePair;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.insights.dao.CallerDao;
import com.dtstep.lighthouse.insights.dao.PermissionDao;
import com.dtstep.lighthouse.insights.dto.PermissionGrantParam;
import com.dtstep.lighthouse.insights.dto.PermissionReleaseParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.CallerService;
import com.dtstep.lighthouse.insights.service.DomainService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.CallerVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CallerServiceImpl
implements CallerService {
    private static final Logger logger = LoggerFactory.getLogger(CallerServiceImpl.class);
    @Autowired
    private CallerDao callerDao;
    @Autowired
    private BaseService baseService;
    @Autowired
    private DomainService domainService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;

    @Transactional
    public ServiceResult<Integer> create(Caller caller) throws Exception {
        String callerName = caller.getName();
        CallerQueryParam countQueryParam = new CallerQueryParam();
        countQueryParam.setName(callerName);
        int count = this.callerDao.count(countQueryParam);
        if (count > 0) {
            return ServiceResult.result((ResultCode)ResultCode.getExtendResultCode((ResultCode)ResultCode.callerNameAlreadyExist, (String[])new String[]{callerName}));
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        String secretKey = RandomID.id((int)40);
        caller.setSecretKey(secretKey);
        caller.setState(CallerStateEnum.NORMAL);
        caller.setCreateTime(localDateTime);
        caller.setUpdateTime(localDateTime);
        this.callerDao.insert(caller);
        int id = caller.getId();
        Domain domain = this.domainService.queryDefault();
        RolePair rolePair = this.resourceService.addResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Caller, (Integer)id, (ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)domain.getId()));
        Integer manageRoleId = rolePair.getManageRoleId();
        int currentUserId = this.baseService.getCurrentUserId();
        Permission adminPermission = new Permission(Integer.valueOf(currentUserId), OwnerTypeEnum.USER, manageRoleId);
        this.permissionService.create(adminPermission);
        if (id > 0) {
            return ServiceResult.result((ResultCode)ResultCode.success, (Object)id);
        }
        return ServiceResult.result((ResultCode)ResultCode.systemError);
    }

    @Transactional
    public int update(Caller caller) throws Exception {
        LocalDateTime localDateTime = LocalDateTime.now();
        caller.setUpdateTime(localDateTime);
        Domain domain = this.domainService.queryDefault();
        this.resourceService.updateResourcePidCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Caller, (Integer)caller.getId(), (ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)domain.getId()));
        return this.callerDao.update(caller);
    }

    public CallerVO queryById(Integer id) throws Exception {
        Caller caller = this.callerDao.queryById(id);
        return this.translate(caller);
    }

    @Transactional
    public void deleteById(Integer id) throws Exception {
        this.callerDao.deleteById(id);
        Domain domain = this.domainService.queryDefault();
        this.resourceService.deleteResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Caller, (Integer)id, (ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)domain.getId()));
    }

    private CallerVO translate(Caller caller) {
        Integer currentUserId;
        if (caller == null) {
            return null;
        }
        CallerVO callerVO = new CallerVO(caller);
        Role manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.CALLER_MANAGER_PERMISSION, caller.getId());
        List adminIds = this.permissionService.queryUserPermissionsByRoleId(manageRole.getId(), Integer.valueOf(3));
        if (CollectionUtils.isNotEmpty((Collection)adminIds)) {
            List admins = adminIds.stream().map(z -> this.userService.cacheQueryById(z.intValue())).collect(Collectors.toList());
            callerVO.setAdmins(admins);
        }
        if ((currentUserId = this.baseService.getCurrentUserId()) != null && this.permissionService.checkUserPermission(currentUserId, manageRole.getId())) {
            callerVO.addPermission(PermissionEnum.ManageAble);
            callerVO.addPermission(PermissionEnum.AccessAble);
        }
        return callerVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<CallerVO> queryList(CallerQueryParam queryParam, Integer pageNum, Integer pageSize) throws Exception {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            List callerList = this.callerDao.queryList(queryParam);
            pageInfo = new PageInfo(callerList);
        }
        finally {
            PageHelper.clearPage();
        }
        ArrayList<CallerVO> voList = new ArrayList<CallerVO>();
        for (Caller caller : pageInfo.getList()) {
            try {
                CallerVO callerVO = this.translate(caller);
                voList.add(callerVO);
            }
            catch (Exception ex) {
                logger.error("translate item info error,id:{}", (Object)caller.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(voList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public int count(CallerQueryParam queryParam) throws Exception {
        return this.callerDao.count(queryParam);
    }

    public String getSecretKey(Integer id) {
        return this.callerDao.getSecretKey(id);
    }

    @Transactional
    public ResultCode batchGrantPermissions(PermissionGrantParam grantParam) throws Exception {
        Integer roleId;
        Role role;
        Integer resourceId = grantParam.getResourceId();
        Caller caller = this.callerDao.queryById(resourceId);
        RoleTypeEnum roleTypeEnum = grantParam.getRoleType();
        Validate.notNull((Object)caller);
        HashSet adminsSet = new HashSet();
        if (roleTypeEnum == RoleTypeEnum.CALLER_MANAGER_PERMISSION) {
            role = this.roleService.queryRole(RoleTypeEnum.CALLER_MANAGER_PERMISSION, resourceId);
            roleId = role.getId();
            List adminIds = this.permissionService.queryUserPermissionsByRoleId(roleId, Integer.valueOf(5));
            adminsSet.addAll(adminIds);
        } else if (roleTypeEnum == RoleTypeEnum.CALLER_ACCESS_PERMISSION) {
            role = this.roleService.queryRole(RoleTypeEnum.CALLER_ACCESS_PERMISSION, resourceId);
            roleId = role.getId();
        } else {
            throw new Exception();
        }
        List departmentIdList = grantParam.getDepartmentsPermissions();
        List userIdList = grantParam.getUsersPermissions();
        if (CollectionUtils.isNotEmpty((Collection)departmentIdList)) {
            for (Integer tempDepartmentId : departmentIdList) {
                Validate.isTrue((roleTypeEnum == RoleTypeEnum.CALLER_ACCESS_PERMISSION ? 1 : 0) != 0);
                this.permissionService.grantPermission(tempDepartmentId, OwnerTypeEnum.DEPARTMENT, roleId);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
            if (roleTypeEnum == RoleTypeEnum.CALLER_MANAGER_PERMISSION) {
                adminsSet.addAll(userIdList);
            }
            if (adminsSet.size() > 3) {
                return ResultCode.grantPermissionAdminExceedLimit;
            }
            for (Integer userId : userIdList) {
                this.permissionService.grantPermission(userId, OwnerTypeEnum.USER, roleId);
            }
        }
        return ResultCode.success;
    }

    public ResultCode releasePermission(PermissionReleaseParam releaseParam) throws Exception {
        List adminIds;
        int currentUserId = this.baseService.getCurrentUserId();
        Integer resourceId = releaseParam.getResourceId();
        Integer permissionId = releaseParam.getPermissionId();
        Permission permission = this.permissionService.queryById(permissionId);
        Integer ownerId = permission.getOwnerId();
        Integer roleId = permission.getRoleId();
        if (releaseParam.getRoleType() == RoleTypeEnum.CALLER_MANAGER_PERMISSION && (adminIds = this.permissionDao.queryUserPermissionsByRoleId(roleId, Integer.valueOf(3))).size() <= 1) {
            return ResultCode.releasePermissionAdminAtLeastOne;
        }
        if (ownerId == currentUserId) {
            return ResultCode.releasePermissionCurrentNotAllowed;
        }
        Role role = this.roleService.queryById(roleId);
        Validate.isTrue((role.getResourceId().intValue() == resourceId.intValue() ? 1 : 0) != 0);
        this.permissionService.releasePermission(permissionId);
        return ResultCode.success;
    }
}

