/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.modal.Component;
import com.dtstep.lighthouse.common.modal.PermissionEnum;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.insights.dao.ComponentDao;
import com.dtstep.lighthouse.insights.dto.ComponentQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.ComponentService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.ComponentVO;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ComponentServiceImpl
implements ComponentService {
    private static final Logger logger = LoggerFactory.getLogger(ComponentServiceImpl.class);
    @Autowired
    private ComponentDao componentDao;
    @Autowired
    private BaseService baseService;
    @Autowired
    private UserService userService;
    private static final int MAX_DEPTH = 3;

    public ResultCode verify(String configuration) {
        try {
            JsonNode jsonNode = JsonUtil.readTree((String)configuration);
        }
        catch (Exception ex) {
            return ResultCode.componentVerifyFormatError;
        }
        List nodeList = JsonUtil.toJavaObjectList((String)configuration, TreeNode.class);
        return ComponentServiceImpl.verifyConfiguration((List)nodeList, (int)1, new ArrayList());
    }

    public static ResultCode verifyConfiguration(List<TreeNode> nodeList, int level, List<String> valueList) {
        ResultCode resultCode = ResultCode.success;
        if (level > 3) {
            return ResultCode.componentVerifyLevelLimit;
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            TreeNode treeNode = nodeList.get(i);
            String label = treeNode.getLabel();
            Object value = treeNode.getValue();
            if (StringUtil.isEmpty((String)label)) {
                return ResultCode.getExtendResultCode((ResultCode)ResultCode.componentVerifyNotEmpty, (String[])new String[]{"label"});
            }
            if (value == null || StringUtil.isEmpty((String)value.toString())) {
                return ResultCode.getExtendResultCode((ResultCode)ResultCode.componentVerifyNotEmpty, (String[])new String[]{"value"});
            }
            if (valueList.contains(value)) {
                return ResultCode.getExtendResultCode((ResultCode)ResultCode.componentVerifyDuplicateValue, (String[])new String[]{value.toString()});
            }
            valueList.add(value.toString());
            List children = treeNode.getChildren();
            if (children != null && children.size() == 0) {
                return ResultCode.getExtendResultCode((ResultCode)ResultCode.componentVerifyEmptyChildren, (String[])new String[]{label});
            }
            if (!CollectionUtils.isNotEmpty((Collection)children) || (resultCode = ComponentServiceImpl.verifyConfiguration((List)children, (int)(level + 1), valueList)) == ResultCode.success) continue;
            return resultCode;
        }
        return resultCode;
    }

    public int create(Component component) {
        LocalDateTime localDateTime = LocalDateTime.now();
        component.setCreateTime(localDateTime);
        component.setUpdateTime(localDateTime);
        Integer id = this.componentDao.insert(component);
        return id;
    }

    public int update(Component component) {
        LocalDateTime localDateTime = LocalDateTime.now();
        component.setUpdateTime(localDateTime);
        Integer id = this.componentDao.update(component);
        return id;
    }

    private ComponentVO translate(Component component) {
        int currentUserId;
        ComponentVO componentVO = new ComponentVO(component);
        int userId = component.getUserId();
        if (userId == (currentUserId = this.baseService.getCurrentUserId().intValue())) {
            componentVO.addPermission(PermissionEnum.ManageAble);
        } else {
            componentVO.addPermission(PermissionEnum.AccessAble);
        }
        User user = this.userService.cacheQueryById(userId);
        componentVO.setUser(user);
        return componentVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<ComponentVO> queryList(ComponentQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = null;
        int currentUserId = this.baseService.getCurrentUserId();
        queryParam.setUserId(Integer.valueOf(currentUserId));
        try {
            List components = this.componentDao.queryList(queryParam);
            pageInfo = new PageInfo(components);
        }
        finally {
            PageHelper.clearPage();
        }
        ArrayList<ComponentVO> dtoList = new ArrayList<ComponentVO>();
        for (Component component : pageInfo.getList()) {
            try {
                ComponentVO componentVO = this.translate(component);
                dtoList.add(componentVO);
            }
            catch (Exception ex) {
                logger.error("translate item info error,itemId:{}", (Object)component.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(dtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public int delete(Component component) {
        return this.componentDao.deleteById(component.getId());
    }

    public Component queryById(Integer id) {
        if (id == 0) {
            return null;
        }
        return this.componentDao.queryById(id);
    }
}

