/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.view.LimitValue;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.enums.LimitTypeEnum;
import com.dtstep.lighthouse.common.modal.Component;
import com.dtstep.lighthouse.common.modal.LimitDataObject;
import com.dtstep.lighthouse.common.modal.RenderConfig;
import com.dtstep.lighthouse.common.modal.RenderFilterConfig;
import com.dtstep.lighthouse.common.modal.StatDataObject;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.core.batch.BatchAdapter;
import com.dtstep.lighthouse.core.storage.limit.LimitStorageSelector;
import com.dtstep.lighthouse.core.storage.limit.impl.RedisLimitStorageEngine;
import com.dtstep.lighthouse.core.storage.result.ResultStorageSelector;
import com.dtstep.lighthouse.insights.service.ComponentService;
import com.dtstep.lighthouse.insights.service.DataService;
import com.dtstep.lighthouse.insights.service.impl.DataServiceImpl;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DataServiceImpl
implements DataService {
    private static final Logger logger = LoggerFactory.getLogger(DataServiceImpl.class);
    @Autowired
    private ComponentService componentService;

    public List<String> dimensArrangement(StatExtEntity statExtEntity, LinkedHashMap<String, String[]> dimensParams) throws Exception {
        Object[] dimensArray = statExtEntity.getTemplateEntity().getDimensArray();
        if (ArrayUtils.isEmpty((Object[])dimensArray)) {
            return null;
        }
        if (MapUtils.isEmpty(dimensParams)) {
            return null;
        }
        List<Object> destSortedList = Arrays.asList(dimensArray);
        ArrayList<String> originSortedList = new ArrayList<String>();
        for (String dimens : dimensParams.keySet()) {
            if (!dimens.contains(";")) {
                originSortedList.add(dimens);
                continue;
            }
            String[] arr = dimens.split(";");
            originSortedList.addAll(Arrays.asList(arr));
        }
        String[][] valuesArray = (String[][])dimensParams.values().toArray((T[])new String[0][0]);
        List unSortedList = this.arrangement(valuesArray);
        return unSortedList.stream().map(z -> {
            String[] arr = z.split(";");
            DimensEntity[] entity = new DimensEntity[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                DimensEntity pair;
                entity[i] = pair = new DimensEntity((String)originSortedList.get(i), arr[i]);
            }
            List sortedList = Arrays.stream(entity).sorted((Comparator<DimensEntity>)new CustomComparator(destSortedList)).collect(Collectors.toList());
            return sortedList.stream().map(DimensEntity::getValue).collect(Collectors.joining(";"));
        }).collect(Collectors.toList());
    }

    public LinkedHashMap<String, String> dimensArrangementV2(StatExtEntity statExtEntity, LinkedHashMap<String, String[]> dimensParams) throws Exception {
        Object[] dimensArray = statExtEntity.getTemplateEntity().getDimensArray();
        if (ArrayUtils.isEmpty((Object[])dimensArray)) {
            return null;
        }
        if (MapUtils.isEmpty(dimensParams)) {
            return null;
        }
        List<Object> destSortedList = Arrays.asList(dimensArray);
        ArrayList<String> originSortedList = new ArrayList<String>();
        for (String dimens : dimensParams.keySet()) {
            if (!dimens.contains(";")) {
                originSortedList.add(dimens);
                continue;
            }
            String[] arr = dimens.split(";");
            originSortedList.addAll(Arrays.asList(arr));
        }
        String[][] valuesArray = (String[][])dimensParams.values().toArray((T[])new String[0][0]);
        List unSortedList = this.arrangement(valuesArray);
        LinkedHashMap<String, String> dimensMapperMap = new LinkedHashMap<String, String>();
        for (String item : unSortedList) {
            String[] arr = item.split(";");
            DimensEntity[] entity = new DimensEntity[arr.length];
            for (int m = 0; m < arr.length; ++m) {
                DimensEntity pair;
                entity[m] = pair = new DimensEntity((String)originSortedList.get(m), arr[m]);
            }
            List sortedList = Arrays.stream(entity).sorted((Comparator<DimensEntity>)new CustomComparator(destSortedList)).collect(Collectors.toList());
            ArrayList<String> dimensValueList = new ArrayList<String>();
            ArrayList<String> dimensDisplayValueList = new ArrayList<String>();
            for (DimensEntity dimensEntity : sortedList) {
                String value = dimensEntity.getValue();
                if (value.contains(",")) {
                    String[] mapperArr = value.split(",");
                    String tempValue = mapperArr[0];
                    String tempDisplayValue = mapperArr[1];
                    if (tempDisplayValue.equals("--")) {
                        tempDisplayValue = tempValue;
                    }
                    dimensValueList.add(tempValue);
                    dimensDisplayValueList.add(tempDisplayValue);
                    continue;
                }
                dimensValueList.add(value);
                dimensDisplayValueList.add(value);
            }
            String dimensValueStr = String.join((CharSequence)";", dimensValueList);
            String dimensDisplayValueStr = String.join((CharSequence)";", dimensDisplayValueList);
            dimensMapperMap.put(dimensValueStr, dimensDisplayValueStr);
        }
        return dimensMapperMap;
    }

    public List<String> arrangement(String[] ... datas) {
        ArrayList<String> result = new ArrayList<String>();
        this.beArrangement(result, "", datas, 0);
        return result;
    }

    private void beArrangement(List<String> result, String current, String[][] lists, int index) {
        if (index == lists.length) {
            result.add(current);
            return;
        }
        for (String item : lists[index]) {
            this.beArrangement(result, current + (current.isEmpty() ? "" : ";") + item, lists, index + 1);
        }
    }

    public ServiceResult<List<StatDataObject>> dataQuery(StatExtEntity statExtEntity, LocalDateTime startTime, LocalDateTime endTime, List<String> dimensList) throws Exception {
        List<String> eliminateDimensList;
        long startTimeStamp = DateUtil.translateToTimeStamp((LocalDateTime)startTime);
        long endTimeStamp = DateUtil.translateToTimeStamp((LocalDateTime)endTime);
        List batchList = null;
        try {
            batchList = BatchAdapter.queryBatchTimeList((String)statExtEntity.getTimeparam(), (long)startTimeStamp, (long)endTimeStamp);
        }
        catch (Exception ex) {
            logger.error("query batch time list error!", (Throwable)ex);
        }
        Validate.notNull((Object)batchList);
        HashMap<String, String> dimensValueMapping = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(dimensList)) {
            eliminateDimensList = new ArrayList<String>();
            for (String value : dimensList) {
                StringBuilder sbr1 = new StringBuilder();
                StringBuilder sbr2 = new StringBuilder();
                String[] dimensArr = value.split(";");
                for (int i = 0; i < dimensArr.length; ++i) {
                    String dimens = dimensArr[i];
                    String[] mapArr = dimens.split(",");
                    if (i != 0) {
                        sbr1.append(";");
                        sbr2.append(";");
                    }
                    if (mapArr.length == 2) {
                        sbr1.append(mapArr[0]);
                        sbr2.append(mapArr[1]);
                        continue;
                    }
                    sbr1.append(dimens);
                    sbr2.append(dimens);
                }
                eliminateDimensList.add(sbr1.toString());
                dimensValueMapping.put(sbr1.toString(), sbr2.toString());
            }
        } else {
            eliminateDimensList = dimensList;
        }
        if (eliminateDimensList != null && eliminateDimensList.size() * batchList.size() > 150000) {
            return ServiceResult.result((ResultCode)ResultCode.dataQueryLimitExceed);
        }
        LinkedHashMap valuesMap = ResultStorageSelector.queryWithDimensList((StatExtEntity)statExtEntity, eliminateDimensList, (List)batchList);
        ArrayList<StatDataObject> dataObjects = new ArrayList<StatDataObject>();
        if (MapUtils.isNotEmpty((Map)valuesMap)) {
            for (String dimensValue : valuesMap.keySet()) {
                StatDataObject dataObject = new StatDataObject();
                List valueList = (List)valuesMap.get(dimensValue);
                dataObject.setDimensValue(dimensValue);
                dataObject.setDisplayDimensValue((String)dimensValueMapping.get(dimensValue));
                dataObject.setValuesList(valueList);
                dataObject.setStatId(statExtEntity.getId());
                dataObjects.add(dataObject);
            }
        }
        return ServiceResult.success(dataObjects);
    }

    private static void filterConfigNodesByLevel(List<TreeNode> nodes, int targetLevel, int currentLevel, List<TreeNode> result) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        if (currentLevel == targetLevel) {
            result.addAll(nodes);
            return;
        }
        for (TreeNode node : nodes) {
            DataServiceImpl.filterConfigNodesByLevel((List)node.getChildren(), (int)targetLevel, (int)(currentLevel + 1), result);
        }
    }

    public List<LimitDataObject> limitQuery(StatExtEntity statExtEntity, List<Long> batchTimeList) throws Exception {
        HashMap<String, String> mappingData;
        ArrayList resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(batchTimeList)) {
            return resultList;
        }
        String[] dimensArray = statExtEntity.getTemplateEntity().getDimensArray();
        List<String> dimensList = Arrays.asList(dimensArray);
        HashMap allMappingData = new HashMap();
        RenderConfig renderConfig = statExtEntity.getRenderConfig();
        if (renderConfig != null && CollectionUtils.isNotEmpty((Collection)renderConfig.getFilters())) {
            List renderFilterConfigs = renderConfig.getFilters();
            for (RenderFilterConfig renderFilterConfig : renderFilterConfigs) {
                Component component;
                Integer componentId = renderFilterConfig.getComponentId();
                if (componentId == 0 || (component = this.componentService.queryById(componentId)) == null) continue;
                List configData = component.getConfiguration();
                String renderDimens = renderFilterConfig.getDimens();
                String[] renderDimensArr = renderDimens.split(";");
                for (int i = 0; i < renderDimensArr.length; ++i) {
                    String singleDimens = renderDimensArr[i];
                    if (!dimensList.contains(singleDimens)) {
                        logger.error("The statistical filtering dimension is not included,statId:{},dimens:{},singleDimens:{}", new Object[]{statExtEntity.getId(), statExtEntity.getTemplateEntity().getDimens(), singleDimens});
                        continue;
                    }
                    ArrayList levelData = new ArrayList();
                    DataServiceImpl.filterConfigNodesByLevel((List)configData, (int)i, (int)0, levelData);
                    if (!CollectionUtils.isNotEmpty(levelData)) continue;
                    mappingData = new HashMap<String, String>();
                    for (TreeNode treeNode : levelData) {
                        mappingData.put(treeNode.getValue().toString(), treeNode.getLabel());
                    }
                    allMappingData.put(singleDimens, mappingData);
                }
            }
        }
        for (Long batchTime : batchTimeList) {
            List valueList = LimitStorageSelector.query((StatExtEntity)statExtEntity, (long)batchTime);
            if (CollectionUtils.isNotEmpty((Collection)valueList)) {
                for (LimitValue limitValue : valueList) {
                    String dimensValue;
                    String displayDimensValue = dimensValue = limitValue.getDimensValue();
                    String[] dimensValueArr = dimensValue.split(";");
                    if (dimensValueArr.length != statExtEntity.getTemplateEntity().getDimensArray().length) {
                        logger.error("The dimension value and the data format of the dimension do not match,statId:{},dimens:{},dimensValue:{}", new Object[]{statExtEntity.getId(), statExtEntity.getTemplateEntity().getDimens(), dimensValue});
                    } else {
                        ArrayList<String> displayValueList = new ArrayList<String>();
                        for (int i = 0; i < dimensValueArr.length; ++i) {
                            String dimens = dimensArray[i];
                            mappingData = (HashMap<String, String>)allMappingData.get(dimens);
                            if (mappingData != null && mappingData.containsKey(dimensValueArr[i])) {
                                String displayValue = (String)mappingData.get(dimensValueArr[i]);
                                displayValueList.add(displayValue);
                                continue;
                            }
                            displayValueList.add(dimensValueArr[i]);
                        }
                        displayDimensValue = String.join((CharSequence)";", displayValueList);
                    }
                    limitValue.setDisplayDimensValue(displayDimensValue);
                }
            }
            LimitDataObject dataObject = new LimitDataObject();
            dataObject.setValues(valueList);
            dataObject.setBatchTime(batchTime);
            dataObject.setDisplayBatchTime(BatchAdapter.dateTimeFormat((String)statExtEntity.getTimeparam(), (long)batchTime));
            resultList.add(dataObject);
        }
        return resultList;
    }

    public ServiceResult<List<StatDataObject>> testDataQuery(StatExtEntity statExtEntity, LocalDateTime startTime, LocalDateTime endTime, List<String> dimensList) throws Exception {
        Object dimensArr;
        Object sbr1;
        List<String> eliminateDimensList;
        long startTimeStamp = DateUtil.translateToTimeStamp((LocalDateTime)startTime);
        long endTimeStamp = DateUtil.translateToTimeStamp((LocalDateTime)endTime);
        List batchList = null;
        try {
            batchList = BatchAdapter.queryBatchTimeList((String)statExtEntity.getTimeparam(), (long)startTimeStamp, (long)endTimeStamp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Validate.notNull((Object)batchList);
        ArrayList<StatDataObject> objectList = new ArrayList<StatDataObject>();
        HashMap<String, String> dimensValueMapping = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(dimensList)) {
            eliminateDimensList = new ArrayList<String>();
            for (String value : dimensList) {
                sbr1 = new StringBuilder();
                StringBuilder sbr2 = new StringBuilder();
                dimensArr = value.split(";");
                for (int i = 0; i < ((String[])dimensArr).length; ++i) {
                    Object dimens = dimensArr[i];
                    String[] mapArr = ((String)dimens).split(",");
                    if (i != 0) {
                        ((StringBuilder)sbr1).append(";");
                        sbr2.append(";");
                    }
                    if (mapArr.length == 2) {
                        ((StringBuilder)sbr1).append(mapArr[0]);
                        sbr2.append(mapArr[1]);
                        continue;
                    }
                    ((StringBuilder)sbr1).append((String)dimens);
                    sbr2.append((String)dimens);
                }
                eliminateDimensList.add(((StringBuilder)sbr1).toString());
                dimensValueMapping.put(((StringBuilder)sbr1).toString(), sbr2.toString());
            }
        } else {
            eliminateDimensList = dimensList;
        }
        List statStates = statExtEntity.getTemplateEntity().getStatStateList();
        if (eliminateDimensList == null) {
            ArrayList<StatValue> statValues = new ArrayList<StatValue>();
            sbr1 = batchList.iterator();
            while (sbr1.hasNext()) {
                long batchTime = (Long)sbr1.next();
                StatValue statValue = new StatValue();
                statValue.setValue((Object)(5000 + ThreadLocalRandom.current().nextInt(1000)));
                statValue.setBatchTime(batchTime);
                statValue.setDisplayBatchTime(BatchAdapter.dateTimeFormat((String)statExtEntity.getTimeparam(), (long)batchTime));
                ArrayList<Integer> statesValue = new ArrayList<Integer>();
                for (int i = 0; i < statStates.size(); ++i) {
                    statesValue.add(5000 + ThreadLocalRandom.current().nextInt(1000));
                }
                statValue.setStatesValue(statesValue);
                statValues.add(statValue);
            }
            StatDataObject statDataObject = new StatDataObject();
            statDataObject.setStatId(statExtEntity.getId());
            statDataObject.setValuesList(statValues);
            objectList.add(statDataObject);
        } else {
            if (eliminateDimensList.size() * batchList.size() > 150000) {
                return ServiceResult.result((ResultCode)ResultCode.dataQueryLimitExceed);
            }
            for (String dimens : eliminateDimensList) {
                ArrayList<StatValue> statValues = new ArrayList<StatValue>();
                dimensArr = batchList.iterator();
                while (dimensArr.hasNext()) {
                    long batchTime = (Long)dimensArr.next();
                    StatValue statValue = new StatValue();
                    statValue.setValue((Object)(5000 + ThreadLocalRandom.current().nextInt(1000)));
                    statValue.setBatchTime(batchTime);
                    statValue.setDisplayBatchTime(BatchAdapter.dateTimeFormat((String)statExtEntity.getTimeparam(), (long)batchTime));
                    ArrayList<Integer> statesValue = new ArrayList<Integer>();
                    for (int i = 0; i < statStates.size(); ++i) {
                        statesValue.add(5000 + ThreadLocalRandom.current().nextInt(1000));
                    }
                    statValue.setStatesValue(statesValue);
                    statValues.add(statValue);
                }
                StatDataObject statDataObject = new StatDataObject();
                statDataObject.setStatId(statExtEntity.getId());
                statDataObject.setDimensValue(dimens);
                statDataObject.setDisplayDimensValue((String)dimensValueMapping.get(dimens));
                statDataObject.setValuesList(statValues);
                objectList.add(statDataObject);
            }
        }
        return ServiceResult.success(objectList);
    }

    public List<LimitDataObject> testLimitQuery(StatExtEntity statExtEntity, List<Long> batchTimeList) throws Exception {
        ArrayList resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(batchTimeList)) {
            return resultList;
        }
        for (Long batchTime : batchTimeList) {
            ArrayList<LimitValue> valueList = new ArrayList<LimitValue>();
            for (int i = 0; i < 10; ++i) {
                LimitValue limitValue = new LimitValue("test_" + i, (Object)ThreadLocalRandom.current().nextInt(1000));
                valueList.add(limitValue);
            }
            if (statExtEntity.getTemplateEntity().getLimitTypeEnum() == LimitTypeEnum.TOP) {
                valueList.sort(RedisLimitStorageEngine.descComparator);
            } else {
                valueList.sort(RedisLimitStorageEngine.ascComparator);
            }
            LimitDataObject dataObject = new LimitDataObject();
            dataObject.setValues(valueList);
            dataObject.setBatchTime(batchTime);
            dataObject.setDisplayBatchTime(BatchAdapter.dateTimeFormat((String)statExtEntity.getTimeparam(), (long)batchTime));
            resultList.add(dataObject);
        }
        return resultList;
    }
}

