/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.modal.Department;
import com.dtstep.lighthouse.common.modal.Domain;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.insights.dao.DepartmentDao;
import com.dtstep.lighthouse.insights.service.DepartmentService;
import com.dtstep.lighthouse.insights.service.DomainService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.RoleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private DomainService domainService;
    @Autowired
    private PermissionService permissionService;

    @Transactional
    public int create(Department department) {
        Date date = new Date();
        department.setUpdateTime(date);
        department.setCreateTime(date);
        this.departmentDao.insert(department);
        int departmentId = department.getId();
        ArrayList roleList = new ArrayList();
        if (department.getPid() == 0) {
            Integer resourcePid = this.domainService.queryDefault().getId();
            this.resourceService.addResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)departmentId, (ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)resourcePid));
        } else {
            Integer resourcePid = department.getPid();
            this.resourceService.addResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)departmentId, (ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)resourcePid));
        }
        return department.getId();
    }

    @Transactional
    public int update(Department department) {
        int result = this.departmentDao.update(department);
        if (department.getPid() == 0) {
            Integer resourcePid = this.domainService.queryDefault().getId();
            this.resourceService.updateResourcePidCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)department.getId(), (ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)resourcePid));
        } else {
            Integer resourcePid = department.getPid();
            this.resourceService.updateResourcePidCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)department.getId(), (ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)resourcePid));
        }
        return result;
    }

    @Transactional
    public int delete(Department department) {
        Validate.notNull((Object)department);
        int result = this.departmentDao.deleteById(department.getId());
        if (department.getPid() == 0) {
            Domain domain = this.domainService.queryDefault();
            Integer resourcePid = domain.getId();
            this.resourceService.deleteResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)department.getId(), (ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)resourcePid));
        } else {
            Integer resourcePid = department.getPid();
            this.resourceService.deleteResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)department.getId(), (ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)resourcePid));
        }
        return result;
    }

    public Department queryById(Integer id) {
        return this.departmentDao.queryById(id);
    }

    public List<TreeNode> getStructure() {
        List departmentList = this.queryAll();
        HashMap<Integer, TreeNode> departmentMap = new HashMap<Integer, TreeNode>();
        for (Department department : departmentList) {
            TreeNode treeNode = new TreeNode(department.getName(), (Object)department.getId());
            departmentMap.put(department.getId(), treeNode);
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (Department department : departmentList) {
            TreeNode currentNode = (TreeNode)departmentMap.get(department.getId());
            int pid = department.getPid();
            if (pid == 0) {
                nodeList.add(currentNode);
                continue;
            }
            TreeNode parentNode = (TreeNode)departmentMap.get(pid);
            if (parentNode != null) {
                List<TreeNode> children = parentNode.getChildren() == null ? new ArrayList() : parentNode.getChildren();
                children.add(currentNode);
                parentNode.setChildren(children);
                continue;
            }
            nodeList.add(currentNode);
        }
        return nodeList;
    }

    public List<Department> queryAll() {
        return this.departmentDao.queryAll();
    }

    public int getLevel(Integer id) {
        return this.departmentDao.getLevel(id);
    }

    public int getChildLevel(Integer pid) {
        return this.departmentDao.getChildLevel(pid);
    }

    public int countChildByPid(Integer pid) {
        return this.departmentDao.countChildByPid(pid);
    }

    public String getFullPath(Integer id) {
        return this.departmentDao.getFullPath(id);
    }
}

