/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.enums.ComponentTypeEnum;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.RenderFilterConfig;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.core.storage.dimens.DimensStorageSelector;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.insights.dto.ComponentQueryParam;
import com.dtstep.lighthouse.insights.dto.FilterQueryParam;
import com.dtstep.lighthouse.insights.dto.StatQueryParam;
import com.dtstep.lighthouse.insights.service.ComponentService;
import com.dtstep.lighthouse.insights.service.FilterService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.util.TreeUtil;
import com.dtstep.lighthouse.insights.vo.ComponentVO;
import com.dtstep.lighthouse.insights.vo.StatVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilterServiceImpl
implements FilterService {
    @Autowired
    private StatService statService;
    @Autowired
    private ComponentService componentService;

    public ListData<RenderFilterConfig> queryDefaultList(String token, Integer pageNum, Integer pageSize) throws Exception {
        GroupExtEntity groupExtEntity = GroupDBWrapper.queryByToken((String)token);
        Validate.notNull((Object)groupExtEntity);
        StatQueryParam statQueryParam = new StatQueryParam();
        statQueryParam.setGroupIds(List.of(groupExtEntity.getId()));
        ListData statList = this.statService.queryList(statQueryParam, Integer.valueOf(1), Integer.valueOf(500));
        HashSet<Object> dimensSet = new HashSet<Object>();
        for (StatVO statVO : statList.getList()) {
            Object[] dimensArray = statVO.getTemplateEntity().getDimensArray();
            if (!ArrayUtils.isNotEmpty((Object[])dimensArray)) continue;
            List<Object> list = Arrays.asList(dimensArray);
            dimensSet.addAll(list);
        }
        ArrayList<RenderFilterConfig> resultList = new ArrayList<RenderFilterConfig>();
        int startRow = (pageNum - 1) * pageSize;
        int endRow = Math.min(pageNum * pageSize, dimensSet.size());
        ArrayList dimensList = new ArrayList(dimensSet);
        for (int i = startRow; i < endRow; ++i) {
            String dimens = (String)dimensList.get(i);
            List dimensValueList = DimensStorageSelector.query((Group)groupExtEntity, (String)dimens, null, (int)1000);
            List treeNodes = dimensValueList.stream().map(z -> new TreeNode(z, z)).collect(Collectors.toList());
            RenderFilterConfig renderFilterConfig = new RenderFilterConfig();
            renderFilterConfig.setComponentType(ComponentTypeEnum.FILTER_SELECT);
            renderFilterConfig.setComponentId(Integer.valueOf(0));
            renderFilterConfig.setLabel(dimens);
            renderFilterConfig.setToken(token);
            renderFilterConfig.setDimens(dimens);
            renderFilterConfig.setConfigData(treeNodes);
            resultList.add(renderFilterConfig);
        }
        return ListData.newInstance(resultList, (long)dimensList.size(), (int)pageNum, (int)pageSize);
    }

    public ListData<RenderFilterConfig> queryCustomList(FilterQueryParam queryParam, Integer pageNum, Integer pageSize) throws Exception {
        ComponentQueryParam componentQueryParam = new ComponentQueryParam();
        componentQueryParam.setSearch(queryParam.getSearch());
        ListData listData = this.componentService.queryList(componentQueryParam, pageNum, pageSize);
        if (listData == null) {
            return null;
        }
        ArrayList<RenderFilterConfig> resultList = new ArrayList<RenderFilterConfig>();
        if (CollectionUtils.isNotEmpty((Collection)listData.getList())) {
            for (ComponentVO componentVO : listData.getList()) {
                RenderFilterConfig renderFilterConfig = new RenderFilterConfig();
                renderFilterConfig.setComponentType(ComponentTypeEnum.FILTER_SELECT);
                int level = TreeUtil.getMaxLevel((List)componentVO.getConfiguration());
                renderFilterConfig.setMaxLevel(Integer.valueOf(level));
                renderFilterConfig.setComponentId(componentVO.getId());
                renderFilterConfig.setTitle(componentVO.getTitle());
                renderFilterConfig.setConfigData(componentVO.getConfiguration());
                resultList.add(renderFilterConfig);
            }
        }
        return ListData.newInstance(resultList, (long)listData.getTotal(), (int)pageNum, (int)pageSize);
    }
}

