/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.SwitchStateEnum;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.core.formula.FormulaTranslate;
import com.dtstep.lighthouse.core.rowkey.KeyGenerator;
import com.dtstep.lighthouse.core.rowkey.impl.DefaultKeyGenerator;
import com.dtstep.lighthouse.core.storage.dimens.DimensStorageSelector;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngineProxy;
import com.dtstep.lighthouse.core.template.TemplateContext;
import com.dtstep.lighthouse.core.template.TemplateParser;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.dtstep.lighthouse.insights.dao.GroupDao;
import com.dtstep.lighthouse.insights.dao.ProjectDao;
import com.dtstep.lighthouse.insights.dto.DimensValueDeleteParam;
import com.dtstep.lighthouse.insights.dto.GroupQueryParam;
import com.dtstep.lighthouse.insights.service.GroupService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.vo.GroupVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupServiceImpl
implements GroupService {
    private static final Logger logger = LoggerFactory.getLogger(GroupServiceImpl.class);
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private StatService statService;
    @Autowired
    private ResourceService resourceService;
    private static final KeyGenerator keyGenerator = new DefaultKeyGenerator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<GroupVO> queryList(GroupQueryParam groupQueryParam, Integer pageNum, Integer pageSize) throws Exception {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ArrayList<GroupVO> dtoList = new ArrayList<GroupVO>();
        try {
            List list = this.groupDao.queryList(groupQueryParam);
            pageInfo = new PageInfo(list);
        }
        finally {
            PageHelper.clearPage();
        }
        for (Group group : pageInfo.getList()) {
            try {
                GroupExtEntity groupExtEntity = GroupDBWrapper.combineExtInfo((Group)group);
                GroupVO groupVO = new GroupVO(groupExtEntity);
                dtoList.add(groupVO);
            }
            catch (Exception ex) {
                logger.error("translate item info error,itemId:{}!", (Object)group.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(dtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    @Transactional
    public int create(Group group) {
        LocalDateTime localDateTime = LocalDateTime.now();
        group.setSecretKey(RandomID.id((int)40));
        group.setCreateTime(localDateTime);
        group.setUpdateTime(localDateTime);
        group.setRefreshTime(localDateTime);
        group.setRandomId(RandomID.id((int)32));
        group.setState(GroupStateEnum.RUNNING);
        group.setDebugMode(SwitchStateEnum.CLOSE);
        this.groupDao.insert(group);
        this.resourceService.addResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Group, (Integer)group.getId(), (ResourceTypeEnum)ResourceTypeEnum.Project, (Integer)group.getProjectId()));
        return group.getId();
    }

    @Transactional
    public int update(Group group) {
        LocalDateTime localDateTime = LocalDateTime.now();
        group.setUpdateTime(localDateTime);
        int result = this.groupDao.update(group);
        this.resourceService.updateResourcePidCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Group, (Integer)group.getId(), (ResourceTypeEnum)ResourceTypeEnum.Project, (Integer)group.getProjectId()));
        return result;
    }

    @Transactional
    public int delete(Group group) {
        Validate.notNull((Object)group);
        Integer id = group.getId();
        this.resourceService.deleteResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Group, (Integer)group.getId(), (ResourceTypeEnum)ResourceTypeEnum.Project, (Integer)group.getProjectId()));
        return this.groupDao.deleteById(id);
    }

    public GroupVO queryById(Integer id) throws Exception {
        GroupExtEntity groupExtEntity;
        if (BuiltinLoader.isBuiltinGroup((int)id)) {
            groupExtEntity = BuiltinLoader.getBuiltinGroup((int)id);
        } else {
            Group group = this.groupDao.queryById(id);
            if (group == null) {
                return null;
            }
            groupExtEntity = GroupDBWrapper.combineExtInfo((Group)group);
        }
        GroupVO groupVO = new GroupVO(groupExtEntity);
        Set relatedColumns = this.getRelatedColumns((Group)groupExtEntity);
        groupVO.setRelatedColumns(relatedColumns);
        return groupVO;
    }

    public Set<String> getRelatedColumns(Group group) throws Exception {
        HashSet<String> relatedColumnSet = new HashSet<String>();
        List columnList = group.getColumns();
        List statList = StatDBWrapper.queryStatByGroupIDFromDB((int)group.getId());
        if (CollectionUtils.isNotEmpty((Collection)statList)) {
            for (Stat stat : statList) {
                List dimensRelatedColumns;
                String dimens;
                String template = stat.getTemplate();
                ServiceResult serviceResult = TemplateParser.parseConfig((TemplateContext)new TemplateContext(stat.getId().intValue(), template, stat.getTimeparam(), columnList));
                if (!serviceResult.isSuccess()) {
                    logger.error("load stat error,id:{},template:{}.", (Object)stat.getId(), (Object)template);
                    continue;
                }
                List statRelatedColumns = FormulaTranslate.queryRelatedColumns((List)columnList, (String)template);
                if (CollectionUtils.isNotEmpty((Collection)statRelatedColumns)) {
                    for (Column column : statRelatedColumns) {
                        relatedColumnSet.add(column.getName());
                    }
                }
                if (StringUtil.isEmpty((String)(dimens = ((TemplateEntity)serviceResult.getData()).getDimens())) || !CollectionUtils.isNotEmpty((Collection)(dimensRelatedColumns = FormulaTranslate.queryRelatedColumns((List)columnList, (String)dimens)))) continue;
                for (Column column : dimensRelatedColumns) {
                    relatedColumnSet.add(column.getName());
                }
            }
        }
        return relatedColumnSet;
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryById' + '_' + #id", cacheManager="caffeineCacheManager", unless="#result == null")
    public Group cacheQueryById(Integer id) {
        return this.groupDao.queryById(id);
    }

    public List<Group> queryByProjectId(Integer projectId) {
        return this.groupDao.queryByProjectId(projectId);
    }

    public int count(GroupQueryParam queryParam) {
        return this.groupDao.count(queryParam);
    }

    public String getSecretKey(Integer id) {
        return this.groupDao.getSecretKey(id);
    }

    public List<String> queryDimensList(Integer id) throws Exception {
        GroupVO groupEntity = this.queryById(id);
        if (groupEntity == null) {
            return null;
        }
        List statList = this.statService.queryByGroupId(id);
        ArrayList<String> dimensList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)statList)) {
            List columnList = groupEntity.getColumns();
            for (Stat stat : statList) {
                List dimensRelatedColumns;
                String template = stat.getTemplate();
                ServiceResult serviceResult = TemplateParser.parseConfig((TemplateContext)new TemplateContext(stat.getId().intValue(), template, stat.getTimeparam(), columnList));
                if (!serviceResult.isSuccess()) {
                    logger.error("load stat error,id:{},template:{}.", (Object)stat.getId(), (Object)template);
                    continue;
                }
                String dimens = ((TemplateEntity)serviceResult.getData()).getDimens();
                if (StringUtil.isEmpty((String)dimens) || !CollectionUtils.isNotEmpty((Collection)(dimensRelatedColumns = FormulaTranslate.queryRelatedColumns((List)columnList, (String)dimens)))) continue;
                for (Column relatedColumn : dimensRelatedColumns) {
                    String columnName = relatedColumn.getName();
                    if (dimensList.contains(columnName)) continue;
                    dimensList.add(columnName);
                }
            }
        }
        return dimensList;
    }

    public List<String> queryDimensValueList(Integer groupId, String dimens) throws Exception {
        GroupVO groupEntity = this.queryById(groupId);
        if (groupEntity == null) {
            return null;
        }
        return DimensStorageSelector.query((Group)groupEntity, (String)dimens, null, (int)1000);
    }

    public void deleteDimensValue(List<DimensValueDeleteParam> deleteParams) throws Exception {
        ArrayList<CallSite> keyList = new ArrayList<CallSite>();
        if (CollectionUtils.isNotEmpty(deleteParams)) {
            for (DimensValueDeleteParam deleteParam : deleteParams) {
                int groupId = deleteParam.getGroupId();
                GroupExtEntity group = GroupDBWrapper.queryById((int)groupId);
                if (group == null) continue;
                String dimens = deleteParam.getDimens();
                String dimensValue = deleteParam.getDimensValue();
                String rowKey = keyGenerator.dimensKey((Group)group, dimens, dimensValue);
                keyList.add((CallSite)((Object)(rowKey + ";v")));
            }
        }
        WarehouseStorageEngineProxy.getInstance().deletes("ldp_dimens_records", keyList);
    }

    public void clearDimensValue(Integer groupId) throws Exception {
        Group dbGroup = this.groupDao.queryById(groupId);
        if (dbGroup == null) {
            return;
        }
        dbGroup.setDataVersion(Integer.valueOf(dbGroup.getDataVersion() + 1));
        this.update(dbGroup);
    }
}

