/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.enums.MetaTableTypeEnum;
import com.dtstep.lighthouse.common.modal.MetaTable;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngine;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngineProxy;
import com.dtstep.lighthouse.core.wrapper.MetaTableWrapper;
import com.dtstep.lighthouse.insights.dao.MetaTableDao;
import com.dtstep.lighthouse.insights.dto.MetaTableQueryParam;
import com.dtstep.lighthouse.insights.service.MetaTableService;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetaTableServiceImpl
implements MetaTableService {
    @Autowired
    private MetaTableDao metaTableDao;

    public int getCurrentStatResultTable() throws Exception {
        WarehouseStorageEngine warehouseStorageEngine = WarehouseStorageEngineProxy.getInstance();
        MetaTableQueryParam metaTableQueryParam = new MetaTableQueryParam();
        long maxTimeInterval = warehouseStorageEngine.getTableMaxValidPeriod();
        long timestamp = DateUtil.getSecondBefore((long)System.currentTimeMillis(), (long)maxTimeInterval);
        LocalDateTime startDate = DateUtil.timestampToLocalDateTime((long)timestamp);
        metaTableQueryParam.setStartDate(startDate);
        metaTableQueryParam.setMetaTableTypeEnum(MetaTableTypeEnum.STAT_RESULT_TABLE);
        MetaTable metaTable = this.metaTableDao.getCurrentStorageTable(metaTableQueryParam);
        int metaId = metaTable == null || !warehouseStorageEngine.isAppendable(metaTable.getMetaName()) ? MetaTableWrapper.createStatStorageAndMetaTable() : metaTable.getId();
        return metaId;
    }
}

