/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.modal.OrderDetail;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.insights.dao.OrderDetailDao;
import com.dtstep.lighthouse.insights.service.OrderDetailService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.OrderDetailVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderDetailServiceImpl
implements OrderDetailService {
    @Autowired
    private OrderDetailDao orderDetailDao;
    @Autowired
    private UserService userService;

    public List<OrderDetailVO> queryList(Integer orderId) {
        List orderDetails = this.orderDetailDao.queryList(orderId);
        ArrayList<OrderDetailVO> dtoList = new ArrayList<OrderDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)orderDetails)) {
            for (OrderDetail orderDetail : orderDetails) {
                OrderDetailVO orderDetailVO = new OrderDetailVO(orderDetail);
                Integer userId = orderDetail.getUserId();
                if (userId != null) {
                    User user = this.userService.cacheQueryById(userId.intValue());
                    orderDetailVO.setUser(user);
                }
                dtoList.add(orderDetailVO);
            }
        }
        return dtoList;
    }
}

