/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.FlowNode;
import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.ApproveStateEnum;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.enums.OrderStateEnum;
import com.dtstep.lighthouse.common.enums.OrderTypeEnum;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.enums.UserStateEnum;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.GroupExtendConfig;
import com.dtstep.lighthouse.common.modal.MetricSet;
import com.dtstep.lighthouse.common.modal.Order;
import com.dtstep.lighthouse.common.modal.OrderDetail;
import com.dtstep.lighthouse.common.modal.Permission;
import com.dtstep.lighthouse.common.modal.PermissionEnum;
import com.dtstep.lighthouse.common.modal.Project;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.modal.View;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.insights.dao.OrderDao;
import com.dtstep.lighthouse.insights.dao.OrderDetailDao;
import com.dtstep.lighthouse.insights.dao.PermissionDao;
import com.dtstep.lighthouse.insights.dto.ApplyOrderQueryParam;
import com.dtstep.lighthouse.insights.dto.ApproveOrderQueryParam;
import com.dtstep.lighthouse.insights.dto.OrderProcessParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.CallerService;
import com.dtstep.lighthouse.insights.service.DepartmentService;
import com.dtstep.lighthouse.insights.service.GroupService;
import com.dtstep.lighthouse.insights.service.OrderDetailService;
import com.dtstep.lighthouse.insights.service.OrderService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.service.ViewService;
import com.dtstep.lighthouse.insights.vo.CallerVO;
import com.dtstep.lighthouse.insights.vo.GroupVO;
import com.dtstep.lighthouse.insights.vo.OrderVO;
import com.dtstep.lighthouse.insights.vo.ProjectVO;
import com.dtstep.lighthouse.insights.vo.StatVO;
import com.dtstep.lighthouse.insights.vo.ViewVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private OrderDao orderDao;
    @Autowired
    private OrderDetailDao orderDetailDao;
    @Autowired
    private BaseService baseService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private StatService statService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ViewService viewService;
    @Autowired
    private CallerService callerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<OrderVO> queryApproveList(ApproveOrderQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        Integer currentUserId = this.baseService.getCurrentUserId();
        queryParam.setApproveUserId(currentUserId);
        PageHelper.startPage((int)pageNum, (int)pageSize, (String)"create_time desc");
        ArrayList<OrderVO> orderDtoList = new ArrayList<OrderVO>();
        try {
            List orders = this.orderDao.queryApproveList(queryParam, pageNum, pageSize);
            pageInfo = new PageInfo(orders);
        }
        finally {
            PageHelper.clearPage();
        }
        for (Order order : pageInfo.getList()) {
            try {
                OrderVO orderDto = this.translateApproveEntity(order);
                orderDtoList.add(orderDto);
            }
            catch (Exception ex) {
                logger.error("translate item info error,itemId:{}!", (Object)order.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(orderDtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<OrderVO> queryApplyList(ApplyOrderQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize, (String)"create_time desc");
        ArrayList<OrderVO> orderDtoList = new ArrayList<OrderVO>();
        PageInfo pageInfo = null;
        try {
            List orders = this.orderDao.queryApplyList(queryParam, pageNum, pageSize);
            pageInfo = new PageInfo(orders);
        }
        finally {
            PageHelper.clearPage();
        }
        for (Order order : pageInfo.getList()) {
            try {
                OrderVO orderVO = this.translateApplyEntity(order);
                orderDtoList.add(orderVO);
            }
            catch (Exception ex) {
                logger.error("translate item info error,itemId:{}!", (Object)order.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(orderDtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public OrderVO queryById(Integer id) throws Exception {
        Order order = this.orderDao.queryById(id);
        Validate.notNull((Object)order);
        OrderVO orderVO = this.translateApproveEntity(order);
        List orderDetails = this.orderDetailService.queryList(id);
        orderVO.setOrderDetails(orderDetails);
        List roleIds = orderVO.getSteps();
        HashMap adminsMap = new HashMap();
        for (Integer roleId : roleIds) {
            ArrayList<User> admins = new ArrayList<User>();
            List adminIds = this.permissionDao.queryUserPermissionsByRoleId(roleId, Integer.valueOf(5));
            for (Integer approveUserId : adminIds) {
                User user = this.userService.cacheQueryById(approveUserId.intValue());
                if (user == null) continue;
                admins.add(user);
            }
            adminsMap.put(roleId, admins);
        }
        orderVO.setAdminsMap(adminsMap);
        return orderVO;
    }

    private void checkAddRole(List<Role> list, Role role) {
        List roleIds = list.stream().map(Role::getId).collect(Collectors.toList());
        if (!roleIds.contains(role.getId())) {
            list.add(role);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> List<Role> getApproveRoleList(User applyUser, OrderTypeEnum orderTypeEnum, T param) throws Exception {
        List flow = orderTypeEnum.getDefaultWorkFlow();
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (FlowNode flowNode : flow) {
            Role role;
            RoleTypeEnum roleTypeEnum = flowNode.getRoleTypeEnum();
            if (roleTypeEnum == RoleTypeEnum.FULL_MANAGE_PERMISSION) {
                Role role2 = this.roleService.queryRole(roleTypeEnum, Integer.valueOf(0));
                this.checkAddRole(roleList, role2);
                continue;
            }
            if (roleTypeEnum == RoleTypeEnum.OPT_MANAGE_PERMISSION) {
                Role role3 = this.roleService.queryRole(roleTypeEnum, Integer.valueOf(0));
                this.checkAddRole(roleList, role3);
                continue;
            }
            if (roleTypeEnum == RoleTypeEnum.PROJECT_MANAGE_PERMISSION) {
                if (orderTypeEnum == OrderTypeEnum.PROJECT_ACCESS || orderTypeEnum == OrderTypeEnum.CALLER_PROJECT_ACCESS || orderTypeEnum == OrderTypeEnum.CALLER_PROJECT_ACCESS_EXTENSION) {
                    Project project = (Project)param;
                    role = this.roleService.queryRole(roleTypeEnum, project.getId());
                    this.checkAddRole(roleList, role);
                    continue;
                }
                if (orderTypeEnum != OrderTypeEnum.STAT_ACCESS && orderTypeEnum != OrderTypeEnum.CALLER_STAT_ACCESS && orderTypeEnum != OrderTypeEnum.CALLER_STAT_ACCESS_EXTENSION) continue;
                Stat stat = (Stat)param;
                role = this.roleService.queryRole(roleTypeEnum, stat.getProjectId());
                this.checkAddRole(roleList, role);
                continue;
            }
            if (roleTypeEnum == RoleTypeEnum.METRIC_MANAGE_PERMISSION) {
                MetricSet metricSet = (MetricSet)param;
                role = this.roleService.queryRole(roleTypeEnum, metricSet.getId());
                this.checkAddRole(roleList, role);
                continue;
            }
            if (roleTypeEnum == RoleTypeEnum.VIEW_MANAGE_PERMISSION) {
                View view = (View)param;
                role = this.roleService.queryRole(roleTypeEnum, view.getId());
                this.checkAddRole(roleList, role);
                continue;
            }
            if (roleTypeEnum != RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION) continue;
            int departmentId = 0;
            FlowNode.Extend extend = flowNode.getExtend();
            boolean itemNear = extend.isItemNear();
            if (itemNear) {
                if (orderTypeEnum == OrderTypeEnum.PROJECT_ACCESS) {
                    Project project = (Project)param;
                    departmentId = project.getDepartmentId();
                } else {
                    if (orderTypeEnum != OrderTypeEnum.STAT_ACCESS) throw new Exception();
                    Stat stat = (Stat)param;
                    ProjectVO project = this.projectService.queryById(stat.getProjectId());
                    departmentId = project.getDepartmentId();
                }
            } else {
                departmentId = applyUser.getDepartmentId();
            }
            Integer extendParam = (Integer)extend.getParam();
            if (extendParam == 0) {
                Role role4 = this.roleService.queryRole(RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION, Integer.valueOf(departmentId));
                this.checkAddRole(roleList, role4);
                continue;
            }
            String departmentFullPath = this.departmentService.getFullPath(Integer.valueOf(departmentId));
            String[] array = departmentFullPath.split(",");
            if (extendParam - 1 >= array.length) continue;
            Role role5 = this.roleService.queryRole(RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION, Integer.valueOf(Integer.parseInt(array[extendParam - 1])));
            this.checkAddRole(roleList, role5);
        }
        return roleList;
    }

    @Transactional
    public ResultCode submit(User applyUser, OrderTypeEnum orderTypeEnum, String reason, Map<String, Object> extendConfig) throws Exception {
        Integer permissionId;
        Role role;
        String message;
        CallerVO caller;
        Integer callerId;
        ViewVO view;
        Integer viewId;
        StatVO stat;
        Integer statId;
        String message2;
        ProjectVO project;
        Integer projectId;
        Validate.notNull((Object)applyUser);
        Validate.notNull((Object)orderTypeEnum);
        Order order = new Order();
        LocalDateTime localDateTime = LocalDateTime.now();
        order.setCreateTime(localDateTime);
        order.setUpdateTime(localDateTime);
        order.setOrderType(orderTypeEnum);
        order.setState(OrderStateEnum.PROCESSING);
        order.setReason(reason);
        order.setExtendConfig(extendConfig);
        order.setUserId(applyUser.getId());
        String hash = null;
        List roleList = null;
        if (order.getOrderType() == OrderTypeEnum.PROJECT_ACCESS) {
            if (!extendConfig.containsKey("projectId")) {
                return ResultCode.paramValidateFailed;
            }
            projectId = (Integer)extendConfig.get("projectId");
            project = this.projectService.queryById(projectId);
            Validate.notNull((Object)project);
            message2 = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + projectId;
            hash = Md5Util.getMD5((String)message2);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)project);
        } else if (order.getOrderType() == OrderTypeEnum.STAT_ACCESS) {
            if (!extendConfig.containsKey("statId")) {
                return ResultCode.paramValidateFailed;
            }
            statId = (Integer)extendConfig.get("statId");
            stat = this.statService.queryById(statId);
            Validate.notNull((Object)stat);
            message2 = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + statId;
            hash = Md5Util.getMD5((String)message2);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)stat);
        } else if (order.getOrderType() == OrderTypeEnum.VIEW_ACCESS) {
            if (!extendConfig.containsKey("viewId")) {
                return ResultCode.paramValidateFailed;
            }
            viewId = (Integer)extendConfig.get("viewId");
            view = this.viewService.queryById(viewId);
            Validate.notNull((Object)view);
            message2 = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + viewId;
            hash = Md5Util.getMD5((String)message2);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)view);
        } else if (order.getOrderType() == OrderTypeEnum.USER_PEND_APPROVE) {
            String message3 = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING;
            hash = Md5Util.getMD5((String)message3);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, null);
        } else if (order.getOrderType() == OrderTypeEnum.LIMITING_SETTINGS) {
            if (!extendConfig.containsKey("groupId")) {
                return ResultCode.paramValidateFailed;
            }
            Integer groupId = (Integer)extendConfig.get("groupId");
            String strategy = (String)extendConfig.get("strategy");
            message2 = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + groupId + "_" + strategy;
            hash = Md5Util.getMD5((String)message2);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, null);
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_PROJECT_ACCESS) {
            if (!extendConfig.containsKey("projectId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("callerId")) {
                return ResultCode.paramValidateFailed;
            }
            projectId = (Integer)extendConfig.get("projectId");
            project = this.projectService.queryById(projectId);
            Validate.notNull((Object)project);
            callerId = (Integer)extendConfig.get("callerId");
            caller = this.callerService.queryById(callerId);
            Validate.notNull((Object)caller);
            Role accessRole = this.roleService.queryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, projectId);
            Validate.notNull((Object)accessRole);
            boolean hasPermission = this.permissionService.existPermission(callerId, OwnerTypeEnum.CALLER, accessRole.getId());
            if (hasPermission) {
                return ResultCode.authAlreadyExists;
            }
            message = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + callerId + "_" + projectId;
            hash = Md5Util.getMD5((String)message);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)project);
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_STAT_ACCESS) {
            if (!extendConfig.containsKey("statId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("callerId")) {
                return ResultCode.paramValidateFailed;
            }
            statId = (Integer)extendConfig.get("statId");
            stat = this.statService.queryById(statId);
            Validate.notNull((Object)stat);
            callerId = (Integer)extendConfig.get("callerId");
            caller = this.callerService.queryById(callerId);
            Validate.notNull((Object)caller);
            role = this.roleService.queryRole(RoleTypeEnum.STAT_ACCESS_PERMISSION, statId);
            Validate.notNull((Object)role);
            boolean hasPermission = this.permissionService.existPermission(callerId, OwnerTypeEnum.CALLER, role.getId());
            if (hasPermission) {
                return ResultCode.authAlreadyExists;
            }
            message = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + callerId + "_" + statId;
            hash = Md5Util.getMD5((String)message);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)stat);
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_VIEW_ACCESS) {
            if (!extendConfig.containsKey("viewId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("callerId")) {
                return ResultCode.paramValidateFailed;
            }
            viewId = (Integer)extendConfig.get("viewId");
            view = this.viewService.queryById(viewId);
            Validate.notNull((Object)view);
            callerId = (Integer)extendConfig.get("callerId");
            caller = this.callerService.queryById(callerId);
            Validate.notNull((Object)caller);
            role = this.roleService.queryRole(RoleTypeEnum.VIEW_ACCESS_PERMISSION, viewId);
            Validate.notNull((Object)role);
            boolean hasPermission = this.permissionService.existPermission(callerId, OwnerTypeEnum.CALLER, role.getId());
            if (hasPermission) {
                return ResultCode.authAlreadyExists;
            }
            message = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + callerId + "_" + viewId;
            hash = Md5Util.getMD5((String)message);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)view);
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_PROJECT_ACCESS_EXTENSION) {
            if (!extendConfig.containsKey("projectId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("callerId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("permissionId")) {
                return ResultCode.paramValidateFailed;
            }
            projectId = (Integer)extendConfig.get("projectId");
            project = this.projectService.queryById(projectId);
            Validate.notNull((Object)project);
            callerId = (Integer)extendConfig.get("callerId");
            caller = this.callerService.queryById(callerId);
            Validate.notNull((Object)caller);
            permissionId = (Integer)extendConfig.get("permissionId");
            Permission permission = this.permissionService.queryById(permissionId);
            Validate.notNull((Object)permission);
            Validate.isTrue((permission.getOwnerId().intValue() == callerId.intValue() ? 1 : 0) != 0);
            message = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + callerId + "_" + projectId;
            hash = Md5Util.getMD5((String)message);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)project);
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_STAT_ACCESS_EXTENSION) {
            if (!extendConfig.containsKey("statId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("callerId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("permissionId")) {
                return ResultCode.paramValidateFailed;
            }
            statId = (Integer)extendConfig.get("statId");
            stat = this.statService.queryById(statId);
            Validate.notNull((Object)stat);
            callerId = (Integer)extendConfig.get("callerId");
            caller = this.callerService.queryById(callerId);
            Validate.notNull((Object)caller);
            permissionId = (Integer)extendConfig.get("permissionId");
            Permission permission = this.permissionService.queryById(permissionId);
            Validate.notNull((Object)permission);
            Validate.isTrue((permission.getOwnerId().intValue() == callerId.intValue() ? 1 : 0) != 0);
            message = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + callerId + "_" + statId;
            hash = Md5Util.getMD5((String)message);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)stat);
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_VIEW_ACCESS_EXTENSION) {
            if (!extendConfig.containsKey("viewId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("callerId")) {
                return ResultCode.paramValidateFailed;
            }
            if (!extendConfig.containsKey("permissionId")) {
                return ResultCode.paramValidateFailed;
            }
            viewId = (Integer)extendConfig.get("viewId");
            view = this.viewService.queryById(viewId);
            Validate.notNull((Object)view);
            callerId = (Integer)extendConfig.get("callerId");
            caller = this.callerService.queryById(callerId);
            Validate.notNull((Object)caller);
            permissionId = (Integer)extendConfig.get("permissionId");
            Permission permission = this.permissionService.queryById(permissionId);
            Validate.notNull((Object)permission);
            Validate.isTrue((permission.getOwnerId().intValue() == callerId.intValue() ? 1 : 0) != 0);
            message = order.getUserId() + "_" + order.getOrderType() + "_" + OrderStateEnum.PROCESSING + "_" + callerId + "_" + viewId;
            hash = Md5Util.getMD5((String)message);
            roleList = this.getApproveRoleList(applyUser, orderTypeEnum, (Object)view);
        } else {
            return ResultCode.orderTypeNotExists;
        }
        boolean isExist = this.orderDao.isExist(hash);
        if (isExist) {
            return ResultCode.orderCreateRepeatSubmit;
        }
        order.setHash(hash);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)roleList));
        order.setSteps(roleList.stream().map(Role::getId).collect(Collectors.toList()));
        order.setCurrentNode(CollectionUtils.isNotEmpty((Collection)roleList) ? ((Role)roleList.get(0)).getId() : null);
        this.orderDao.insert(order);
        int orderId = order.getId();
        ArrayList<OrderDetail> detailList = new ArrayList<OrderDetail>();
        for (int i = 0; i < roleList.size(); ++i) {
            role = (Role)roleList.get(i);
            OrderDetail orderDetail = new OrderDetail();
            RoleTypeEnum roleType = role.getRoleType();
            orderDetail.setCreateTime(localDateTime);
            orderDetail.setOrderId(Integer.valueOf(orderId));
            orderDetail.setRoleType(roleType);
            orderDetail.setUserId(applyUser.getId());
            orderDetail.setRoleId(role.getId());
            orderDetail.setState(i == 0 ? ApproveStateEnum.PENDING : ApproveStateEnum.WAIT);
            detailList.add(orderDetail);
        }
        this.orderDetailDao.batchInsert(detailList);
        return ResultCode.success;
    }

    public ResultCode batchSubmit(User applyUser, OrderTypeEnum orderTypeEnum, String reason, Map<String, Object> extendConfig) throws Exception {
        return null;
    }

    private OrderVO translateApproveEntity(Order order) throws Exception {
        Integer currentUserId = this.baseService.getCurrentUserId();
        OrderVO orderDto = new OrderVO(order);
        int applyUserId = orderDto.getUserId();
        orderDto.addPermission(PermissionEnum.AccessAble);
        Integer currentNode = order.getCurrentNode();
        if (this.permissionDao.existPermission(currentUserId, OwnerTypeEnum.USER, currentNode)) {
            orderDto.addPermission(PermissionEnum.ManageAble);
        }
        User user = this.userService.cacheQueryById(applyUserId);
        orderDto.setUser(user);
        Object relatedObject = this.queryRelatedElement(order);
        orderDto.setExtend(relatedObject);
        return orderDto;
    }

    private OrderVO translateApplyEntity(Order order) throws Exception {
        OrderVO orderDto = new OrderVO(order);
        int applyUserId = orderDto.getUserId();
        if (orderDto.getState() == OrderStateEnum.PROCESSING) {
            orderDto.addPermission(PermissionEnum.ManageAble);
        } else {
            orderDto.addPermission(PermissionEnum.AccessAble);
        }
        User user = this.userService.cacheQueryById(applyUserId);
        orderDto.setUser(user);
        Object relatedObject = this.queryRelatedElement(order);
        orderDto.setExtend(relatedObject);
        return orderDto;
    }

    public Object queryRelatedElement(Order order) throws Exception {
        Map configMap = order.getExtendConfig();
        if (order.getOrderType() == OrderTypeEnum.PROJECT_ACCESS) {
            Integer projectId = (Integer)configMap.get("projectId");
            return this.projectService.queryById(projectId);
        }
        if (order.getOrderType() == OrderTypeEnum.STAT_ACCESS) {
            Integer statId = (Integer)configMap.get("statId");
            return this.statService.queryById(statId);
        }
        if (order.getOrderType() == OrderTypeEnum.VIEW_ACCESS) {
            Integer viewId = (Integer)configMap.get("viewId");
            return this.viewService.queryById(viewId);
        }
        if (order.getOrderType() == OrderTypeEnum.LIMITING_SETTINGS) {
            Integer groupId = (Integer)configMap.get("groupId");
            return this.groupService.queryById(groupId);
        }
        if (order.getOrderType() == OrderTypeEnum.USER_PEND_APPROVE) {
            Integer userId = order.getUserId();
            return this.userService.cacheQueryById(userId.intValue());
        }
        if (order.getOrderType() == OrderTypeEnum.CALLER_PROJECT_ACCESS) {
            Integer projectId = (Integer)configMap.get("projectId");
            ProjectVO project = this.projectService.queryById(projectId);
            if (project == null) {
                return null;
            }
            Integer callerId = (Integer)configMap.get("callerId");
            CallerVO caller = this.callerService.queryById(callerId);
            if (caller == null) {
                return null;
            }
            Integer extension = (Integer)configMap.get("extension");
            if (extension == null) {
                return null;
            }
            HashMap<String, Object> extendMap = new HashMap<String, Object>();
            extendMap.put("project", project);
            extendMap.put("caller", caller);
            extendMap.put("extension", extension);
            return extendMap;
        }
        if (order.getOrderType() == OrderTypeEnum.CALLER_STAT_ACCESS) {
            Integer statId = (Integer)configMap.get("statId");
            StatVO stat = this.statService.queryById(statId);
            if (stat == null) {
                return null;
            }
            Integer callerId = (Integer)configMap.get("callerId");
            CallerVO caller = this.callerService.queryById(callerId);
            if (caller == null) {
                return null;
            }
            Integer extension = (Integer)configMap.get("extension");
            if (extension == null) {
                return null;
            }
            HashMap<String, Object> extendMap = new HashMap<String, Object>();
            extendMap.put("stat", stat);
            extendMap.put("caller", caller);
            extendMap.put("extension", extension);
            return extendMap;
        }
        if (order.getOrderType() == OrderTypeEnum.CALLER_VIEW_ACCESS) {
            Integer viewId = (Integer)configMap.get("viewId");
            ViewVO view = this.viewService.queryById(viewId);
            if (view == null) {
                return null;
            }
            Integer callerId = (Integer)configMap.get("callerId");
            CallerVO caller = this.callerService.queryById(callerId);
            if (caller == null) {
                return null;
            }
            Integer extension = (Integer)configMap.get("extension");
            if (extension == null) {
                return null;
            }
            HashMap<String, Object> extendMap = new HashMap<String, Object>();
            extendMap.put("view", view);
            extendMap.put("caller", caller);
            extendMap.put("extension", extension);
            return extendMap;
        }
        if (order.getOrderType() == OrderTypeEnum.CALLER_PROJECT_ACCESS_EXTENSION) {
            Integer projectId = (Integer)configMap.get("projectId");
            ProjectVO project = this.projectService.queryById(projectId);
            if (project == null) {
                return null;
            }
            Integer callerId = (Integer)configMap.get("callerId");
            CallerVO caller = this.callerService.queryById(callerId);
            if (caller == null) {
                return null;
            }
            Integer extension = (Integer)configMap.get("extension");
            if (extension == null) {
                return null;
            }
            HashMap<String, Object> extendMap = new HashMap<String, Object>();
            extendMap.put("project", project);
            extendMap.put("caller", caller);
            extendMap.put("extension", extension);
            return extendMap;
        }
        if (order.getOrderType() == OrderTypeEnum.CALLER_STAT_ACCESS_EXTENSION) {
            Integer statId = (Integer)configMap.get("statId");
            StatVO stat = this.statService.queryById(statId);
            if (stat == null) {
                return null;
            }
            Integer callerId = (Integer)configMap.get("callerId");
            CallerVO caller = this.callerService.queryById(callerId);
            if (caller == null) {
                return null;
            }
            Integer extension = (Integer)configMap.get("extension");
            if (extension == null) {
                return null;
            }
            HashMap<String, Object> extendMap = new HashMap<String, Object>();
            extendMap.put("stat", stat);
            extendMap.put("caller", caller);
            extendMap.put("extension", extension);
            return extendMap;
        }
        if (order.getOrderType() == OrderTypeEnum.CALLER_VIEW_ACCESS_EXTENSION) {
            Integer viewId = (Integer)configMap.get("viewId");
            ViewVO view = this.viewService.queryById(viewId);
            if (view == null) {
                return null;
            }
            Integer callerId = (Integer)configMap.get("callerId");
            CallerVO caller = this.callerService.queryById(callerId);
            if (caller == null) {
                return null;
            }
            Integer extension = (Integer)configMap.get("extension");
            if (extension == null) {
                return null;
            }
            HashMap<String, Object> extendMap = new HashMap<String, Object>();
            extendMap.put("view", view);
            extendMap.put("caller", caller);
            extendMap.put("extension", extension);
            return extendMap;
        }
        return null;
    }

    @Transactional
    public int process(OrderProcessParam processParam) throws Exception {
        int currentUserId = this.baseService.getCurrentUserId();
        int state = processParam.getState();
        Order order = this.orderDao.queryById(processParam.getId());
        Validate.notNull((Object)order);
        Validate.isTrue((order.getState() == OrderStateEnum.PROCESSING ? 1 : 0) != 0);
        int result = 0;
        if (state == 1) {
            int currentNode = order.getCurrentNode();
            Validate.isTrue((boolean)this.permissionService.checkUserPermission(Integer.valueOf(currentUserId), Integer.valueOf(currentNode)));
            result = this.agreeOrder(Integer.valueOf(currentUserId), processParam, order);
        } else if (state == 2) {
            int currentNode = order.getCurrentNode();
            Validate.isTrue((boolean)this.permissionService.checkUserPermission(Integer.valueOf(currentUserId), Integer.valueOf(currentNode)));
            result = this.rejectOrder(Integer.valueOf(currentUserId), processParam, order);
        } else if (state == 3) {
            Validate.isTrue((currentUserId == order.getUserId() ? 1 : 0) != 0);
            result = this.retractOrder(Integer.valueOf(currentUserId), processParam, order);
        }
        return result;
    }

    private int agreeOrder(Integer currentUserId, OrderProcessParam processParam, Order order) throws Exception {
        LocalDateTime localDateTime = LocalDateTime.now();
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setRoleId(order.getCurrentNode());
        orderDetail.setReply(processParam.getReply());
        orderDetail.setOrderId(processParam.getId());
        orderDetail.setUserId(currentUserId);
        orderDetail.setProcessTime(localDateTime);
        orderDetail.setState(ApproveStateEnum.APPROVED);
        List steps = order.getSteps();
        int stepIndex = steps.indexOf(order.getCurrentNode());
        this.orderDetailDao.updateDetail(orderDetail);
        if (stepIndex < steps.size() - 1) {
            order.setCurrentNode((Integer)steps.get(stepIndex + 1));
        } else {
            order.setCurrentNode(Integer.valueOf(0));
            order.setState(OrderStateEnum.APPROVED);
            this.orderAgreeCallback(order);
        }
        order.setUpdateTime(localDateTime);
        return this.orderDao.update(order);
    }

    private int retractOrder(Integer currentUserId, OrderProcessParam processParam, Order order) {
        int stepIndex;
        LocalDateTime localDateTime = LocalDateTime.now();
        ArrayList<OrderDetail> orderDetails = new ArrayList<OrderDetail>();
        List steps = order.getSteps();
        for (int i = stepIndex = steps.indexOf(order.getCurrentNode()); i < steps.size(); ++i) {
            int roleId = (Integer)steps.get(i);
            OrderDetail remainDetail = new OrderDetail();
            remainDetail.setProcessTime(localDateTime);
            remainDetail.setRoleId(Integer.valueOf(roleId));
            remainDetail.setOrderId(processParam.getId());
            remainDetail.setState(ApproveStateEnum.SUSPEND);
            orderDetails.add(remainDetail);
        }
        order.setUpdateTime(LocalDateTime.now());
        order.setState(OrderStateEnum.RETRACTED);
        order.setCurrentNode(Integer.valueOf(0));
        for (OrderDetail orderDetail : orderDetails) {
            this.orderDetailDao.updateDetail(orderDetail);
        }
        return this.orderDao.update(order);
    }

    private int rejectOrder(Integer currentUserId, OrderProcessParam processParam, Order order) {
        ArrayList<OrderDetail> orderDetails = new ArrayList<OrderDetail>();
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setRoleId(order.getCurrentNode());
        orderDetail.setReply(processParam.getReply());
        orderDetail.setOrderId(processParam.getId());
        LocalDateTime localDateTime = LocalDateTime.now();
        orderDetail.setProcessTime(localDateTime);
        orderDetail.setUserId(currentUserId);
        orderDetail.setState(ApproveStateEnum.REJECTED);
        orderDetails.add(orderDetail);
        List steps = order.getSteps();
        int stepIndex = steps.indexOf(order.getCurrentNode());
        if (stepIndex != steps.size() - 1) {
            for (int i = stepIndex + 1; i < steps.size(); ++i) {
                int roleId = (Integer)steps.get(i);
                OrderDetail remainDetail = new OrderDetail();
                remainDetail.setProcessTime(localDateTime);
                remainDetail.setRoleId(Integer.valueOf(roleId));
                remainDetail.setOrderId(processParam.getId());
                remainDetail.setState(ApproveStateEnum.SUSPEND);
                orderDetails.add(remainDetail);
            }
        }
        order.setUpdateTime(LocalDateTime.now());
        order.setState(OrderStateEnum.REJECTED);
        order.setCurrentNode(Integer.valueOf(0));
        for (OrderDetail detail : orderDetails) {
            this.orderDetailDao.updateDetail(detail);
        }
        int result = this.orderDao.update(order);
        this.orderRejectCallback(order);
        return result;
    }

    private void orderAgreeCallback(Order order) throws Exception {
        Integer userId = order.getUserId();
        if (order.getOrderType() == OrderTypeEnum.USER_PEND_APPROVE) {
            User userUpdateParam = new User();
            userUpdateParam.setId(userId);
            userUpdateParam.setState(UserStateEnum.USER_NORMAL);
            userUpdateParam.setUpdateTime(LocalDateTime.now());
            this.userService.update(userUpdateParam);
        } else if (order.getOrderType() == OrderTypeEnum.PROJECT_ACCESS) {
            Integer projectId = (Integer)order.getExtendConfig().get("projectId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, projectId);
            Validate.notNull((Object)role);
            this.permissionService.grantPermission(userId, OwnerTypeEnum.USER, role.getId());
        } else if (order.getOrderType() == OrderTypeEnum.STAT_ACCESS) {
            Integer statId = (Integer)order.getExtendConfig().get("statId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.STAT_ACCESS_PERMISSION, statId);
            Validate.notNull((Object)role);
            this.permissionService.grantPermission(userId, OwnerTypeEnum.USER, role.getId());
        } else if (order.getOrderType() == OrderTypeEnum.VIEW_ACCESS) {
            Integer viewId = (Integer)order.getExtendConfig().get("viewId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.VIEW_ACCESS_PERMISSION, viewId);
            Validate.notNull((Object)role);
            this.permissionService.grantPermission(userId, OwnerTypeEnum.USER, role.getId());
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_PROJECT_ACCESS) {
            Integer projectId = (Integer)order.getExtendConfig().get("projectId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, projectId);
            Validate.notNull((Object)role);
            Integer callerId = (Integer)order.getExtendConfig().get("callerId");
            Integer extension = (Integer)order.getExtendConfig().get("extension");
            this.permissionService.grantPermission(callerId, OwnerTypeEnum.CALLER, role.getId(), extension.intValue());
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_STAT_ACCESS) {
            Integer statId = (Integer)order.getExtendConfig().get("statId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.STAT_ACCESS_PERMISSION, statId);
            Validate.notNull((Object)role);
            Integer callerId = (Integer)order.getExtendConfig().get("callerId");
            Integer extension = (Integer)order.getExtendConfig().get("extension");
            this.permissionService.grantPermission(callerId, OwnerTypeEnum.CALLER, role.getId(), extension.intValue());
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_VIEW_ACCESS) {
            Integer viewId = (Integer)order.getExtendConfig().get("viewId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.VIEW_ACCESS_PERMISSION, viewId);
            Validate.notNull((Object)role);
            Integer callerId = (Integer)order.getExtendConfig().get("callerId");
            Integer extension = (Integer)order.getExtendConfig().get("extension");
            this.permissionService.grantPermission(callerId, OwnerTypeEnum.CALLER, role.getId(), extension.intValue());
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_PROJECT_ACCESS_EXTENSION) {
            Integer projectId = (Integer)order.getExtendConfig().get("projectId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, projectId);
            Validate.notNull((Object)role);
            Integer callerId = (Integer)order.getExtendConfig().get("callerId");
            Integer extension = (Integer)order.getExtendConfig().get("extension");
            Integer permissionId = (Integer)order.getExtendConfig().get("permissionId");
            Permission permission = this.permissionService.queryById(permissionId);
            Validate.notNull((Object)permission);
            Validate.isTrue((permission.getOwnerId().intValue() == callerId.intValue() ? 1 : 0) != 0);
            this.permissionService.extensionPermission(permissionId, extension.intValue());
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_STAT_ACCESS_EXTENSION) {
            Integer statId = (Integer)order.getExtendConfig().get("statId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.STAT_ACCESS_PERMISSION, statId);
            Validate.notNull((Object)role);
            Integer callerId = (Integer)order.getExtendConfig().get("callerId");
            Integer extension = (Integer)order.getExtendConfig().get("extension");
            Integer permissionId = (Integer)order.getExtendConfig().get("permissionId");
            Permission permission = this.permissionService.queryById(permissionId);
            Validate.notNull((Object)permission);
            Validate.isTrue((permission.getOwnerId().intValue() == callerId.intValue() ? 1 : 0) != 0);
            this.permissionService.extensionPermission(permissionId, extension.intValue());
        } else if (order.getOrderType() == OrderTypeEnum.CALLER_VIEW_ACCESS_EXTENSION) {
            Integer viewId = (Integer)order.getExtendConfig().get("viewId");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.VIEW_ACCESS_PERMISSION, viewId);
            Validate.notNull((Object)role);
            Integer callerId = (Integer)order.getExtendConfig().get("callerId");
            Integer extension = (Integer)order.getExtendConfig().get("extension");
            Integer permissionId = (Integer)order.getExtendConfig().get("permissionId");
            Permission permission = this.permissionService.queryById(permissionId);
            Validate.notNull((Object)permission);
            Validate.isTrue((permission.getOwnerId().intValue() == callerId.intValue() ? 1 : 0) != 0);
            this.permissionService.extensionPermission(permissionId, extension.intValue());
        } else if (order.getOrderType() == OrderTypeEnum.LIMITING_SETTINGS) {
            Integer groupId = (Integer)order.getExtendConfig().get("groupId");
            String strategy = (String)order.getExtendConfig().get("strategy");
            Integer updateValue = (Integer)order.getExtendConfig().get("updateValue");
            Validate.isTrue((updateValue > 0 ? 1 : 0) != 0);
            LimitingStrategyEnum limitingStrategyEnum = LimitingStrategyEnum.getEnum((String)strategy);
            GroupVO group = this.groupService.queryById(groupId);
            GroupExtendConfig groupExtendConfig = group.getExtendConfig();
            groupExtendConfig.getLimitingConfig().put(limitingStrategyEnum, updateValue);
            group.setRefreshTime(LocalDateTime.now());
            if (group.getState() == GroupStateEnum.LIMITING) {
                group.setState(GroupStateEnum.RUNNING);
            }
            this.groupService.update((Group)group);
        }
    }

    private void orderRejectCallback(Order order) {
        if (order.getOrderType() == OrderTypeEnum.USER_PEND_APPROVE) {
            User userUpdateParam = new User();
            userUpdateParam.setId(order.getUserId());
            userUpdateParam.setState(UserStateEnum.USER_REJECT);
            userUpdateParam.setUpdateTime(LocalDateTime.now());
            this.userService.update(userUpdateParam);
        }
    }

    @Cacheable(value={"ShortPeriod"}, key="#targetClass + '_' + 'pendCount' + '_' +  #userId", cacheManager="caffeineCacheManager", unless="#result == null")
    public int pendCount(int userId) {
        return this.orderDao.pendCount(userId);
    }
}

