/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.Owner;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.enums.UserStateEnum;
import com.dtstep.lighthouse.common.modal.AuthRecord;
import com.dtstep.lighthouse.common.modal.Department;
import com.dtstep.lighthouse.common.modal.Permission;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.insights.dao.PermissionDao;
import com.dtstep.lighthouse.insights.dto.PermissionQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.CallerService;
import com.dtstep.lighthouse.insights.service.DepartmentService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.service.ViewService;
import com.dtstep.lighthouse.insights.vo.CallerVO;
import com.dtstep.lighthouse.insights.vo.PermissionVO;
import com.dtstep.lighthouse.insights.vo.ProjectVO;
import com.dtstep.lighthouse.insights.vo.StatVO;
import com.dtstep.lighthouse.insights.vo.ViewVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionServiceImpl
implements PermissionService {
    private static final Logger logger = LoggerFactory.getLogger(PermissionServiceImpl.class);
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private UserService userService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CallerService callerService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private StatService statService;
    @Autowired
    private ViewService viewService;
    @Autowired
    private BaseService baseService;

    public int create(Permission permission) {
        LocalDateTime localDateTime = LocalDateTime.now();
        permission.setCreateTime(localDateTime);
        permission.setUpdateTime(localDateTime);
        this.permissionDao.insert(permission);
        return permission.getId();
    }

    @Transactional
    public int batchCreate(List<Permission> permissionList) {
        int result = 0;
        if (CollectionUtils.isEmpty(permissionList)) {
            return result;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        List permissions = permissionList.stream().filter(z -> !this.existPermission(z.getOwnerId(), z.getOwnerType(), z.getRoleId())).map(z -> {
            z.setCreateTime(localDateTime);
            z.setUpdateTime(localDateTime);
            return z;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(permissions)) {
            result = this.permissionDao.batchInsert(permissions);
        }
        return result;
    }

    @Cacheable(value={"MidPeriod"}, key="#targetClass + '_' + 'checkUserPermission' + '_' + #userId + '_' + #roleId", cacheManager="caffeineCacheManager", unless="#result == null")
    public boolean checkUserPermission(Integer userId, Integer roleId) {
        return this.permissionDao.checkUserPermission(userId, roleId);
    }

    @Cacheable(value={"MidPeriod"}, key="#targetClass + '_' + 'checkOwnerPermission' + '_' + #owner.ownerId + '_' + #owner.ownerType + '_' + #roleId", cacheManager="caffeineCacheManager", unless="#result == null")
    public boolean checkOwnerPermission(Owner owner, Integer roleId) {
        return this.permissionDao.checkOwnerPermission(owner.getOwnerId(), owner.getOwnerType(), roleId);
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryUserPermissionsByRoleId' + '_' + #roleId + '_' + #limit", cacheManager="caffeineCacheManager", unless="#result == null")
    public List<Integer> queryUserPermissionsByRoleId(Integer roleId, Integer limit) {
        return this.permissionDao.queryUserPermissionsByRoleId(roleId, limit);
    }

    public boolean existPermission(Integer ownerId, OwnerTypeEnum ownerType, Integer roleId) {
        return this.permissionDao.existPermission(ownerId, ownerType, roleId);
    }

    @Transactional
    public int grantPermission(Integer ownerId, OwnerTypeEnum ownerTypeEnum, Integer roleId) {
        Validate.notNull((Object)ownerId);
        Validate.notNull((Object)ownerTypeEnum);
        Validate.notNull((Object)roleId);
        if (this.existPermission(ownerId, ownerTypeEnum, roleId)) {
            return 0;
        }
        if (ownerTypeEnum == OwnerTypeEnum.USER) {
            User user = this.userService.queryById(ownerId.intValue());
            Validate.notNull((Object)user);
            Validate.isTrue((user.getState() == UserStateEnum.USER_NORMAL ? 1 : 0) != 0);
        } else if (ownerTypeEnum == OwnerTypeEnum.DEPARTMENT) {
            Department department = this.departmentService.queryById(ownerId);
            Validate.notNull((Object)department);
        }
        Permission permission = new Permission();
        permission.setOwnerId(ownerId);
        permission.setOwnerType(ownerTypeEnum);
        permission.setRoleId(roleId);
        LocalDateTime localDateTime = LocalDateTime.now();
        permission.setCreateTime(localDateTime);
        permission.setUpdateTime(localDateTime);
        return this.permissionDao.insert(permission);
    }

    @Transactional
    public int grantPermission(Integer ownerId, OwnerTypeEnum ownerTypeEnum, Integer roleId, int extension) throws Exception {
        Validate.notNull((Object)ownerId);
        Validate.notNull((Object)ownerTypeEnum);
        Validate.notNull((Object)roleId);
        PermissionQueryParam permissionQueryParam = new PermissionQueryParam();
        permissionQueryParam.setRoleId(roleId);
        permissionQueryParam.setOwnerId(ownerId);
        permissionQueryParam.setOwnerType(ownerTypeEnum);
        this.delete(permissionQueryParam);
        if (ownerTypeEnum == OwnerTypeEnum.USER) {
            User user = this.userService.queryById(ownerId.intValue());
            Validate.notNull((Object)user);
            Validate.isTrue((user.getState() == UserStateEnum.USER_NORMAL ? 1 : 0) != 0);
        } else if (ownerTypeEnum == OwnerTypeEnum.DEPARTMENT) {
            Department department = this.departmentService.queryById(ownerId);
            Validate.notNull((Object)department);
        } else if (ownerTypeEnum == OwnerTypeEnum.CALLER) {
            CallerVO caller = this.callerService.queryById(ownerId);
            Validate.notNull((Object)caller);
        }
        long current = System.currentTimeMillis();
        long extensionTime = current + TimeUnit.SECONDS.toMillis(extension);
        LocalDateTime localDateTime = DateUtil.timestampToLocalDateTime((long)current);
        LocalDateTime extensionDateTime = DateUtil.timestampToLocalDateTime((long)extensionTime);
        Permission permission = new Permission();
        permission.setOwnerId(ownerId);
        permission.setOwnerType(ownerTypeEnum);
        permission.setRoleId(roleId);
        permission.setExpireTime(extensionDateTime);
        permission.setCreateTime(localDateTime);
        permission.setUpdateTime(localDateTime);
        return this.permissionDao.insert(permission);
    }

    public int releasePermission(Integer ownerId, OwnerTypeEnum ownerTypeEnum, Integer roleId) {
        Validate.notNull((Object)ownerId);
        Validate.notNull((Object)ownerTypeEnum);
        Validate.notNull((Object)roleId);
        return this.permissionDao.delete(ownerId, ownerTypeEnum, roleId);
    }

    public int releasePermission(Integer id) {
        PermissionQueryParam queryParam = new PermissionQueryParam();
        queryParam.setId(id);
        return this.permissionDao.delete(queryParam);
    }

    public Permission queryById(Integer id) {
        return this.permissionDao.queryById(id);
    }

    public List<Permission> queryUserManagePermission(Integer userId, Integer limit) {
        return this.permissionDao.queryUserManagePermission(userId, limit);
    }

    public int delete(PermissionQueryParam queryParam) {
        return this.permissionDao.delete(queryParam);
    }

    private PermissionVO translate(Permission permission) throws Exception {
        PermissionVO permissionVO = new PermissionVO(permission);
        if (permissionVO.getOwnerType() == OwnerTypeEnum.USER) {
            User user = this.userService.cacheQueryById(permissionVO.getOwnerId().intValue());
            permissionVO.setExtend((Object)user);
        } else if (permissionVO.getOwnerType() == OwnerTypeEnum.DEPARTMENT) {
            Department department = this.departmentService.queryById(permissionVO.getOwnerId());
            permissionVO.setExtend((Object)department);
        } else if (permissionVO.getOwnerType() == OwnerTypeEnum.CALLER) {
            CallerVO caller = this.callerService.queryById(permissionVO.getOwnerId());
            permissionVO.setExtend((Object)caller);
        }
        int roleId = permission.getRoleId();
        Role role = this.roleService.cacheQueryById(Integer.valueOf(roleId));
        permissionVO.setRoleType(role.getRoleType());
        return permissionVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<PermissionVO> queryList(PermissionQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ArrayList<PermissionVO> dtoList = new ArrayList<PermissionVO>();
        try {
            List permissionList = this.permissionDao.queryList(queryParam);
            pageInfo = new PageInfo(permissionList);
        }
        finally {
            PageHelper.clearPage();
        }
        for (Permission permission : pageInfo.getList()) {
            try {
                PermissionVO dto = this.translate(permission);
                dtoList.add(dto);
            }
            catch (Exception ex) {
                logger.error("translate item info error,itemId:{}", (Object)permission.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(dtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<AuthRecord> queryOwnerAuthList(PermissionQueryParam queryParam, Integer pageNum, Integer pageSize) throws Exception {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            List permissionList = this.permissionDao.queryAuthList(queryParam);
            pageInfo = new PageInfo(permissionList);
        }
        finally {
            PageHelper.clearPage();
        }
        ArrayList<AuthRecord> voList = new ArrayList<AuthRecord>();
        ArrayList<Integer> statIdList = new ArrayList<Integer>();
        ArrayList<Integer> projectIdList = new ArrayList<Integer>();
        ArrayList<Integer> viewIdList = new ArrayList<Integer>();
        HashMap<Integer, Role> roleMap = new HashMap<Integer, Role>();
        for (Permission permission : pageInfo.getList()) {
            int roleId = permission.getRoleId();
            Role role = this.roleService.queryById(Integer.valueOf(roleId));
            if (role == null) continue;
            roleMap.put(roleId, role);
            RoleTypeEnum roleTypeEnum = role.getRoleType();
            if (roleTypeEnum == RoleTypeEnum.PROJECT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.PROJECT_ACCESS_PERMISSION) {
                int projectId = role.getResourceId();
                projectIdList.add(projectId);
                continue;
            }
            if (roleTypeEnum == RoleTypeEnum.STAT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.STAT_ACCESS_PERMISSION) {
                int statId = role.getResourceId();
                statIdList.add(statId);
                continue;
            }
            if (roleTypeEnum != RoleTypeEnum.VIEW_MANAGE_PERMISSION && roleTypeEnum != RoleTypeEnum.VIEW_ACCESS_PERMISSION) continue;
            int viewId = role.getResourceId();
            viewIdList.add(viewId);
        }
        List statList = this.statService.queryByIds(statIdList);
        List projectList = this.projectService.queryByIds(projectIdList);
        List viewList = this.viewService.queryByIds(viewIdList);
        for (Permission permission : pageInfo.getList()) {
            int roleId = permission.getRoleId();
            Role role = (Role)roleMap.get(roleId);
            if (role == null) continue;
            AuthRecord authRecord = new AuthRecord(permission);
            authRecord.setId(permission.getId());
            RoleTypeEnum roleTypeEnum = role.getRoleType();
            if (roleTypeEnum == RoleTypeEnum.PROJECT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.PROJECT_ACCESS_PERMISSION) {
                ProjectVO project = projectList.stream().filter(x -> x.getId().intValue() == role.getResourceId().intValue()).findFirst().orElse(null);
                authRecord.setExtend((Object)project);
                authRecord.setResourceId(role.getResourceId());
                authRecord.setResourceType(ResourceTypeEnum.Project);
            } else if (roleTypeEnum == RoleTypeEnum.STAT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.STAT_ACCESS_PERMISSION) {
                StatVO statVO = statList.stream().filter(x -> x.getId().intValue() == role.getResourceId().intValue()).findFirst().orElse(null);
                authRecord.setExtend((Object)statVO);
                authRecord.setResourceId(role.getResourceId());
                authRecord.setResourceType(ResourceTypeEnum.Stat);
            } else if (roleTypeEnum == RoleTypeEnum.VIEW_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.VIEW_ACCESS_PERMISSION) {
                ViewVO viewVO = viewList.stream().filter(x -> x.getId().intValue() == role.getResourceId().intValue()).findFirst().orElse(null);
                authRecord.setExtend((Object)viewVO);
                authRecord.setResourceId(role.getResourceId());
                authRecord.setResourceType(ResourceTypeEnum.View);
            }
            voList.add(authRecord);
        }
        return ListData.newInstance(voList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public int extensionPermission(Integer id, int expire) throws Exception {
        return this.permissionDao.extensionPermission(id, expire);
    }
}

