/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.RelationTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.modal.Relation;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.insights.dao.RelationDao;
import com.dtstep.lighthouse.insights.dto.RelationDeleteParam;
import com.dtstep.lighthouse.insights.dto.RelationQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.service.RelationService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.service.ViewService;
import com.dtstep.lighthouse.insights.vo.ProjectVO;
import com.dtstep.lighthouse.insights.vo.RelationVO;
import com.dtstep.lighthouse.insights.vo.StatVO;
import com.dtstep.lighthouse.insights.vo.ViewVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RelationServiceImpl
implements RelationService {
    private static final Logger logger = LoggerFactory.getLogger(RelationServiceImpl.class);
    @Autowired
    private RelationDao relationDao;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private StatService statService;
    @Autowired
    private BaseService baseService;
    @Autowired
    private ViewService viewService;

    public int batchCreate(List<Relation> relationList) {
        return this.relationDao.batchInsert(relationList);
    }

    public ResultCode create(Relation relation) {
        int result;
        String message = relation.getSubjectId() + "_" + relation.getRelationType().getRelationType() + "_" + relation.getResourceType().getResourceType() + "_" + relation.getResourceId();
        String hash = Md5Util.getMD5((String)message);
        relation.setHash(hash);
        LocalDateTime localDateTime = LocalDateTime.now();
        if (this.isExist(hash)) {
            relation.setUpdateTime(localDateTime);
            result = this.relationDao.update(relation);
        } else {
            relation.setHash(hash);
            relation.setCreateTime(localDateTime);
            relation.setUpdateTime(localDateTime);
            result = this.relationDao.insert(relation);
        }
        if (result > 0) {
            return ResultCode.success;
        }
        return ResultCode.systemError;
    }

    public int delete(RelationDeleteParam deleteParam) {
        return this.relationDao.delete(deleteParam);
    }

    public int deleteById(Integer id) {
        return this.relationDao.deleteById(id);
    }

    public boolean isExist(String hash) {
        return this.relationDao.isExist(hash);
    }

    private RelationVO translate(Relation relation) throws Exception {
        RelationVO relationVO = new RelationVO(relation);
        if (relation.getResourceType() == ResourceTypeEnum.Project) {
            ProjectVO projectVO = this.projectService.queryById(relation.getResourceId());
            relationVO.setExtend((Object)projectVO);
        } else if (relation.getResourceType() == ResourceTypeEnum.Stat) {
            StatVO statVO = this.statService.queryById(relation.getResourceId());
            relationVO.setExtend((Object)statVO);
        }
        return relationVO;
    }

    public List<RelationVO> queryList(Integer relationId, RelationTypeEnum relationTypeEnum) throws Exception {
        List relationList = this.relationDao.queryList(relationId, relationTypeEnum);
        ArrayList<Integer> statIdList = new ArrayList<Integer>();
        ArrayList<Integer> projectIdList = new ArrayList<Integer>();
        for (Relation relation : relationList) {
            if (relation.getResourceType() == ResourceTypeEnum.Project) {
                projectIdList.add(relation.getResourceId());
                continue;
            }
            if (relation.getResourceType() != ResourceTypeEnum.Stat) continue;
            statIdList.add(relation.getResourceId());
        }
        List statList = this.statService.queryByIds(statIdList);
        List projectList = this.projectService.queryByIds(projectIdList);
        ArrayList<RelationVO> voList = new ArrayList<RelationVO>();
        for (Relation relation : relationList) {
            RelationVO relationVO = new RelationVO(relation);
            if (relation.getResourceType() == ResourceTypeEnum.Project) {
                ProjectVO project = projectList.stream().filter(x -> x.getId().intValue() == relation.getResourceId().intValue()).findFirst().orElse(null);
                relationVO.setExtend((Object)project);
            } else if (relation.getResourceType() == ResourceTypeEnum.Stat) {
                StatVO statVO = statList.stream().filter(x -> x.getId().intValue() == relation.getResourceId().intValue()).findFirst().orElse(null);
                relationVO.setExtend((Object)statVO);
            }
            voList.add(relationVO);
        }
        return voList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<RelationVO> queryList(RelationQueryParam queryParam, Integer pageNum, Integer pageSize) throws Exception {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            List relationList = this.relationDao.queryListByPage(queryParam);
            pageInfo = new PageInfo(relationList);
        }
        finally {
            PageHelper.clearPage();
        }
        ArrayList<RelationVO> voList = new ArrayList<RelationVO>();
        ArrayList<Integer> statIdList = new ArrayList<Integer>();
        ArrayList<Integer> projectIdList = new ArrayList<Integer>();
        ArrayList<Integer> viewIdList = new ArrayList<Integer>();
        for (Relation relation : pageInfo.getList()) {
            if (relation.getResourceType() == ResourceTypeEnum.Project) {
                projectIdList.add(relation.getResourceId());
                continue;
            }
            if (relation.getResourceType() == ResourceTypeEnum.Stat) {
                statIdList.add(relation.getResourceId());
                continue;
            }
            if (relation.getResourceType() != ResourceTypeEnum.View) continue;
            viewIdList.add(relation.getResourceId());
        }
        List statList = this.statService.queryByIds(statIdList);
        List projectList = this.projectService.queryByIds(projectIdList);
        List viewList = this.viewService.queryByIds(viewIdList);
        for (Relation relation : pageInfo.getList()) {
            RelationVO relationVO = new RelationVO(relation);
            if (relation.getResourceType() == ResourceTypeEnum.Project) {
                ProjectVO project = projectList.stream().filter(x -> x.getId().intValue() == relation.getResourceId().intValue()).findFirst().orElse(null);
                relationVO.setExtend((Object)project);
            } else if (relation.getResourceType() == ResourceTypeEnum.Stat) {
                StatVO statVO = statList.stream().filter(x -> x.getId().intValue() == relation.getResourceId().intValue()).findFirst().orElse(null);
                relationVO.setExtend((Object)statVO);
            } else if (relation.getResourceType() == ResourceTypeEnum.View) {
                ViewVO viewVO = viewList.stream().filter(x -> x.getId().intValue() == relation.getResourceId().intValue()).findFirst().orElse(null);
                relationVO.setExtend((Object)viewVO);
            }
            voList.add(relationVO);
        }
        return ListData.newInstance(voList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public int count(RelationQueryParam queryParam) {
        return this.relationDao.count(queryParam);
    }

    public Relation queryRelationByHash(String hash) {
        return this.relationDao.queryRelationByHash(hash);
    }
}

