/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Caller;
import com.dtstep.lighthouse.common.modal.Department;
import com.dtstep.lighthouse.common.modal.Domain;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.MetricSet;
import com.dtstep.lighthouse.common.modal.Project;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.RolePair;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.modal.View;
import com.dtstep.lighthouse.insights.dao.CallerDao;
import com.dtstep.lighthouse.insights.dao.DepartmentDao;
import com.dtstep.lighthouse.insights.dao.GroupDao;
import com.dtstep.lighthouse.insights.dao.MetricSetDao;
import com.dtstep.lighthouse.insights.dao.ProjectDao;
import com.dtstep.lighthouse.insights.dao.StatDao;
import com.dtstep.lighthouse.insights.dao.ViewDao;
import com.dtstep.lighthouse.insights.dto.PermissionQueryParam;
import com.dtstep.lighthouse.insights.service.DomainService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.RoleService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceServiceImpl
implements ResourceService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private StatDao statDao;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private MetricSetDao metricSetDao;
    @Autowired
    private ViewDao viewDao;
    @Autowired
    private CallerDao callerDao;
    @Autowired
    private DomainService domainService;

    @Transactional
    public RolePair addResourceCallback(ResourceDto resource) {
        Role manageRole = null;
        Role accessRole = null;
        String name = null;
        if (resource.getResourceType() == ResourceTypeEnum.Domain) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.FULL_MANAGE_PERMISSION, Integer.valueOf(0));
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.FULL_ACCESS_PERMISSION, Integer.valueOf(0));
            Integer manageRolePid = parentManageRole.getId();
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.domainService.queryById(resource.getResourceId()).getName();
        } else if (resource.getResourceType() == ResourceTypeEnum.Department) {
            RoleTypeEnum parentManageRoleType = resource.getParentResourceType() == ResourceTypeEnum.Domain ? RoleTypeEnum.DOMAIN_MANAGE_PERMISSION : RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION;
            Role parentManageRole = this.roleService.cacheQueryRole(parentManageRoleType, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            RoleTypeEnum parentAccessRoleType = resource.getParentResourceType() == ResourceTypeEnum.Domain ? RoleTypeEnum.DOMAIN_ACCESS_PERMISSION : RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION;
            Role parentAccessRole = this.roleService.cacheQueryRole(parentAccessRoleType, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.departmentDao.queryById(resource.getResourceId()).getName();
        } else if (resource.getResourceType() == ResourceTypeEnum.Project) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.PROJECT_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.projectDao.queryById(resource.getResourceId()).getTitle();
        } else if (resource.getResourceType() == ResourceTypeEnum.Group) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.GROUP_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.GROUP_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.groupDao.queryById(resource.getResourceId()).getToken();
        } else if (resource.getResourceType() == ResourceTypeEnum.Stat) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.GROUP_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.GROUP_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.STAT_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.STAT_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.statDao.queryById(resource.getResourceId()).getTitle();
        } else if (resource.getResourceType() == ResourceTypeEnum.MetricSet) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.METRIC_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.METRIC_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.metricSetDao.queryById(resource.getResourceId()).getTitle();
        } else if (resource.getResourceType() == ResourceTypeEnum.View) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.VIEW_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.VIEW_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.viewDao.queryById(resource.getResourceId()).getTitle();
        } else if (resource.getResourceType() == ResourceTypeEnum.Caller) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.CALLER_MANAGER_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.CALLER_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.callerDao.queryById(resource.getResourceId()).getName();
        }
        Validate.notNull((Object)manageRole);
        Validate.notNull(accessRole);
        manageRole.setDesc(manageRole.getRoleType().name() + "(" + name + ")");
        accessRole.setDesc(accessRole.getRoleType().name() + "(" + name + ")");
        this.roleService.create(manageRole);
        this.roleService.create(accessRole);
        return new RolePair(manageRole.getId(), accessRole.getId());
    }

    @Transactional
    public void updateResourcePidCallback(ResourceDto resource) {
        Role manageRole = null;
        Role accessRole = null;
        String name = null;
        if (resource.getResourceType() == ResourceTypeEnum.Domain) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.FULL_MANAGE_PERMISSION, Integer.valueOf(0));
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.FULL_ACCESS_PERMISSION, Integer.valueOf(0));
            Integer manageRolePid = parentManageRole.getId();
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.domainService.queryById(resource.getResourceId()).getName();
        } else if (resource.getResourceType() == ResourceTypeEnum.Department) {
            RoleTypeEnum parentManageRoleType = resource.getParentResourceType() == ResourceTypeEnum.Domain ? RoleTypeEnum.DOMAIN_MANAGE_PERMISSION : RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION;
            Role parentManageRole = this.roleService.cacheQueryRole(parentManageRoleType, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            RoleTypeEnum parentAccessRoleType = resource.getParentResourceType() == ResourceTypeEnum.Domain ? RoleTypeEnum.DOMAIN_ACCESS_PERMISSION : RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION;
            Role parentAccessRole = this.roleService.cacheQueryRole(parentAccessRoleType, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.departmentDao.queryById(resource.getResourceId()).getName();
        } else if (resource.getResourceType() == ResourceTypeEnum.Project) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.PROJECT_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.projectDao.queryById(resource.getResourceId()).getTitle();
        } else if (resource.getResourceType() == ResourceTypeEnum.Group) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.GROUP_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.GROUP_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.groupDao.queryById(resource.getResourceId()).getToken();
        } else if (resource.getResourceType() == ResourceTypeEnum.Stat) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.GROUP_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.GROUP_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.STAT_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.STAT_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.statDao.queryById(resource.getResourceId()).getTitle();
        } else if (resource.getResourceType() == ResourceTypeEnum.MetricSet) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.METRIC_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.METRIC_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.metricSetDao.queryById(resource.getResourceId()).getTitle();
        } else if (resource.getResourceType() == ResourceTypeEnum.View) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.VIEW_MANAGE_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.VIEW_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.viewDao.queryById(resource.getResourceId()).getTitle();
        } else if (resource.getResourceType() == ResourceTypeEnum.Caller) {
            Role parentManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourcePid());
            Integer manageRolePid = parentManageRole.getId();
            Role parentAccessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourcePid());
            Integer accessRolePid = parentAccessRole.getId();
            manageRole = new Role(RoleTypeEnum.CALLER_MANAGER_PERMISSION, resource.getResourceId(), manageRolePid);
            accessRole = new Role(RoleTypeEnum.CALLER_ACCESS_PERMISSION, resource.getResourceId(), accessRolePid);
            name = this.callerDao.queryById(resource.getResourceId()).getName();
        }
        Validate.notNull((Object)manageRole);
        Validate.notNull(accessRole);
        manageRole.setDesc(manageRole.getRoleType().name() + "(" + name + ")");
        accessRole.setDesc(accessRole.getRoleType().name() + "(" + name + ")");
        this.roleService.update(manageRole);
        this.roleService.update(accessRole);
    }

    @Transactional
    public ResultCode deleteResourceCallback(ResourceDto resource) {
        Role manageRole = null;
        Role accessRole = null;
        if (resource.getResourceType() == ResourceTypeEnum.Domain) {
            manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_MANAGE_PERMISSION, resource.getResourceId());
            accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DOMAIN_ACCESS_PERMISSION, resource.getResourceId());
        } else if (resource.getResourceType() == ResourceTypeEnum.Department) {
            manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION, resource.getResourceId());
            accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION, resource.getResourceId());
        } else if (resource.getResourceType() == ResourceTypeEnum.Project) {
            manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_MANAGE_PERMISSION, resource.getResourceId());
            accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, resource.getResourceId());
        } else if (resource.getResourceType() == ResourceTypeEnum.Group) {
            manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.GROUP_MANAGE_PERMISSION, resource.getResourceId());
            accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.GROUP_ACCESS_PERMISSION, resource.getResourceId());
        } else if (resource.getResourceType() == ResourceTypeEnum.Stat) {
            manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.STAT_MANAGE_PERMISSION, resource.getResourceId());
            accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.STAT_ACCESS_PERMISSION, resource.getResourceId());
        } else if (resource.getResourceType() == ResourceTypeEnum.MetricSet) {
            manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.METRIC_MANAGE_PERMISSION, resource.getResourceId());
            accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.METRIC_ACCESS_PERMISSION, resource.getResourceId());
        } else if (resource.getResourceType() == ResourceTypeEnum.View) {
            manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.VIEW_MANAGE_PERMISSION, resource.getResourceId());
            accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.VIEW_ACCESS_PERMISSION, resource.getResourceId());
        } else if (resource.getResourceType() == ResourceTypeEnum.Caller) {
            manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.CALLER_MANAGER_PERMISSION, resource.getResourceId());
            accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.CALLER_ACCESS_PERMISSION, resource.getResourceId());
        }
        Validate.notNull((Object)manageRole);
        Validate.notNull((Object)accessRole);
        PermissionQueryParam manageQueryParam = new PermissionQueryParam();
        manageQueryParam.setRoleId(manageRole.getId());
        this.permissionService.delete(manageQueryParam);
        PermissionQueryParam accessQueryParam = new PermissionQueryParam();
        accessQueryParam.setRoleId(accessRole.getId());
        this.permissionService.delete(accessQueryParam);
        this.roleService.deleteById(manageRole.getId());
        this.roleService.deleteById(accessRole.getId());
        return ResultCode.success;
    }

    public int grantPermission(Integer ownerId, OwnerTypeEnum ownerTypeEnum, Integer resourceId, RoleTypeEnum roleTypeEnum) {
        Role role = this.roleService.cacheQueryRole(roleTypeEnum, resourceId);
        Validate.notNull((Object)role);
        return this.permissionService.grantPermission(ownerId, ownerTypeEnum, role.getId());
    }

    public int releasePermission(Integer ownerId, OwnerTypeEnum ownerTypeEnum, Integer resourceId, RoleTypeEnum roleTypeEnum) {
        Role role = this.roleService.cacheQueryRole(roleTypeEnum, resourceId);
        return this.permissionService.releasePermission(ownerId, ownerTypeEnum, role.getId());
    }

    public ResourceDto queryByRoleId(Integer roleId) {
        Role role = this.roleService.queryById(roleId);
        if (role == null) {
            return null;
        }
        ResourceDto resource = null;
        RoleTypeEnum roleTypeEnum = role.getRoleType();
        Integer resourceId = role.getResourceId();
        if (roleTypeEnum == RoleTypeEnum.DOMAIN_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.DOMAIN_ACCESS_PERMISSION) {
            Domain domain = this.domainService.queryById(resourceId);
            resource = new ResourceDto(ResourceTypeEnum.Domain, resourceId, (Object)domain);
        } else if (roleTypeEnum == RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION) {
            Department department = this.departmentDao.queryById(resourceId);
            resource = new ResourceDto(ResourceTypeEnum.Department, resourceId, (Object)department);
        } else if (roleTypeEnum == RoleTypeEnum.PROJECT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.PROJECT_ACCESS_PERMISSION) {
            Project project = this.projectDao.queryById(resourceId);
            resource = new ResourceDto(ResourceTypeEnum.Project, resourceId, (Object)project);
        } else if (roleTypeEnum == RoleTypeEnum.GROUP_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.GROUP_ACCESS_PERMISSION) {
            Group group = this.groupDao.queryById(resourceId);
            resource = new ResourceDto(ResourceTypeEnum.Group, resourceId, (Object)group);
        } else if (roleTypeEnum == RoleTypeEnum.STAT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.STAT_ACCESS_PERMISSION) {
            Stat stat = this.statDao.queryById(resourceId);
            resource = new ResourceDto(ResourceTypeEnum.Stat, resourceId, (Object)stat);
        } else if (roleTypeEnum == RoleTypeEnum.METRIC_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.METRIC_ACCESS_PERMISSION) {
            MetricSet metricSet = this.metricSetDao.queryById(resourceId);
            resource = new ResourceDto(ResourceTypeEnum.MetricSet, resourceId, (Object)metricSet);
        } else if (roleTypeEnum == RoleTypeEnum.VIEW_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.VIEW_ACCESS_PERMISSION) {
            View view = this.viewDao.queryById(resourceId);
            resource = new ResourceDto(ResourceTypeEnum.View, resourceId, (Object)view);
        } else if (roleTypeEnum == RoleTypeEnum.CALLER_MANAGER_PERMISSION || roleTypeEnum == RoleTypeEnum.CALLER_ACCESS_PERMISSION) {
            Caller caller = this.callerDao.queryById(resourceId);
            resource = new ResourceDto(ResourceTypeEnum.Caller, resourceId, (Object)caller);
        } else if (roleTypeEnum == RoleTypeEnum.FULL_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.FULL_ACCESS_PERMISSION) {
            resource = new ResourceDto(ResourceTypeEnum.System, Integer.valueOf(0));
        }
        return resource;
    }
}

