/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.insights.dao.RoleDao;
import com.dtstep.lighthouse.insights.service.RoleService;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleDao roleDao;

    public Role queryById(Integer id) {
        return this.roleDao.queryById(id);
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryById' + '_' + #id", cacheManager="caffeineCacheManager", unless="#result == null")
    public Role cacheQueryById(Integer id) {
        return this.roleDao.queryById(id);
    }

    public boolean isRoleExist(RoleTypeEnum roleTypeEnum, Integer resourceId) {
        return this.roleDao.isRoleExist(roleTypeEnum, resourceId);
    }

    public int create(Role role) {
        LocalDateTime localDateTime = LocalDateTime.now();
        role.setCreateTime(localDateTime);
        role.setUpdateTime(localDateTime);
        return this.roleDao.insert(role);
    }

    public void batchCreate(List<Role> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        list.forEach(z -> {
            z.setCreateTime(localDateTime);
            z.setUpdateTime(localDateTime);
        });
        this.roleDao.batchInsert(list);
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryRole' + '_' + #roleTypeEnum.roleType + '_' + #resourceId", cacheManager="caffeineCacheManager", unless="#result == null")
    public Role cacheQueryRole(RoleTypeEnum roleTypeEnum, Integer resourceId) {
        return this.roleDao.queryRole(roleTypeEnum, resourceId);
    }

    public int update(Role role) {
        role.setUpdateTime(LocalDateTime.now());
        return this.roleDao.update(role);
    }

    public boolean isChildRoleExist(Integer pid) {
        return this.roleDao.isChildRoleExist(pid);
    }

    public int deleteById(Integer id) {
        return this.roleDao.deleteById(id);
    }

    public List<Role> queryListByPid(Integer pid, Integer pageNum, Integer pageSize) {
        return this.roleDao.queryListByPid(pid, pageNum, pageSize);
    }

    public Role queryRole(RoleTypeEnum roleTypeEnum, Integer resourceId) {
        return this.roleDao.queryRole(roleTypeEnum, resourceId);
    }
}

