/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.enums.RollbackStateEnum;
import com.dtstep.lighthouse.common.enums.RollbackTypeEnum;
import com.dtstep.lighthouse.common.modal.RollbackModal;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.wrapper.UserDBWrapper;
import com.dtstep.lighthouse.insights.dao.RollbackDao;
import com.dtstep.lighthouse.insights.dto.RollbackQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.RollbackService;
import com.dtstep.lighthouse.insights.vo.RollbackVO;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RollbackServiceImpl
implements RollbackService {
    private static final Logger logger = LoggerFactory.getLogger(RollbackServiceImpl.class);
    @Autowired
    private RollbackDao rollbackDao;
    @Autowired
    private BaseService baseService;

    @Transactional
    public ObjectNode put(RollbackModal rollbackModal) throws Exception {
        int version;
        Integer resourceId = rollbackModal.getResourceId();
        RollbackTypeEnum rollbackTypeEnum = rollbackModal.getDataType();
        if (rollbackModal.getVersion() == null) {
            Integer dbVersion = this.rollbackDao.getLatestVersion(resourceId, rollbackTypeEnum);
            version = 1;
            if (dbVersion != null) {
                version = dbVersion + 1;
            }
            rollbackModal.setVersion(Integer.valueOf(version));
        } else {
            version = rollbackModal.getVersion();
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        int userId = this.baseService.getCurrentUserId();
        rollbackModal.setCreateTime(localDateTime);
        rollbackModal.setState(RollbackStateEnum.UNPUBLISHED);
        rollbackModal.setUserId(Integer.valueOf(userId));
        this.rollbackDao.insert(rollbackModal);
        ObjectNode objectNode = JsonUtil.createObjectNode();
        objectNode.put("version", version);
        objectNode.put("state", RollbackStateEnum.UNPUBLISHED.getState());
        objectNode.put("dataType", rollbackTypeEnum.getType());
        objectNode.put("createTime", DateUtil.translateToTimeStamp((LocalDateTime)localDateTime));
        return objectNode;
    }

    public RollbackModal queryByVersion(RollbackQueryParam queryParam) throws Exception {
        return this.rollbackDao.queryByVersion(queryParam);
    }

    private RollbackVO translate(RollbackModal rollbackModal) {
        RollbackVO rollbackVO = new RollbackVO(rollbackModal);
        if (rollbackModal.getUserId() != null) {
            User user = UserDBWrapper.queryById((Integer)rollbackModal.getUserId());
            rollbackVO.setCreateUser(user);
        }
        return rollbackVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<RollbackVO> queryList(RollbackQueryParam queryParam, Integer pageNum, Integer pageSize) throws Exception {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            List rollbackList = this.rollbackDao.queryList(queryParam);
            pageInfo = new PageInfo(rollbackList);
        }
        finally {
            PageHelper.clearPage();
        }
        ArrayList<RollbackVO> dtoList = new ArrayList<RollbackVO>();
        for (RollbackModal rollbackModal : pageInfo.getList()) {
            try {
                RollbackVO rollbackVO = this.translate(rollbackModal);
                dtoList.add(rollbackVO);
            }
            catch (Exception ex) {
                logger.error("translate item info error,itemId:{}!", (Object)rollbackModal.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(dtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public void deleteByQueryParam(RollbackQueryParam queryParam) throws Exception {
        this.rollbackDao.deleteByQueryParam(queryParam);
    }
}

