/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.Owner;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.enums.ComponentTypeEnum;
import com.dtstep.lighthouse.common.enums.PrivateTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.enums.StatStateEnum;
import com.dtstep.lighthouse.common.modal.Component;
import com.dtstep.lighthouse.common.modal.DBStatistics;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.PermissionEnum;
import com.dtstep.lighthouse.common.modal.RenderChartConfig;
import com.dtstep.lighthouse.common.modal.RenderConfig;
import com.dtstep.lighthouse.common.modal.RenderFilterConfig;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.core.formula.TemplateUtil;
import com.dtstep.lighthouse.core.storage.dimens.DimensStorageSelector;
import com.dtstep.lighthouse.core.template.TemplateContext;
import com.dtstep.lighthouse.core.template.TemplateParser;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.dtstep.lighthouse.insights.config.SoftEdition;
import com.dtstep.lighthouse.insights.dao.StatDao;
import com.dtstep.lighthouse.insights.dto.StatQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.ComponentService;
import com.dtstep.lighthouse.insights.service.GroupService;
import com.dtstep.lighthouse.insights.service.MetaTableService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.util.TreeUtil;
import com.dtstep.lighthouse.insights.vo.GroupVO;
import com.dtstep.lighthouse.insights.vo.StatVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StatServiceImpl
implements StatService {
    private static final Logger logger = LoggerFactory.getLogger(StatServiceImpl.class);
    @Autowired
    private StatDao statDao;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private BaseService baseService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ComponentService componentService;
    @Autowired
    private UserService userService;
    @Autowired
    private MetaTableService metaTableService;
    @Autowired
    private SoftEdition softEdition;

    @Transactional
    public ResultCode create(Stat stat) throws Exception {
        String timeParam;
        int groupId = stat.getGroupId();
        GroupVO group = this.groupService.queryById(Integer.valueOf(groupId));
        String template = stat.getTemplate();
        ServiceResult serviceResult = TemplateParser.parseConfig((TemplateContext)new TemplateContext(template, timeParam = stat.getTimeparam(), group.getColumns()));
        ResultCode resultCode = serviceResult.getResultCode();
        if (resultCode != ResultCode.success) {
            return resultCode;
        }
        TemplateEntity templateEntity = (TemplateEntity)serviceResult.getData();
        stat.setTitle(templateEntity.getTitle());
        LocalDateTime localDateTime = LocalDateTime.now();
        stat.setUpdateTime(localDateTime);
        stat.setCreateTime(localDateTime);
        stat.setRefreshTime(localDateTime);
        stat.setState(StatStateEnum.RUNNING);
        stat.setRandomId(RandomID.id((int)32));
        int metaId = this.metaTableService.getCurrentStatResultTable();
        stat.setMetaId(Integer.valueOf(metaId));
        this.statDao.insert(stat);
        int id = stat.getId();
        this.resourceService.addResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Stat, (Integer)id, (ResourceTypeEnum)ResourceTypeEnum.Group, (Integer)stat.getGroupId()));
        return ResultCode.success;
    }

    @Transactional
    public ResultCode update(Stat stat) {
        String template = stat.getTemplate();
        Document document = Jsoup.parse((String)template, (String)"", (Parser)Parser.xmlParser());
        Element node = document.select("stat-item").first();
        node.attr("title", stat.getTitle());
        String newTemplate = document.toString();
        stat.setTemplate(newTemplate);
        LocalDateTime localDateTime = LocalDateTime.now();
        stat.setUpdateTime(localDateTime);
        this.statDao.update(stat);
        this.resourceService.updateResourcePidCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Stat, (Integer)stat.getId(), (ResourceTypeEnum)ResourceTypeEnum.Group, (Integer)stat.getGroupId()));
        return ResultCode.success;
    }

    public void changeState(Stat stat, StatStateEnum statStateEnum) throws Exception {
        LocalDateTime localDateTime = LocalDateTime.now();
        StatDBWrapper.changeState((int)stat.getId(), (StatStateEnum)statStateEnum, (LocalDateTime)localDateTime);
    }

    @Transactional
    public int delete(Stat stat) {
        Integer id = stat.getId();
        this.resourceService.deleteResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Stat, (Integer)id, (ResourceTypeEnum)ResourceTypeEnum.Group, (Integer)stat.getGroupId()));
        return this.statDao.deleteById(id);
    }

    private StatVO translate(StatExtEntity stat) throws Exception {
        if (stat == null) {
            return null;
        }
        Owner owner = this.baseService.getCurrentOwner();
        StatVO statVO = new StatVO(stat);
        if (stat.isBuiltIn()) {
            statVO.addPermission(PermissionEnum.AccessAble);
        } else {
            Role manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.STAT_MANAGE_PERMISSION, stat.getId());
            Role accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.STAT_ACCESS_PERMISSION, stat.getId());
            if (this.permissionService.checkOwnerPermission(owner, manageRole.getId())) {
                statVO.addPermission(PermissionEnum.ManageAble);
                statVO.addPermission(PermissionEnum.AccessAble);
            } else if (this.softEdition.isOpenSource() || statVO.getPrivateType() == PrivateTypeEnum.Public || this.permissionService.checkOwnerPermission(owner, accessRole.getId())) {
                statVO.addPermission(PermissionEnum.AccessAble);
            }
            Role projectManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_MANAGE_PERMISSION, statVO.getProjectId());
            Validate.notNull((Object)manageRole);
            List adminIds = this.permissionService.queryUserPermissionsByRoleId(projectManageRole.getId(), Integer.valueOf(3));
            if (CollectionUtils.isNotEmpty((Collection)adminIds)) {
                List admins = adminIds.stream().map(z -> this.userService.cacheQueryById(z.intValue())).collect(Collectors.toList());
                statVO.setAdmins(admins);
            }
        }
        String template = stat.getTemplate();
        String timeParam = stat.getTimeparam();
        GroupVO group = this.groupService.queryById(stat.getGroupId());
        ServiceResult serviceResult = TemplateParser.parseConfig((TemplateContext)new TemplateContext(template, timeParam, group.getColumns()));
        if (!serviceResult.isSuccess()) {
            return null;
        }
        TemplateEntity templateEntity = (TemplateEntity)serviceResult.getData();
        statVO.setTemplateEntity(templateEntity);
        statVO.setTitle(templateEntity.getTitle());
        return statVO;
    }

    public List<StatVO> queryByIds(List<Integer> ids) throws Exception {
        ArrayList<StatVO> voList = new ArrayList<StatVO>();
        List builtInIds = ids.stream().filter(BuiltinLoader::isBuiltinStat).collect(Collectors.toList());
        List nonBuiltInIds = ids.stream().filter(x -> !builtInIds.contains(x)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(builtInIds)) {
            for (Integer id : builtInIds) {
                StatExtEntity statExtEntity = BuiltinLoader.getBuiltinStat((int)id);
                StatVO statVO = this.translate(statExtEntity);
                if (statVO == null) continue;
                voList.add(statVO);
            }
        }
        if (CollectionUtils.isNotEmpty(nonBuiltInIds)) {
            StatQueryParam queryParam = new StatQueryParam();
            queryParam.setIds(nonBuiltInIds);
            List statList = this.statDao.queryList(queryParam);
            for (Stat stat : statList) {
                StatExtEntity statExtEntity = StatDBWrapper.combineExtInfo((Stat)stat, (boolean)false);
                StatVO statVO = this.translate(statExtEntity);
                if (statVO == null) continue;
                voList.add(statVO);
            }
        }
        return voList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<StatVO> queryList(StatQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ArrayList<StatVO> dtoList = new ArrayList<StatVO>();
        try {
            List list = this.statDao.queryList(queryParam);
            pageInfo = new PageInfo(list);
        }
        finally {
            PageHelper.clearPage();
        }
        for (Stat stat : pageInfo.getList()) {
            try {
                StatExtEntity statExtEntity = StatDBWrapper.combineExtInfo((Stat)stat, (boolean)false);
                StatVO statVo = this.translate(statExtEntity);
                if (statVo == null) continue;
                dtoList.add(statVo);
            }
            catch (Exception ex) {
                logger.error("translate item info error,itemId:{}!", (Object)stat.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(dtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public StatVO queryById(Integer id) throws Exception {
        StatExtEntity statExtEntity;
        if (BuiltinLoader.isBuiltinStat((int)id)) {
            statExtEntity = BuiltinLoader.getBuiltinStat((int)id);
        } else {
            Stat stat = this.statDao.queryById(id);
            if (stat == null) {
                return null;
            }
            statExtEntity = StatDBWrapper.combineExtInfo((Stat)stat, (boolean)false);
        }
        return this.translate(statExtEntity);
    }

    public List<Stat> queryByProjectId(Integer projectId) {
        return this.statDao.queryByProjectId(projectId);
    }

    public RenderConfig getStatRenderConfig(StatVO stat) throws Exception {
        List treeNodes;
        List dimensValueList;
        RenderConfig renderConfig = stat.getRenderConfig();
        GroupVO group = this.groupService.queryById(stat.getGroupId());
        HashMap<String, RenderFilterConfig> filtersConfigMap = new HashMap<String, RenderFilterConfig>();
        if (CollectionUtils.isEmpty((Collection)renderConfig.getFilters())) {
            String[] dimensArray;
            TemplateEntity templateEntity = stat.getTemplateEntity();
            for (String dimens : dimensArray = templateEntity.getDimensArray()) {
                dimensValueList = DimensStorageSelector.query((Group)group, (String)dimens, null, (int)1000);
                treeNodes = dimensValueList.stream().map(z -> new TreeNode(z, z)).collect(Collectors.toList());
                RenderFilterConfig renderFilterConfig = new RenderFilterConfig();
                renderFilterConfig.setComponentType(ComponentTypeEnum.FILTER_SELECT);
                renderFilterConfig.setComponentId(Integer.valueOf(0));
                renderFilterConfig.setLabel(dimens);
                renderFilterConfig.setDimens(dimens);
                renderFilterConfig.setConfigData(treeNodes);
                filtersConfigMap.put(dimens, renderFilterConfig);
            }
        } else {
            List filterConfigs = renderConfig.getFilters();
            for (RenderFilterConfig filterConfig : filterConfigs) {
                Integer componentId = filterConfig.getComponentId();
                ComponentTypeEnum componentTypeEnum = filterConfig.getComponentType();
                filterConfig.setComponentId(componentId);
                filterConfig.setComponentType(componentTypeEnum);
                filterConfig.setDimens(filterConfig.getDimens());
                filterConfig.setLabel(filterConfig.getLabel());
                Component component = this.componentService.queryById(componentId);
                if (component != null) {
                    filterConfig.setTitle(component.getTitle());
                    filterConfig.setConfigData(component.getConfiguration());
                    filtersConfigMap.put(filterConfig.getDimens(), filterConfig);
                    continue;
                }
                dimensValueList = DimensStorageSelector.query((Group)group, (String)filterConfig.getDimens(), null, (int)1000);
                treeNodes = dimensValueList.stream().map(z -> new TreeNode(z, z)).collect(Collectors.toList());
                filterConfig.setConfigData(treeNodes);
                filtersConfigMap.put(filterConfig.getDimens(), filterConfig);
            }
        }
        ArrayList<RenderFilterConfig> configList = new ArrayList<RenderFilterConfig>();
        for (String key : filtersConfigMap.keySet()) {
            configList.add((RenderFilterConfig)filtersConfigMap.get(key));
        }
        renderConfig.setFilters(configList);
        return renderConfig;
    }

    public RenderConfig getTestStatRenderConfig(StatVO stat) throws Exception {
        List treeNodes;
        List<String> dimensValueList;
        RenderConfig renderConfig = stat.getRenderConfig();
        GroupVO group = this.groupService.queryById(stat.getGroupId());
        HashMap<String, RenderFilterConfig> filtersConfigMap = new HashMap<String, RenderFilterConfig>();
        if (CollectionUtils.isEmpty((Collection)renderConfig.getFilters())) {
            String[] dimensArray;
            TemplateEntity templateEntity = stat.getTemplateEntity();
            for (String dimens : dimensArray = templateEntity.getDimensArray()) {
                dimensValueList = List.of("test_1", "test_2", "test_3", "test_4", "test_5");
                treeNodes = dimensValueList.stream().map(z -> new TreeNode(z, z)).collect(Collectors.toList());
                RenderFilterConfig renderFilterConfig = new RenderFilterConfig();
                renderFilterConfig.setComponentType(ComponentTypeEnum.FILTER_SELECT);
                renderFilterConfig.setComponentId(Integer.valueOf(0));
                renderFilterConfig.setLabel(dimens);
                renderFilterConfig.setDimens(dimens);
                renderFilterConfig.setConfigData(treeNodes);
                filtersConfigMap.put(dimens, renderFilterConfig);
            }
        } else {
            List filterConfigs = renderConfig.getFilters();
            for (RenderFilterConfig filterConfig : filterConfigs) {
                Integer componentId = filterConfig.getComponentId();
                ComponentTypeEnum componentTypeEnum = filterConfig.getComponentType();
                filterConfig.setComponentId(componentId);
                filterConfig.setComponentType(componentTypeEnum);
                filterConfig.setDimens(filterConfig.getDimens());
                filterConfig.setLabel(filterConfig.getLabel());
                Component component = this.componentService.queryById(componentId);
                if (component != null) {
                    filterConfig.setTitle(component.getTitle());
                    filterConfig.setConfigData(component.getConfiguration());
                    filtersConfigMap.put(filterConfig.getDimens(), filterConfig);
                    continue;
                }
                dimensValueList = List.of("test_1", "test_2", "test_3", "test_4", "test_5");
                treeNodes = dimensValueList.stream().map(z -> new TreeNode(z, z)).collect(Collectors.toList());
                filterConfig.setConfigData(treeNodes);
                filtersConfigMap.put(filterConfig.getDimens(), filterConfig);
            }
        }
        ArrayList<RenderFilterConfig> configList = new ArrayList<RenderFilterConfig>();
        for (String key : filtersConfigMap.keySet()) {
            configList.add((RenderFilterConfig)filtersConfigMap.get(key));
        }
        renderConfig.setFilters(configList);
        return renderConfig;
    }

    public ResultCode filterConfig(StatVO stat, List<RenderFilterConfig> filterConfigs) {
        String[] dimensArray = stat.getTemplateEntity().getDimensArray();
        Validate.notNull((Object)dimensArray);
        if (CollectionUtils.isEmpty(filterConfigs)) {
            return ResultCode.filterConfigConfigCannotBeEmpty;
        }
        List<String> list = Arrays.asList(dimensArray);
        ArrayList<String> configList = new ArrayList<String>();
        for (RenderFilterConfig filterConfig : filterConfigs) {
            String[] dimensArrayUnit;
            String dimens = filterConfig.getDimens();
            String label = filterConfig.getLabel();
            if (StringUtil.isEmpty((String)dimens)) {
                return ResultCode.getExtendResultCode((ResultCode)ResultCode.filterConfigDimensCannotBeEmpty, (String[])new String[]{"dimens"});
            }
            if (StringUtil.isEmpty((String)label)) {
                return ResultCode.getExtendResultCode((ResultCode)ResultCode.filterConfigLabelCannotBeEmpty, (String[])new String[]{"label"});
            }
            for (String temp : dimensArrayUnit = TemplateUtil.split((String)dimens)) {
                if (!list.contains(temp)) {
                    return ResultCode.getExtendResultCode((ResultCode)ResultCode.filterConfigDimensNotExist, (String[])new String[]{temp});
                }
                if (configList.contains(temp)) {
                    return ResultCode.getExtendResultCode((ResultCode)ResultCode.filterConfigDimensDuplicate, (String[])new String[]{temp});
                }
                configList.add(temp);
            }
            int componentId = filterConfig.getComponentId();
            if (componentId != 0 && filterConfig.getComponentType() == ComponentTypeEnum.FILTER_SELECT) {
                Component component = this.componentService.queryById(Integer.valueOf(componentId));
                if (component == null) {
                    return ResultCode.getExtendResultCode((ResultCode)ResultCode.filterConfigComponentInvalid, (String[])new String[]{String.valueOf(componentId)});
                }
                int level = TreeUtil.getMaxLevel((List)component.getConfiguration());
                if (dimensArrayUnit.length == level) continue;
                return ResultCode.getExtendResultCode((ResultCode)ResultCode.filterConfigLevelNotMatch, (String[])new String[]{dimens});
            }
            if (componentId != 0 || dimensArrayUnit.length == 1) continue;
            return ResultCode.getExtendResultCode((ResultCode)ResultCode.filterConfigLevelNotMatch, (String[])new String[]{dimens});
        }
        List missList = list.stream().filter(item -> !configList.contains(item)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(missList)) {
            String commaSeparatedString = String.join((CharSequence)",", missList);
            return ResultCode.getExtendResultCode((ResultCode)ResultCode.filterConfigDimensMissing, (String[])new String[]{commaSeparatedString});
        }
        RenderConfig renderConfig = stat.getRenderConfig();
        renderConfig.setFilters(filterConfigs);
        this.statDao.update((Stat)stat);
        return ResultCode.success;
    }

    public ResultCode chartsConfig(StatVO stat, List<RenderChartConfig> chartConfigs) {
        if (CollectionUtils.isEmpty(chartConfigs)) {
            return ResultCode.renderConfigConfigCannotBeEmpty;
        }
        RenderConfig renderConfig = stat.getRenderConfig();
        if (renderConfig == null) {
            renderConfig = new RenderConfig();
            stat.setRenderConfig(renderConfig);
        }
        renderConfig.setCharts(chartConfigs);
        this.statDao.update((Stat)stat);
        return ResultCode.success;
    }

    public int count(StatQueryParam queryParam) {
        return this.statDao.count(queryParam);
    }

    public List<DBStatistics> getTopDepartmentStatSize() {
        return this.statDao.getTopDepartmentStatSize();
    }

    public List<Stat> queryByGroupId(Integer groupId) {
        StatQueryParam statQueryParam = new StatQueryParam();
        statQueryParam.setGroupIds(List.of(groupId));
        return this.statDao.queryList(statQueryParam);
    }
}

