/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.enums.OrderTypeEnum;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.enums.UserStateEnum;
import com.dtstep.lighthouse.common.modal.PermissionEnum;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.insights.dao.DepartmentDao;
import com.dtstep.lighthouse.insights.dao.UserDao;
import com.dtstep.lighthouse.insights.dto.PermissionQueryParam;
import com.dtstep.lighthouse.insights.dto.UserQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.OrderService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.UserVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private BaseService baseService;
    @Autowired
    private ResourceService resourceService;

    @Transactional
    public int create(User user, boolean needApprove) throws Exception {
        user.setState(needApprove ? UserStateEnum.USER_PEND : UserStateEnum.USER_NORMAL);
        LocalDateTime localDateTime = LocalDateTime.now();
        user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
        user.setCreateTime(localDateTime);
        user.setUpdateTime(localDateTime);
        user.setLastTime(localDateTime);
        this.userDao.insert(user);
        int userId = user.getId();
        if (needApprove) {
            this.orderService.submit(user, OrderTypeEnum.USER_PEND_APPROVE, null, null);
        }
        return userId;
    }

    public int update(User user) {
        user.setUpdateTime(LocalDateTime.now());
        return this.userDao.update(user);
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryById' + '_' + #id", cacheManager="caffeineCacheManager", unless="#result == null")
    public User cacheQueryById(int id) {
        return this.userDao.queryById(Integer.valueOf(id));
    }

    public boolean isUserNameExist(String username) {
        return this.userDao.isUserNameExist(username);
    }

    public User queryById(int id) {
        return this.userDao.queryById(Integer.valueOf(id));
    }

    public UserStateEnum queryUserState(Integer id) {
        return UserStateEnum.forValue((int)this.userDao.queryUserState(id));
    }

    public User queryAllInfoByUserName(String userName) {
        return this.userDao.queryAllInfoByUserName(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<UserVO> queryList(UserQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = null;
        ArrayList<UserVO> dtoList = new ArrayList<UserVO>();
        try {
            List userList = this.userDao.queryList(queryParam);
            pageInfo = new PageInfo(userList);
        }
        finally {
            PageHelper.clearPage();
        }
        for (User user : pageInfo.getList()) {
            UserVO vo = new UserVO(user);
            vo.addPermission(PermissionEnum.ManageAble);
            dtoList.add(vo);
        }
        return ListData.newInstance(dtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public List<User> termQuery(String search) {
        return this.userDao.termQuery(search);
    }

    public List<User> termQueryByIds(List<Integer> ids) {
        return this.userDao.termQueryByIds(ids);
    }

    @Transactional
    public int deleteById(int id) {
        PermissionQueryParam queryParam = new PermissionQueryParam();
        queryParam.setOwnerId(Integer.valueOf(id));
        queryParam.setOwnerType(OwnerTypeEnum.USER);
        this.permissionService.delete(queryParam);
        return this.userDao.deleteById(Integer.valueOf(id));
    }

    public int count(UserQueryParam queryParam) {
        return this.userDao.count(queryParam);
    }

    public String queryUserPassword(Integer id) {
        return this.userDao.queryUserPassword(id);
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'getUserPermissions' + '_' + #id", cacheManager="caffeineCacheManager", unless="#result == null")
    public Set<PermissionEnum> getUserPermissions(Integer id) {
        Role optManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.OPT_MANAGE_PERMISSION, Integer.valueOf(0));
        boolean hasOptManageRole = this.permissionService.checkUserPermission(id, optManageRole.getId());
        Role sysManageRole = this.roleService.cacheQueryRole(RoleTypeEnum.FULL_MANAGE_PERMISSION, Integer.valueOf(0));
        boolean hasSysManageRole = this.permissionService.checkUserPermission(id, sysManageRole.getId());
        HashSet<PermissionEnum> sets = new HashSet<PermissionEnum>();
        if (hasOptManageRole) {
            sets.add(PermissionEnum.OperationManageAble);
        }
        if (hasSysManageRole) {
            sets.add(PermissionEnum.SystemManageAble);
        }
        return sets;
    }
}

