/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.enums.PrivateTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.PermissionEnum;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.View;
import com.dtstep.lighthouse.common.modal.ViewQueryParam;
import com.dtstep.lighthouse.insights.dao.ViewDao;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.service.ViewService;
import com.dtstep.lighthouse.insights.vo.ViewVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ViewServiceImpl
implements ViewService {
    @Autowired
    private ViewDao viewDao;
    @Autowired
    private BaseService baseService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private UserService userService;

    public List<ViewVO> queryByIds(List<Integer> ids) {
        ViewQueryParam queryParam = new ViewQueryParam();
        queryParam.setIds(ids);
        List viewList = this.viewDao.queryList(queryParam);
        ArrayList<ViewVO> voList = new ArrayList<ViewVO>();
        for (View view : viewList) {
            ViewVO viewVO = this.translate(view);
            voList.add(viewVO);
        }
        return voList;
    }

    public ViewVO queryById(Integer id) {
        View view = this.viewDao.queryById(id);
        ViewVO viewVO = null;
        if (view != null) {
            viewVO = this.translate(view);
        }
        return viewVO;
    }

    private ViewVO translate(View view) {
        List adminIds;
        ViewVO viewVO = new ViewVO(view);
        Integer currentUserId = this.baseService.getCurrentUserId();
        Role manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.VIEW_MANAGE_PERMISSION, view.getId());
        Role accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.VIEW_ACCESS_PERMISSION, view.getId());
        if (currentUserId != null) {
            if (this.permissionService.checkUserPermission(currentUserId, manageRole.getId())) {
                viewVO.addPermission(PermissionEnum.ManageAble);
                viewVO.addPermission(PermissionEnum.AccessAble);
            } else if (view.getPrivateType() == PrivateTypeEnum.Public || this.permissionService.checkUserPermission(currentUserId, accessRole.getId())) {
                viewVO.addPermission(PermissionEnum.AccessAble);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(adminIds = this.permissionService.queryUserPermissionsByRoleId(manageRole.getId(), Integer.valueOf(3))))) {
            List admins = adminIds.stream().map(z -> this.userService.cacheQueryById(z.intValue())).collect(Collectors.toList());
            viewVO.setAdmins(admins);
        }
        return viewVO;
    }
}

