/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.types;

import com.dtstep.lighthouse.common.util.JsonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class BaseObjectTypeHandler<T>
extends BaseTypeHandler<T> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final TypeReference<T> typeReference;

    public BaseObjectTypeHandler(TypeReference<T> typeReference) {
        this.typeReference = typeReference;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        try {
            String json = JsonUtil.toJSONString(parameter);
            ps.setString(i, json);
        }
        catch (Exception e) {
            throw new SQLException("Failed to convert Map to JSON", e);
        }
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String json = rs.getString(columnName);
        return (T)this.parseJson(json);
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String json = rs.getString(columnIndex);
        return (T)this.parseJson(json);
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String json = cs.getString(columnIndex);
        return (T)this.parseJson(json);
    }

    private T parseJson(String json) throws SQLException {
        try {
            if (json == null) {
                return null;
            }
            return (T)JsonUtil.readValue((String)json, (TypeReference)this.typeReference);
        }
        catch (IOException e) {
            throw new SQLException("Failed to parse JSON", e);
        }
        catch (Exception e) {
            throw new SQLException("Failed to parse JSON", e);
        }
    }
}

