/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.client;

import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.client.rpc.RPCClientProxy;
import com.dtstep.lighthouse.common.entity.group.GroupVerifyEntity;
import com.dtstep.lighthouse.common.entity.stat.StatVerifyEntity;
import com.dtstep.lighthouse.common.enums.RunningMode;
import com.dtstep.lighthouse.common.exception.LightSendException;
import com.dtstep.lighthouse.common.lru.Cache;
import com.dtstep.lighthouse.common.lru.LRU;
import com.dtstep.lighthouse.common.util.Md5Util;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class AuxHandler {
    private static final Cache<String, Optional<GroupVerifyEntity>> groupHolder = LRU.newBuilder().maximumSize(50000L).expireAfterWrite(90L, TimeUnit.SECONDS).softValues().build();
    private static final Cache<Integer, Optional<StatVerifyEntity>> statHolder = LRU.newBuilder().maximumSize(50000L).expireAfterWrite(90L, TimeUnit.SECONDS).softValues().build();
    private static final Cache<String, String> md5CacheHolder = LRU.newBuilder().maximumSize(50000L).expireAfterWrite(2L, TimeUnit.MINUTES).softValues().build();

    public static GroupVerifyEntity queryGroupInfo(String token) {
        return groupHolder.get(token, k -> {
            GroupVerifyEntity groupVerifyEntity;
            try {
                groupVerifyEntity = RPCClientProxy.instance().queryGroupInfo(token);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new LightSendException(ex);
            }
            return Optional.ofNullable(groupVerifyEntity);
        }).orElse(null);
    }

    public static StatVerifyEntity queryStatInfo(int id) {
        return statHolder.get(id, k -> {
            StatVerifyEntity statVerifyEntity;
            try {
                statVerifyEntity = RPCClientProxy.instance().queryStatInfo(id);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new LightSendException(ex);
            }
            return Optional.ofNullable(statVerifyEntity);
        }).orElse(null);
    }

    public static String cacheGetMd5(String str) {
        return md5CacheHolder.get(str, t -> Md5Util.getMD5(str));
    }

    public static RunningMode getRunningMode() {
        return LightHouse.getRunningMode();
    }
}

