/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.client;

import com.dtstep.lighthouse.client.DelayRunnable;
import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.entity.event.SimpleSlotEvent;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Consumer {
    private static final Logger logger = LoggerFactory.getLogger(Consumer.class);
    private static final int threadSize = 4;
    private static ScheduledExecutorService executor;
    private final EventPool<SimpleSlotEvent> eventPool;
    private final int frequency;
    private final int batchSize;

    Consumer(EventPool<SimpleSlotEvent> eventPool, int frequency, int batchSize) {
        this.eventPool = eventPool;
        this.frequency = frequency;
        this.batchSize = batchSize;
        if (executor != null && !executor.isShutdown()) {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                    logger.error("lighthouse executor shutdown failed!");
                }
            }
            catch (Exception ex) {
                logger.error("lighthouse executor shutdown failed!", (Throwable)ex);
            }
        }
        executor = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor(4, new BasicThreadFactory.Builder().namingPattern("ldp-consumer-schedule-pool-%d").daemon(true).build());
    }

    public void start() {
        for (int i = 0; i < 4; ++i) {
            executor.scheduleWithFixedDelay(new DelayRunnable(this.eventPool, this.batchSize), 0L, this.frequency, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() {
        if (executor != null && !executor.isShutdown()) {
            executor.shutdown();
        }
    }

    public void destroy() throws Exception {
        int delay = 30;
        if (!executor.isShutdown()) {
            for (int i = 0; i < delay && !this.eventPool.isEmpty(); ++i) {
                Thread.sleep(1000L);
            }
            executor.shutdown();
        }
        if (!this.eventPool.isEmpty()) {
            this.eventPool.clear();
            throw new InterruptedException("lighthouse thread resource release exception!");
        }
    }
}

