/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.client;

import com.dtstep.lighthouse.client.AuxHandler;
import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.entity.event.SimpleSlotEvent;
import com.dtstep.lighthouse.common.entity.group.GroupVerifyEntity;
import com.dtstep.lighthouse.common.entity.stat.TimeParam;
import com.dtstep.lighthouse.common.enums.ColumnTypeEnum;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.MessageHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Producer {
    private static final Logger logger = LoggerFactory.getLogger(Producer.class);
    private final EventPool<SimpleSlotEvent> eventPool;

    Producer(EventPool<SimpleSlotEvent> eventPool) {
        this.eventPool = eventPool;
    }

    void send(String token, String secretKey, Map<String, Object> paramMap, int repeat, long timestamp) throws Exception {
        GroupVerifyEntity groupVerifyEntity = AuxHandler.queryGroupInfo(token);
        if (groupVerifyEntity == null) {
            throw new IllegalArgumentException(String.format("statistic group(%s) does not exist!", token));
        }
        String md5 = AuxHandler.cacheGetMd5(secretKey);
        if (!groupVerifyEntity.getVerifyKey().equals(md5)) {
            throw new IllegalArgumentException(String.format("statistic group(%s) key verification failed!", token));
        }
        if (groupVerifyEntity.getState() != GroupStateEnum.RUNNING) {
            throw new IllegalArgumentException(String.format("statistic group(%s) status is abnormal!", token));
        }
        TimeParam timeParam = groupVerifyEntity.getMinTimeParam();
        if (timeParam != null && timeParam.getInterval() != 0) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Map<String, ColumnTypeEnum> relationColumnSet = groupVerifyEntity.getRelationColumns();
            if (relationColumnSet != null) {
                for (String column : relationColumnSet.keySet()) {
                    Object columnValue = paramMap.get(column);
                    if (columnValue == null) continue;
                    String columnValueStr = columnValue.toString();
                    map.put(column, columnValueStr);
                }
            }
            long microTime = DateUtil.batchTime(groupVerifyEntity.getMinTimeParam().getInterval(), groupVerifyEntity.getMinTimeParam().getTimeUnit(), timestamp);
            String message = MessageHelper.serializeOfText(groupVerifyEntity.getGroupId(), map, microTime);
            this.process(message, repeat);
        }
    }

    private void process(String message, int repeat) throws Exception {
        this.eventPool.put(HashUtil.getHashIndex(message, this.eventPool.slotSize()), new SimpleSlotEvent(message, repeat));
    }
}

