/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.aggregator;

import com.dtstep.lighthouse.common.entity.event.SlotEvent;
import com.dtstep.lighthouse.common.queue.BoundedPriorityBlockingQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlotsGroup<T extends SlotEvent<T>> {
    private static final Logger logger = LoggerFactory.getLogger(SlotsGroup.class);
    private final HashMap<Integer, SlotWrapper<T>> slotsMap = new HashMap();

    public SlotsGroup(int size, int capacity, Comparator<T> comparator) {
        for (int i = 0; i < size; ++i) {
            this.slotsMap.put(i, new SlotWrapper<T>(capacity, comparator));
        }
    }

    public SlotsGroup(int size, int capacity) {
        for (int i = 0; i < size; ++i) {
            this.slotsMap.put(i, new SlotWrapper(capacity));
        }
    }

    public SlotWrapper<T> getSlotWrapper(int slot) {
        return this.slotsMap.get(slot);
    }

    public void put(int slot, T t) throws Exception {
        BlockingQueue<T> queue = this.slotsMap.get(slot).getQueue();
        try {
            queue.put(t);
        }
        catch (InterruptedException ex) {
            logger.error("event pool put error!", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    public static class SlotWrapper<T extends SlotEvent<T>> {
        private BlockingQueue<T> queue;
        private long lastAccessTime;
        private long headElementTime;
        private int capacity;

        public SlotWrapper(int capacity) {
            this.queue = new BoundedPriorityBlockingQueue<T>(capacity);
            this.capacity = capacity;
            this.lastAccessTime = System.currentTimeMillis();
        }

        public SlotWrapper(int capacity, Comparator<T> comparator) {
            this.queue = new BoundedPriorityBlockingQueue<T>(capacity, comparator);
            this.lastAccessTime = System.currentTimeMillis();
        }

        public BlockingQueue<T> getQueue() {
            return this.queue;
        }

        public void setQueue(LinkedBlockingQueue<T> queue) {
            this.queue = queue;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public void setLastAccessTime(long lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public long getHeadElementTime() {
            return this.headElementTime;
        }

        public void setHeadElementTime(long headElementTime) {
            this.headElementTime = headElementTime;
        }

        public List<T> getEvents(int batch) throws Exception {
            ArrayList list = new ArrayList();
            this.queue.drainTo(list, batch);
            this.setLastAccessTime(System.currentTimeMillis());
            SlotEvent t = (SlotEvent)this.queue.peek();
            if (t != null) {
                long headElementTime = t.getEventTimestamp();
                this.setHeadElementTime(headElementTime);
            } else {
                this.setHeadElementTime(Long.MAX_VALUE);
            }
            return list;
        }

        public int size() throws Exception {
            return this.queue.size();
        }
    }
}

