/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.rpc.netty;

import com.dtstep.lighthouse.common.entity.rpc.RpcMsgType;
import com.dtstep.lighthouse.common.entity.rpc.RpcRequest;
import com.dtstep.lighthouse.common.entity.rpc.RpcResponse;
import com.dtstep.lighthouse.common.ice.LightRpcException;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.common.rpc.netty.NettyClientAdapter;
import com.dtstep.lighthouse.common.rpc.netty.ProcessedFuture;
import com.dtstep.lighthouse.common.util.StringUtil;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.util.concurrent.Future;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteProxy
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteProxy.class);
    private final Class<?> clazz;
    private final List<InetSocketAddress> addressList;

    public RemoteProxy(List<InetSocketAddress> addressList, Class<?> clazz) {
        this.addressList = addressList;
        this.clazz = clazz;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        return this.invoke(method, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Method method, Object[] args2) throws Exception {
        RpcRequest rpcRequest = new RpcRequest();
        String reqId = RandomID.id(32);
        rpcRequest.setRequestId(reqId);
        rpcRequest.setClassName(this.clazz.getName());
        rpcRequest.setMethodName(method.getName());
        CompletableFuture completableFuture = new CompletableFuture();
        ProcessedFuture.put(reqId, completableFuture);
        rpcRequest.setParameterTypes(method.getParameterTypes());
        rpcRequest.setParameterValues(args2);
        rpcRequest.setType(RpcMsgType.Normal);
        ChannelPoolMap<InetSocketAddress, ChannelPool> poolMap = NettyClientAdapter.getPoolMap();
        ChannelPool pool = poolMap.get(this.addressList.get(ThreadLocalRandom.current().nextInt(this.addressList.size())));
        Future<Channel> future = pool.acquire().sync();
        Channel channel = future.getNow();
        if (logger.isDebugEnabled()) {
            logger.debug("Remote request,use channel:{}", (Object)channel.id());
        }
        try {
            channel.writeAndFlush(rpcRequest).sync();
        }
        finally {
            pool.release(channel);
        }
        RpcResponse<?> res = completableFuture.get();
        if (StringUtil.isNotEmpty(res.getError())) {
            throw new LightRpcException(res.getError());
        }
        return res.getResult();
    }
}

