/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DateUtil {
    private static final String FORMAT_STR_1 = "yyyy-MM-dd HH:mm:ss";
    private static final String FORMAT_STR_2 = "yyyyMMddHHmmss";
    private static final String FORMAT_STR_3 = "yyyyMMddHHmm";
    private static final String FORMAT_STR_4 = "yyyyMMddHH";
    private static final String FORMAT_STR_5 = "yyyy-MM-dd";
    private static final String FORMAT_STR_6 = "yyyyMMdd";
    private static final String FORMAT_STR_7 = "HH:mm:ss";
    private static final String FORMAT_STR_8 = "HH:mm";
    private static final DateTimeFormatter TIME_FORMATTER1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter TIME_FORMATTER2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter TIME_FORMATTER3 = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    private static final DateTimeFormatter TIME_FORMATTER4 = DateTimeFormatter.ofPattern("yyyyMMddHH");
    private static final DateTimeFormatter TIME_FORMATTER5 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER6 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter TIME_FORMATTER7 = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter TIME_FORMATTER8 = DateTimeFormatter.ofPattern("HH:mm");

    private DateUtil() {
    }

    public static long getCurrentHourTime() {
        return DateUtil.getCurrentHourTime(System.currentTimeMillis());
    }

    public static long getCurrentHourTime(long t) {
        return t / 3600000L * 3600000L;
    }

    public static long getCurrentMinuteTime() {
        return DateUtil.getCurrentMinuteTime(System.currentTimeMillis());
    }

    public static long getCurrentMinuteTime(long t) {
        return t / 60000L * 60000L;
    }

    public static LocalDate date2LocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime date2ToLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime timestampToLocalDateTime(long t) {
        return Instant.ofEpochMilli(t).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date localDate2Date(LocalDate localDate) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay().atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        ZonedDateTime zdt = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static long getDayStartTime(long t) {
        return Instant.ofEpochMilli(t).atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getDayEndTime(long t) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        LocalDateTime endTime = LocalDateTime.of(localDateTime.toLocalDate(), LocalTime.MAX);
        return endTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static int getDayIndexOfYear(long t) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.getDayOfYear();
    }

    public static int getMonthIndexOfYear(long t) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.getMonthValue();
    }

    public static int getYear(long t) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.getYear();
    }

    public static long getDayTime(int year, int dayOfYear) {
        LocalDate localDate = LocalDate.ofYearDay(year, dayOfYear);
        return localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getYearStartTime(int year) {
        LocalDate date = LocalDate.of(year, 1, 1);
        return date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getYearStartTime(long t) {
        int year = DateUtil.getYear(t);
        return LocalDate.of(year, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getDayBefore(long t, int beforeDay) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.minusDays(beforeDay).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getDayAfter(long t, int afterDay) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.plusDays(afterDay).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long daysBetween(long t1, long t2) {
        LocalDate localDate1 = LocalDateTime.ofInstant(Instant.ofEpochMilli(t1), ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = LocalDateTime.ofInstant(Instant.ofEpochMilli(t2), ZoneId.systemDefault()).toLocalDate();
        return localDate1.until(localDate2, ChronoUnit.DAYS);
    }

    public static long getWeekStartTime(long t) {
        TemporalField fieldISO = WeekFields.of(Locale.getDefault()).dayOfWeek();
        LocalDate localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault()).toLocalDate();
        return localDate.with(fieldISO, 1L).atStartOfDay(ZoneId.systemDefault()).plusDays(1L).toInstant().toEpochMilli();
    }

    public static long getWeekEndTime(long t) {
        TemporalField fieldISO = WeekFields.of(Locale.getDefault()).dayOfWeek();
        LocalDate localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault()).toLocalDate().with(fieldISO, 7L).plusDays(1L);
        LocalDateTime endTime = LocalDateTime.of(localDate, LocalTime.MAX);
        return endTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getMonthStartTime(long t) {
        LocalDate localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault()).toLocalDate();
        return localDate.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getMonthEndTime(long t) {
        LocalDate localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault()).toLocalDate().with(TemporalAdjusters.lastDayOfMonth());
        LocalDateTime endTime = LocalDateTime.of(localDate, LocalTime.MAX);
        return endTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getMonthStartTime(int year, int month) {
        LocalDate localDate = LocalDate.of(year, month, 1);
        return localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getMonthEndTime(int year, int month) {
        LocalDate localDate = LocalDate.of(year, month, 1).with(TemporalAdjusters.lastDayOfMonth());
        LocalDateTime endTime = LocalDateTime.of(localDate, LocalTime.MAX);
        return endTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getHourStartTime(long t) {
        return DateUtil.getCurrentHourTime(t);
    }

    public static long getHourEndTime(long t) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault()).withMinute(59).withSecond(59).withNano(999);
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getHourBefore(long t, int n) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.minusHours(n).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getHourAfter(long t, int n) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.plusHours(n).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getMinuteBefore(long t, int n) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.minusMinutes(n).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getSecondBefore(long t, long n) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.minusSeconds(n).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getSecondAfter(long t, int n) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.plusSeconds(n).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long getMinuteAfter(long t, int n) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault());
        return localDateTime.plusMinutes(n).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static List<String> getBetweenDays(String startDate, String endDate) throws Exception {
        long t1 = DateUtil.parseDate(startDate, FORMAT_STR_5);
        long t2 = DateUtil.parseDate(endDate, FORMAT_STR_5);
        return DateUtil.getBetweenDays(t1, t2);
    }

    public static List<String> getBetweenDays(long startTime, long endTime) {
        List<String> list = new ArrayList<String>();
        LocalDate startDate = Instant.ofEpochMilli(startTime).atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDate = Instant.ofEpochMilli(endTime).atZone(ZoneId.systemDefault()).toLocalDate();
        if (startTime == endTime) {
            list.add(startDate.format(DateTimeFormatter.ofPattern(FORMAT_STR_5)));
            return list;
        }
        long distance = ChronoUnit.DAYS.between(startDate, endDate);
        if (distance < 1L) {
            return list;
        }
        list = Stream.iterate(startDate, d -> d.plusDays(1L)).limit(distance + 1L).map(LocalDate::toString).collect(Collectors.toList());
        return list;
    }

    public static String formatDate(Date date, String fmt) {
        return DateUtil.formatTimeStamp(date.getTime(), fmt);
    }

    public static String formatTimeStamp(long time, String fmt) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
        if (FORMAT_STR_8.equals(fmt)) {
            return localDateTime.format(TIME_FORMATTER8);
        }
        if (FORMAT_STR_7.equals(fmt)) {
            return localDateTime.format(TIME_FORMATTER7);
        }
        if (FORMAT_STR_6.equals(fmt)) {
            return localDateTime.format(TIME_FORMATTER6);
        }
        if (FORMAT_STR_5.equals(fmt)) {
            return localDateTime.format(TIME_FORMATTER5);
        }
        if (FORMAT_STR_4.equals(fmt)) {
            return localDateTime.format(TIME_FORMATTER4);
        }
        if (FORMAT_STR_3.equals(fmt)) {
            return localDateTime.format(TIME_FORMATTER3);
        }
        if (FORMAT_STR_2.equals(fmt)) {
            return localDateTime.format(TIME_FORMATTER2);
        }
        if (FORMAT_STR_1.equals(fmt)) {
            return localDateTime.format(TIME_FORMATTER1);
        }
        return localDateTime.format(DateTimeFormatter.ofPattern(fmt));
    }

    public static String formatLocalTime(LocalTime localTime, String fmt) {
        if (FORMAT_STR_7.equals(fmt)) {
            return localTime.format(TIME_FORMATTER7);
        }
        if (FORMAT_STR_8.equals(fmt)) {
            return localTime.format(TIME_FORMATTER8);
        }
        return null;
    }

    public static long parseDate(String dateStr, String fmt) {
        if (FORMAT_STR_6.equals(fmt)) {
            LocalDate ldt = LocalDate.parse(dateStr, TIME_FORMATTER6);
            return ldt.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (FORMAT_STR_5.equals(fmt)) {
            LocalDate ldt = LocalDate.parse(dateStr, TIME_FORMATTER5);
            return ldt.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (FORMAT_STR_4.equals(fmt)) {
            LocalDateTime ldt = LocalDateTime.parse(dateStr, TIME_FORMATTER4);
            return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (FORMAT_STR_3.equals(fmt)) {
            LocalDateTime ldt = LocalDateTime.parse(dateStr, TIME_FORMATTER3);
            return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (FORMAT_STR_2.equals(fmt)) {
            LocalDateTime ldt = LocalDateTime.parse(dateStr, TIME_FORMATTER2);
            return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (FORMAT_STR_1.equals(fmt)) {
            LocalDateTime ldt = LocalDateTime.parse(dateStr, TIME_FORMATTER1);
            return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        LocalDateTime ldt = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(fmt));
        return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long batchTime(int interval, TimeUnit timeUnit, long current) {
        long duration = timeUnit.toMillis(interval);
        int year = DateUtil.getYear(current);
        long res = 0L;
        if (timeUnit == TimeUnit.MINUTES) {
            long yearStart = DateUtil.getYearStartTime(year);
            int index = (int)((current - yearStart) / duration);
            res = yearStart + (long)index * duration;
        } else if (timeUnit == TimeUnit.HOURS) {
            long yearStart = DateUtil.getYearStartTime(year);
            int index = (int)((current - yearStart) / duration);
            res = yearStart + (long)index * duration;
        } else if (timeUnit == TimeUnit.DAYS) {
            int dayIndex = DateUtil.getDayIndexOfYear(current);
            int tempIndex = (dayIndex - 1) / interval * interval + 1;
            res = DateUtil.getDayTime(year, tempIndex);
        } else if (timeUnit == TimeUnit.SECONDS) {
            long yearStart = DateUtil.getYearStartTime(year);
            int index = (int)((current - yearStart) / duration);
            res = yearStart + (long)index * duration;
        }
        return res;
    }

    public static long previousBatchTime(int interval, TimeUnit timeUnit, long current) {
        return DateUtil.batchTime(interval, timeUnit, current - timeUnit.toMillis(interval));
    }

    public static int getCurrentYear() {
        LocalDateTime currentDate = LocalDateTime.now();
        return currentDate.getYear();
    }

    public static long translateToTimeStamp(LocalDateTime localDateTime) {
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static long getDateAfterMonths(long timestamp, int months) {
        LocalDateTime date = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime newDate = date.plusMonths(months);
        return newDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }
}

