/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import com.dtstep.lighthouse.common.entity.message.LightMessage;
import com.dtstep.lighthouse.common.sbr.StringBuilderHolder;
import com.dtstep.lighthouse.common.util.StringUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageHelper {
    private static final Logger logger = LoggerFactory.getLogger(MessageHelper.class);

    public static LightMessage parseText(String message) {
        if (StringUtil.isEmpty(message)) {
            return null;
        }
        LightMessage entity = new LightMessage();
        StringTokenizer stringTokenizer = new StringTokenizer(message, "\u0004");
        int index = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String temp = stringTokenizer.nextToken();
            if (index == 0) {
                entity.setGroupId(Integer.parseInt(temp));
            } else if (index == 1) {
                entity.setTime(Long.parseLong(temp));
            } else if (index == 2) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                if (!StringUtil.isEmptyOrNullStr(temp)) {
                    StringTokenizer subTokenizer = new StringTokenizer(temp, "\u0005");
                    while (subTokenizer.hasMoreTokens()) {
                        String kv = subTokenizer.nextToken();
                        int separator = kv.indexOf("\u0006");
                        String key = kv.substring(0, separator);
                        String value = kv.substring(separator + 1);
                        if (value.contains(";")) {
                            value = value.replaceAll(";", "_");
                        } else if (value.contains(",")) {
                            value = value.replaceAll(",", "_");
                        }
                        paramMap.put(key, value);
                    }
                }
                entity.setParamMap(paramMap);
            } else if (index == 3 && !StringUtil.isEmpty(temp)) {
                entity.setRepeat(Integer.parseInt(temp));
            }
            ++index;
        }
        return entity;
    }

    public static String serializeOfText(int groupId, LinkedHashMap<String, String> paramMap, long timestamp) {
        StringBuilder sbr = StringBuilderHolder.Normal.getStringBuilder().append(groupId).append("\u0004").append(timestamp).append("\u0004");
        if (paramMap == null || paramMap.isEmpty()) {
            sbr.append("null");
        } else {
            int i = 0;
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                if (i != 0) {
                    sbr.append("\u0005");
                }
                sbr.append(entry.getKey()).append("\u0006").append(entry.getValue());
                ++i;
            }
        }
        return sbr.toString();
    }

    @Deprecated
    public static String serializeOfText(LightMessage lightMessage) {
        if (lightMessage == null) {
            return null;
        }
        StringBuilder sbr = StringBuilderHolder.Normal.getStringBuilder().append(lightMessage.getGroupId()).append("\u0004").append(lightMessage.getTime()).append("\u0004");
        Map<String, String> paramMap = lightMessage.getParamMap();
        if (paramMap == null || paramMap.isEmpty()) {
            sbr.append("null");
        } else {
            int i = 0;
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                if (i != 0) {
                    sbr.append("\u0005");
                }
                sbr.append(entry.getKey()).append("\u0006").append(entry.getValue());
                ++i;
            }
        }
        return sbr.toString();
    }
}

