/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import com.dtstep.lighthouse.common.util.Base64;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.xerial.snappy.Snappy;

public final class SnappyUtil {
    public static String compress(String str) throws Exception {
        byte[] b = Snappy.compress(str.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeToString(b);
    }

    public static byte[] compressToByte(String str) throws Exception {
        return Snappy.compress(str.getBytes(StandardCharsets.UTF_8));
    }

    public static String uncompress(String str) throws IOException {
        byte[] decode = Base64.decode(str);
        return new String(Snappy.uncompress(decode), StandardCharsets.UTF_8);
    }

    public static String uncompressByte(byte[] decode) throws IOException {
        return new String(Snappy.uncompress(decode), StandardCharsets.UTF_8);
    }

    public static boolean isCompress(byte[] bytes) throws Exception {
        return Snappy.isValidCompressedBuffer(bytes);
    }
}

