/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.EncapsulationException;
import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.MarshalException;
import com.zeroc.Ice.NoValueFactoryException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.SliceInfo;
import com.zeroc.Ice.SlicedData;
import com.zeroc.Ice.UnknownSlicedValue;
import com.zeroc.Ice.UnknownUserException;
import com.zeroc.Ice.UnmarshalOutOfBoundsException;
import com.zeroc.Ice.UserException;
import com.zeroc.Ice.UserExceptionFactory;
import com.zeroc.Ice.Value;
import com.zeroc.Ice.ValueFactory;
import com.zeroc.Ice.ValueFactoryManager;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.InputStreamWrapper;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.ObjectInputStream;
import com.zeroc.IceInternal.Protocol;
import com.zeroc.IceInternal.TraceUtil;
import com.zeroc.IceInternal.Util;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;

public class InputStream {
    static final Charset _utf8 = Charset.forName("UTF8");
    private Instance _instance;
    private Buffer _buf;
    private Object _closure;
    private byte[] _stringBytes;
    private char[] _stringChars;
    private EncodingVersion _encoding;
    private Encaps _encapsStack;
    private Encaps _encapsCache;
    private boolean _sliceValues;
    private boolean _traceSlicing;
    private int _startSeq;
    private int _minSeqSize;
    private ValueFactoryManager _valueFactoryManager;
    private Logger _logger;
    private IntFunction<String> _compactIdResolver;
    private Function<String, Class<?>> _classResolver;

    public InputStream() {
        this.initialize(Protocol.currentEncoding);
        this._buf = new Buffer(false);
    }

    public InputStream(byte[] data) {
        this.initialize(Protocol.currentEncoding);
        this._buf = new Buffer(data);
    }

    public InputStream(ByteBuffer buf) {
        this.initialize(Protocol.currentEncoding);
        this._buf = new Buffer(buf);
    }

    public InputStream(Buffer buf) {
        this(buf, false);
    }

    public InputStream(Buffer buf, boolean adopt) {
        this.initialize(Protocol.currentEncoding);
        this._buf = new Buffer(buf, adopt);
    }

    public InputStream(Communicator communicator) {
        Instance instance = Util.getInstance(communicator);
        this.initialize(instance, instance.defaultsAndOverrides().defaultEncoding);
        this._buf = new Buffer(instance.cacheMessageBuffers() > 1);
    }

    public InputStream(Communicator communicator, byte[] data) {
        this.initialize(communicator);
        this._buf = new Buffer(data);
    }

    public InputStream(Communicator communicator, ByteBuffer buf) {
        this.initialize(communicator);
        this._buf = new Buffer(buf);
    }

    public InputStream(Communicator communicator, Buffer buf) {
        this(communicator, buf, false);
    }

    public InputStream(Communicator communicator, Buffer buf, boolean adopt) {
        this.initialize(communicator);
        this._buf = new Buffer(buf, adopt);
    }

    public InputStream(EncodingVersion encoding) {
        this.initialize(encoding);
        this._buf = new Buffer(false);
    }

    public InputStream(EncodingVersion encoding, byte[] data) {
        this.initialize(encoding);
        this._buf = new Buffer(data);
    }

    public InputStream(EncodingVersion encoding, ByteBuffer buf) {
        this.initialize(encoding);
        this._buf = new Buffer(buf);
    }

    public InputStream(EncodingVersion encoding, Buffer buf) {
        this(encoding, buf, false);
    }

    public InputStream(EncodingVersion encoding, Buffer buf, boolean adopt) {
        this.initialize(encoding);
        this._buf = new Buffer(buf, adopt);
    }

    public InputStream(Communicator communicator, EncodingVersion encoding) {
        Instance instance = Util.getInstance(communicator);
        this.initialize(instance, encoding);
        this._buf = new Buffer(instance.cacheMessageBuffers() > 1);
    }

    public InputStream(Communicator communicator, EncodingVersion encoding, byte[] data) {
        this.initialize(communicator, encoding);
        this._buf = new Buffer(data);
    }

    public InputStream(Communicator communicator, EncodingVersion encoding, ByteBuffer buf) {
        this.initialize(communicator, encoding);
        this._buf = new Buffer(buf);
    }

    public InputStream(Communicator communicator, EncodingVersion encoding, Buffer buf) {
        this(communicator, encoding, buf, false);
    }

    public InputStream(Communicator communicator, EncodingVersion encoding, Buffer buf, boolean adopt) {
        this.initialize(communicator, encoding);
        this._buf = new Buffer(buf, adopt);
    }

    public InputStream(Instance instance, EncodingVersion encoding) {
        this(instance, encoding, instance.cacheMessageBuffers() > 1);
    }

    public InputStream(Instance instance, EncodingVersion encoding, boolean direct) {
        this.initialize(instance, encoding);
        this._buf = new Buffer(direct);
    }

    public InputStream(Instance instance, EncodingVersion encoding, byte[] data) {
        this.initialize(instance, encoding);
        this._buf = new Buffer(data);
    }

    public InputStream(Instance instance, EncodingVersion encoding, ByteBuffer data) {
        this.initialize(instance, encoding);
        this._buf = new Buffer(data);
    }

    public InputStream(Instance instance, EncodingVersion encoding, Buffer buf, boolean adopt) {
        this.initialize(instance, encoding);
        this._buf = new Buffer(buf, adopt);
    }

    public void initialize(Communicator communicator) {
        Instance instance = Util.getInstance(communicator);
        this.initialize(instance, instance.defaultsAndOverrides().defaultEncoding);
    }

    public void initialize(Communicator communicator, EncodingVersion encoding) {
        Instance instance = Util.getInstance(communicator);
        this.initialize(instance, encoding);
    }

    private void initialize(Instance instance, EncodingVersion encoding) {
        this.initialize(encoding);
        this._instance = instance;
        this._traceSlicing = this._instance.traceLevels().slicing > 0;
        this._valueFactoryManager = this._instance.initializationData().valueFactoryManager;
        this._logger = this._instance.initializationData().logger;
        this._classResolver = this._instance;
    }

    private void initialize(EncodingVersion encoding) {
        this._instance = null;
        this._encoding = encoding;
        this._encapsStack = null;
        this._encapsCache = null;
        this._traceSlicing = false;
        this._closure = null;
        this._sliceValues = true;
        this._startSeq = -1;
        this._minSeqSize = 0;
    }

    public void reset() {
        this._buf.reset();
        this.clear();
    }

    public void clear() {
        if (this._encapsStack != null) {
            assert (this._encapsStack.next == null);
            this._encapsStack.next = this._encapsCache;
            this._encapsCache = this._encapsStack;
            this._encapsCache.reset();
            this._encapsStack = null;
        }
        this._startSeq = -1;
        this._sliceValues = true;
    }

    public void setValueFactoryManager(ValueFactoryManager vfm) {
        this._valueFactoryManager = vfm;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void setCompactIdResolver(IntFunction<String> r) {
        this._compactIdResolver = r;
    }

    public void setClassResolver(Function<String, Class<?>> r) {
        this._classResolver = r;
    }

    public void setSliceValues(boolean b) {
        this._sliceValues = b;
    }

    public void setTraceSlicing(boolean b) {
        this._traceSlicing = b;
    }

    public Object getClosure() {
        return this._closure;
    }

    public Object setClosure(Object p) {
        Object prev = this._closure;
        this._closure = p;
        return prev;
    }

    public Instance instance() {
        return this._instance;
    }

    public void swap(InputStream other) {
        assert (this._instance == other._instance);
        Buffer tmpBuf = other._buf;
        other._buf = this._buf;
        this._buf = tmpBuf;
        EncodingVersion tmpEncoding = other._encoding;
        other._encoding = this._encoding;
        this._encoding = tmpEncoding;
        boolean tmpTraceSlicing = other._traceSlicing;
        other._traceSlicing = this._traceSlicing;
        this._traceSlicing = tmpTraceSlicing;
        Object tmpClosure = other._closure;
        other._closure = this._closure;
        this._closure = tmpClosure;
        boolean tmpSliceValues = other._sliceValues;
        other._sliceValues = this._sliceValues;
        this._sliceValues = tmpSliceValues;
        this.resetEncapsulation();
        other.resetEncapsulation();
        int tmpStartSeq = other._startSeq;
        other._startSeq = this._startSeq;
        this._startSeq = tmpStartSeq;
        int tmpMinSeqSize = other._minSeqSize;
        other._minSeqSize = this._minSeqSize;
        this._minSeqSize = tmpMinSeqSize;
        ValueFactoryManager tmpVfm = other._valueFactoryManager;
        other._valueFactoryManager = this._valueFactoryManager;
        this._valueFactoryManager = tmpVfm;
        Logger tmpLogger = other._logger;
        other._logger = this._logger;
        this._logger = tmpLogger;
        IntFunction<String> tmpCompactIdResolver = other._compactIdResolver;
        other._compactIdResolver = this._compactIdResolver;
        this._compactIdResolver = tmpCompactIdResolver;
        Function<String, Class<?>> tmpClassResolver = other._classResolver;
        other._classResolver = this._classResolver;
        this._classResolver = tmpClassResolver;
    }

    private void resetEncapsulation() {
        this._encapsStack = null;
    }

    public void resize(int sz) {
        this._buf.resize(sz, true);
        this._buf.position(sz);
    }

    public Buffer getBuffer() {
        return this._buf;
    }

    public void startValue() {
        assert (this._encapsStack != null && this._encapsStack.decoder != null);
        this._encapsStack.decoder.startInstance(SliceType.ValueSlice);
    }

    public SlicedData endValue(boolean preserve) {
        assert (this._encapsStack != null && this._encapsStack.decoder != null);
        return this._encapsStack.decoder.endInstance(preserve);
    }

    public void startException() {
        assert (this._encapsStack != null && this._encapsStack.decoder != null);
        this._encapsStack.decoder.startInstance(SliceType.ExceptionSlice);
    }

    public SlicedData endException(boolean preserve) {
        assert (this._encapsStack != null && this._encapsStack.decoder != null);
        return this._encapsStack.decoder.endInstance(preserve);
    }

    public EncodingVersion startEncapsulation() {
        Encaps curr = this._encapsCache;
        if (curr != null) {
            curr.reset();
            this._encapsCache = this._encapsCache.next;
        } else {
            curr = new Encaps();
        }
        curr.next = this._encapsStack;
        this._encapsStack = curr;
        this._encapsStack.start = this._buf.b.position();
        int sz = this.readInt();
        if (sz < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (sz - 4 > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._encapsStack.sz = sz;
        EncodingVersion encoding = EncodingVersion.ice_read(this);
        Protocol.checkSupportedEncoding(encoding);
        this._encapsStack.setEncoding(encoding);
        return encoding;
    }

    public void endEncapsulation() {
        assert (this._encapsStack != null);
        if (!this._encapsStack.encoding_1_0) {
            this.skipOptionals();
            if (this._buf.b.position() != this._encapsStack.start + this._encapsStack.sz) {
                throw new EncapsulationException();
            }
        } else if (this._buf.b.position() != this._encapsStack.start + this._encapsStack.sz) {
            if (this._buf.b.position() + 1 != this._encapsStack.start + this._encapsStack.sz) {
                throw new EncapsulationException();
            }
            try {
                this._buf.b.get();
            }
            catch (BufferUnderflowException ex) {
                throw new UnmarshalOutOfBoundsException();
            }
        }
        Encaps curr = this._encapsStack;
        this._encapsStack = curr.next;
        curr.next = this._encapsCache;
        this._encapsCache = curr;
        this._encapsCache.reset();
    }

    public EncodingVersion skipEmptyEncapsulation() {
        int sz = this.readInt();
        if (sz < 6) {
            throw new EncapsulationException();
        }
        if (sz - 4 > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        EncodingVersion encoding = EncodingVersion.ice_read(this);
        Protocol.checkSupportedEncoding(encoding);
        if (encoding.equals(com.zeroc.Ice.Util.Encoding_1_0)) {
            if (sz != 6) {
                throw new EncapsulationException();
            }
        } else {
            this._buf.position(this._buf.b.position() + sz - 6);
        }
        return encoding;
    }

    public byte[] readEncapsulation(EncodingVersion encoding) {
        int sz = this.readInt();
        if (sz < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (sz - 4 > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (encoding != null) {
            encoding.ice_readMembers(this);
            this._buf.position(this._buf.b.position() - 6);
        } else {
            this._buf.position(this._buf.b.position() - 4);
        }
        byte[] v = new byte[sz];
        try {
            this._buf.b.get(v);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public EncodingVersion getEncoding() {
        return this._encapsStack != null ? this._encapsStack.encoding : this._encoding;
    }

    public int getEncapsulationSize() {
        assert (this._encapsStack != null);
        return this._encapsStack.sz - 6;
    }

    public EncodingVersion skipEncapsulation() {
        int sz = this.readInt();
        if (sz < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        EncodingVersion encoding = EncodingVersion.ice_read(this);
        try {
            this._buf.position(this._buf.b.position() + sz - 6);
        }
        catch (IllegalArgumentException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
        return encoding;
    }

    public String startSlice() {
        assert (this._encapsStack != null && this._encapsStack.decoder != null);
        return this._encapsStack.decoder.startSlice();
    }

    public void endSlice() {
        assert (this._encapsStack != null && this._encapsStack.decoder != null);
        this._encapsStack.decoder.endSlice();
    }

    public void skipSlice() {
        assert (this._encapsStack != null && this._encapsStack.decoder != null);
        this._encapsStack.decoder.skipSlice();
    }

    public void readPendingValues() {
        if (this._encapsStack != null && this._encapsStack.decoder != null) {
            this._encapsStack.decoder.readPendingValues();
        } else if (this._encapsStack != null ? this._encapsStack.encoding_1_0 : this._encoding.equals(com.zeroc.Ice.Util.Encoding_1_0)) {
            this.skipSize();
        }
    }

    public int readSize() {
        try {
            int b = this._buf.b.get();
            if (b == -1) {
                int v = this._buf.b.getInt();
                if (v < 0) {
                    throw new UnmarshalOutOfBoundsException();
                }
                return v;
            }
            return b < 0 ? b + 256 : b;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public int readAndCheckSeqSize(int minSize) {
        int sz = this.readSize();
        if (sz == 0) {
            return sz;
        }
        if (this._startSeq == -1 || this._buf.b.position() > this._startSeq + this._minSeqSize) {
            this._startSeq = this._buf.b.position();
            this._minSeqSize = sz * minSize;
        } else {
            this._minSeqSize += sz * minSize;
        }
        if (this._startSeq + this._minSeqSize > this._buf.size()) {
            throw new UnmarshalOutOfBoundsException();
        }
        return sz;
    }

    public byte[] readBlob(int sz) {
        if (this._buf.b.remaining() < sz) {
            throw new UnmarshalOutOfBoundsException();
        }
        byte[] v = new byte[sz];
        try {
            this._buf.b.get(v);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public boolean readOptional(int tag, OptionalFormat expectedFormat) {
        assert (this._encapsStack != null);
        if (this._encapsStack.decoder != null) {
            return this._encapsStack.decoder.readOptional(tag, expectedFormat);
        }
        return this.readOptImpl(tag, expectedFormat);
    }

    public byte readByte() {
        try {
            return this._buf.b.get();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<Byte> readByte(int tag) {
        if (this.readOptional(tag, OptionalFormat.F1)) {
            return Optional.of(this.readByte());
        }
        return Optional.empty();
    }

    public byte[] readByteSeq() {
        try {
            int sz = this.readAndCheckSeqSize(1);
            byte[] v = new byte[sz];
            this._buf.b.get(v);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<byte[]> readByteSeq(int tag) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            return Optional.of(this.readByteSeq());
        }
        return Optional.empty();
    }

    public ByteBuffer readByteBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(1);
            ByteBuffer v = this._buf.b.slice();
            ((java.nio.Buffer)v).limit(sz);
            this._buf.position(this._buf.b.position() + sz);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public <T extends Serializable> T readSerializable(Class<T> cl) {
        int sz = this.readAndCheckSeqSize(1);
        if (sz == 0) {
            return null;
        }
        java.io.ObjectInputStream in = null;
        try {
            InputStreamWrapper w = new InputStreamWrapper(sz, this._buf.b);
            in = new ObjectInputStream(this._instance, w);
            Serializable serializable = (Serializable)cl.cast(in.readObject());
            return (T)serializable;
        }
        catch (LocalException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshalException("cannot deserialize object", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new MarshalException("cannot deserialize object", ex);
                }
            }
        }
    }

    public <T extends Serializable> Optional<T> readSerializable(int tag, Class<T> cl) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            return Optional.of(this.readSerializable(cl));
        }
        return Optional.empty();
    }

    public boolean readBool() {
        try {
            return this._buf.b.get() == 1;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<Boolean> readBool(int tag) {
        if (this.readOptional(tag, OptionalFormat.F1)) {
            return Optional.of(this.readBool());
        }
        return Optional.empty();
    }

    public boolean[] readBoolSeq() {
        try {
            int sz = this.readAndCheckSeqSize(1);
            boolean[] v = new boolean[sz];
            for (int i = 0; i < sz; ++i) {
                v[i] = this._buf.b.get() == 1;
            }
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<boolean[]> readBoolSeq(int tag) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            return Optional.of(this.readBoolSeq());
        }
        return Optional.empty();
    }

    public short readShort() {
        try {
            return this._buf.b.getShort();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<Short> readShort(int tag) {
        if (this.readOptional(tag, OptionalFormat.F2)) {
            return Optional.of(this.readShort());
        }
        return Optional.empty();
    }

    public short[] readShortSeq() {
        try {
            int sz = this.readAndCheckSeqSize(2);
            short[] v = new short[sz];
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            shortBuf.get(v);
            this._buf.position(this._buf.b.position() + sz * 2);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<short[]> readShortSeq(int tag) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            this.skipSize();
            return Optional.of(this.readShortSeq());
        }
        return Optional.empty();
    }

    public ShortBuffer readShortBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(2);
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            ShortBuffer v = shortBuf.slice();
            ((java.nio.Buffer)v).limit(sz);
            this._buf.position(this._buf.b.position() + sz * 2);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public int readInt() {
        try {
            return this._buf.b.getInt();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public OptionalInt readInt(int tag) {
        if (this.readOptional(tag, OptionalFormat.F4)) {
            return OptionalInt.of(this.readInt());
        }
        return OptionalInt.empty();
    }

    public int[] readIntSeq() {
        try {
            int sz = this.readAndCheckSeqSize(4);
            int[] v = new int[sz];
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            intBuf.get(v);
            this._buf.position(this._buf.b.position() + sz * 4);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<int[]> readIntSeq(int tag) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            this.skipSize();
            return Optional.of(this.readIntSeq());
        }
        return Optional.empty();
    }

    public IntBuffer readIntBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(4);
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            IntBuffer v = intBuf.slice();
            ((java.nio.Buffer)v).limit(sz);
            this._buf.position(this._buf.b.position() + sz * 4);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public long readLong() {
        try {
            return this._buf.b.getLong();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public OptionalLong readLong(int tag) {
        if (this.readOptional(tag, OptionalFormat.F8)) {
            return OptionalLong.of(this.readLong());
        }
        return OptionalLong.empty();
    }

    public long[] readLongSeq() {
        try {
            int sz = this.readAndCheckSeqSize(8);
            long[] v = new long[sz];
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            longBuf.get(v);
            this._buf.position(this._buf.b.position() + sz * 8);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<long[]> readLongSeq(int tag) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            this.skipSize();
            return Optional.of(this.readLongSeq());
        }
        return Optional.empty();
    }

    public LongBuffer readLongBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(8);
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            LongBuffer v = longBuf.slice();
            ((java.nio.Buffer)v).limit(sz);
            this._buf.position(this._buf.b.position() + sz * 8);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public float readFloat() {
        try {
            return this._buf.b.getFloat();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<Float> readFloat(int tag) {
        if (this.readOptional(tag, OptionalFormat.F4)) {
            return Optional.of(Float.valueOf(this.readFloat()));
        }
        return Optional.empty();
    }

    public float[] readFloatSeq() {
        try {
            int sz = this.readAndCheckSeqSize(4);
            float[] v = new float[sz];
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            floatBuf.get(v);
            this._buf.position(this._buf.b.position() + sz * 4);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<float[]> readFloatSeq(int tag) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            this.skipSize();
            return Optional.of(this.readFloatSeq());
        }
        return Optional.empty();
    }

    public FloatBuffer readFloatBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(4);
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            FloatBuffer v = floatBuf.slice();
            ((java.nio.Buffer)v).limit(sz);
            this._buf.position(this._buf.b.position() + sz * 4);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public double readDouble() {
        try {
            return this._buf.b.getDouble();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public OptionalDouble readDouble(int tag) {
        if (this.readOptional(tag, OptionalFormat.F8)) {
            return OptionalDouble.of(this.readDouble());
        }
        return OptionalDouble.empty();
    }

    public double[] readDoubleSeq() {
        try {
            int sz = this.readAndCheckSeqSize(8);
            double[] v = new double[sz];
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            doubleBuf.get(v);
            this._buf.position(this._buf.b.position() + sz * 8);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<double[]> readDoubleSeq(int tag) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            this.skipSize();
            return Optional.of(this.readDoubleSeq());
        }
        return Optional.empty();
    }

    public DoubleBuffer readDoubleBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(8);
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            DoubleBuffer v = doubleBuf.slice();
            ((java.nio.Buffer)v).limit(sz);
            this._buf.position(this._buf.b.position() + sz * 8);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public String readString() {
        int len = this.readSize();
        if (len == 0) {
            return "";
        }
        if (this._buf.b.remaining() < len) {
            throw new UnmarshalOutOfBoundsException();
        }
        try {
            if (this._stringBytes == null || len > this._stringBytes.length) {
                this._stringBytes = new byte[len];
            }
            if (this._stringChars == null || len > this._stringChars.length) {
                this._stringChars = new char[len];
            }
            this._buf.b.get(this._stringBytes, 0, len);
            for (int i = 0; i < len; ++i) {
                if (this._stringBytes[i] < 0) {
                    return new String(this._stringBytes, 0, len, "UTF8");
                }
                this._stringChars[i] = (char)this._stringBytes[i];
            }
            return new String(this._stringChars, 0, len);
        }
        catch (UnsupportedEncodingException ex) {
            assert (false);
            return "";
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Optional<String> readString(int tag) {
        if (this.readOptional(tag, OptionalFormat.VSize)) {
            return Optional.of(this.readString());
        }
        return Optional.empty();
    }

    public String[] readStringSeq() {
        int sz = this.readAndCheckSeqSize(1);
        String[] v = new String[sz];
        for (int i = 0; i < sz; ++i) {
            v[i] = this.readString();
        }
        return v;
    }

    public Optional<String[]> readStringSeq(int tag) {
        if (this.readOptional(tag, OptionalFormat.FSize)) {
            this.skip(4);
            return Optional.of(this.readStringSeq());
        }
        return Optional.empty();
    }

    public ObjectPrx readProxy() {
        if (this._instance == null) {
            throw new MarshalException("cannot unmarshal a proxy without a communicator");
        }
        return this._instance.proxyFactory().streamToProxy(this);
    }

    public <T extends ObjectPrx> T readProxy(Function<ObjectPrx, T> cast) {
        if (this._instance == null) {
            throw new MarshalException("cannot unmarshal a proxy without a communicator");
        }
        return (T)((ObjectPrx)cast.apply(this._instance.proxyFactory().streamToProxy(this)));
    }

    public Optional<ObjectPrx> readProxy(int tag) {
        if (this.readOptional(tag, OptionalFormat.FSize)) {
            this.skip(4);
            return Optional.of(this.readProxy());
        }
        return Optional.empty();
    }

    public <T extends ObjectPrx> Optional<T> readProxy(int tag, Function<ObjectPrx, T> cast) {
        if (this.readOptional(tag, OptionalFormat.FSize)) {
            this.skip(4);
            return Optional.of(this.readProxy(cast));
        }
        return Optional.empty();
    }

    public int readEnum(int maxValue) {
        if (this.getEncoding().equals(com.zeroc.Ice.Util.Encoding_1_0)) {
            if (maxValue < 127) {
                return this.readByte();
            }
            if (maxValue < Short.MAX_VALUE) {
                return this.readShort();
            }
            return this.readInt();
        }
        return this.readSize();
    }

    public <T extends Value> void readValue(Consumer<T> cb, Class<T> cls) {
        this.initEncaps();
        if (cb == null) {
            this._encapsStack.decoder.readValue(null);
        } else {
            this._encapsStack.decoder.readValue(v -> {
                if (v == null || cls.isInstance(v)) {
                    cb.accept((Value)cls.cast(v));
                } else {
                    Ex.throwUOE(cls, v);
                }
            });
        }
    }

    public void readValue(Consumer<Value> cb) {
        this.readValue(cb, Value.class);
    }

    public <T extends Value> void readValue(int tag, Consumer<Optional<T>> cb, Class<T> cls) {
        if (this.readOptional(tag, OptionalFormat.Class)) {
            if (cb != null) {
                this.readValue(v -> cb.accept(Optional.ofNullable(v)), cls);
            } else {
                this.readValue(null);
            }
        } else if (cb != null) {
            cb.accept(Optional.empty());
        }
    }

    public void readValue(int tag, Consumer<Optional<Value>> cb) {
        this.readValue(tag, cb, Value.class);
    }

    public void throwException() throws UserException {
        this.throwException(null);
    }

    public void throwException(UserExceptionFactory factory2) throws UserException {
        this.initEncaps();
        this._encapsStack.decoder.throwException(factory2);
    }

    private boolean readOptImpl(int readTag, OptionalFormat expectedFormat) {
        int tag;
        OptionalFormat format;
        if (this.isEncoding_1_0()) {
            return false;
        }
        while (true) {
            int v;
            if (this._buf.b.position() >= this._encapsStack.start + this._encapsStack.sz) {
                return false;
            }
            int b = this.readByte();
            int n = v = b < 0 ? b + 256 : b;
            if (v == 255) {
                this._buf.position(this._buf.b.position() - 1);
                return false;
            }
            format = OptionalFormat.valueOf(v & 7);
            tag = v >> 3;
            if (tag == 30) {
                tag = this.readSize();
            }
            if (tag > readTag) {
                int offset = tag < 30 ? 1 : (tag < 255 ? 2 : 6);
                this._buf.position(this._buf.b.position() - offset);
                return false;
            }
            if (tag >= readTag) break;
            this.skipOptional(format);
        }
        if (format != expectedFormat) {
            throw new MarshalException("invalid optional data member `" + tag + "': unexpected format");
        }
        return true;
    }

    private void skipOptional(OptionalFormat format) {
        switch (format) {
            case F1: {
                this.skip(1);
                break;
            }
            case F2: {
                this.skip(2);
                break;
            }
            case F4: {
                this.skip(4);
                break;
            }
            case F8: {
                this.skip(8);
                break;
            }
            case Size: {
                this.skipSize();
                break;
            }
            case VSize: {
                this.skip(this.readSize());
                break;
            }
            case FSize: {
                this.skip(this.readInt());
                break;
            }
            case Class: {
                this.readValue(null, null);
            }
        }
    }

    private void skipOptionals() {
        while (this._buf.b.position() < this._encapsStack.start + this._encapsStack.sz) {
            int v;
            int b = this.readByte();
            int n = v = b < 0 ? b + 256 : b;
            if (v == 255) {
                return;
            }
            OptionalFormat format = OptionalFormat.valueOf(v & 7);
            if (v >> 3 == 30) {
                this.skipSize();
            }
            this.skipOptional(format);
        }
        return;
    }

    public void skip(int size) {
        if (size < 0 || size > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._buf.position(this._buf.b.position() + size);
    }

    public void skipSize() {
        byte b = this.readByte();
        if (b == -1) {
            this.skip(4);
        }
    }

    public int pos() {
        return this._buf.b.position();
    }

    public void pos(int n) {
        this._buf.position(n);
    }

    public int size() {
        return this._buf.size();
    }

    public boolean isEmpty() {
        return this._buf.empty();
    }

    private UserException createUserException(String id) {
        UserException userEx = null;
        try {
            Class<?> c;
            if (this._classResolver != null && (c = this._classResolver.apply(id)) != null) {
                userEx = (UserException)c.getDeclaredConstructor(new Class[0]).newInstance(new java.lang.Object[0]);
            }
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
        return userEx;
    }

    private boolean isEncoding_1_0() {
        return this._encapsStack != null ? this._encapsStack.encoding_1_0 : this._encoding.equals(com.zeroc.Ice.Util.Encoding_1_0);
    }

    private void initEncaps() {
        if (this._encapsStack == null) {
            this._encapsStack = this._encapsCache;
            if (this._encapsStack != null) {
                this._encapsCache = this._encapsCache.next;
            } else {
                this._encapsStack = new Encaps();
            }
            this._encapsStack.setEncoding(this._encoding);
            this._encapsStack.sz = this._buf.b.limit();
        }
        if (this._encapsStack.decoder == null) {
            this._encapsStack.decoder = this._encapsStack.encoding_1_0 ? new EncapsDecoder10(this, this._sliceValues, this._valueFactoryManager, this._classResolver) : new EncapsDecoder11(this, this._sliceValues, this._valueFactoryManager, this._classResolver, this._compactIdResolver);
        }
    }

    private void traceSkipSlice(String typeId, SliceType sliceType) {
        if (this._traceSlicing && this._logger != null) {
            TraceUtil.traceSlicing(sliceType == SliceType.ExceptionSlice ? "exception" : "object", typeId, "Slicing", this._logger);
        }
    }

    private static enum SliceType {
        NoSlice,
        ValueSlice,
        ExceptionSlice;

    }

    private static final class Encaps {
        int start;
        int sz;
        EncodingVersion encoding;
        boolean encoding_1_0;
        EncapsDecoder decoder;
        Encaps next;

        private Encaps() {
        }

        void reset() {
            this.decoder = null;
        }

        void setEncoding(EncodingVersion encoding) {
            this.encoding = encoding;
            this.encoding_1_0 = encoding.equals(com.zeroc.Ice.Util.Encoding_1_0);
        }
    }

    private static abstract class EncapsDecoder {
        protected final InputStream _stream;
        protected final boolean _sliceValues;
        protected ValueFactoryManager _valueFactoryManager;
        protected Function<String, Class<?>> _classResolver;
        protected TreeMap<Integer, LinkedList<Consumer<Value>>> _patchMap;
        private TreeMap<Integer, Value> _unmarshaledMap;
        private TreeMap<Integer, String> _typeIdMap;
        private int _typeIdIndex;
        private List<Value> _valueList;
        private HashMap<String, Class<?>> _typeIdCache;

        EncapsDecoder(InputStream stream, boolean sliceValues, ValueFactoryManager f, Function<String, Class<?>> cr) {
            this._stream = stream;
            this._sliceValues = sliceValues;
            this._valueFactoryManager = f;
            this._classResolver = cr;
            this._typeIdIndex = 0;
            this._unmarshaledMap = new TreeMap();
        }

        abstract void readValue(Consumer<Value> var1);

        abstract void throwException(UserExceptionFactory var1) throws UserException;

        abstract void startInstance(SliceType var1);

        abstract SlicedData endInstance(boolean var1);

        abstract String startSlice();

        abstract void endSlice();

        abstract void skipSlice();

        boolean readOptional(int tag, OptionalFormat format) {
            return false;
        }

        void readPendingValues() {
        }

        protected String readTypeId(boolean isIndex) {
            if (this._typeIdMap == null) {
                this._typeIdMap = new TreeMap();
            }
            if (isIndex) {
                int index = this._stream.readSize();
                String typeId = this._typeIdMap.get(index);
                if (typeId == null) {
                    throw new UnmarshalOutOfBoundsException();
                }
                return typeId;
            }
            String typeId = this._stream.readString();
            this._typeIdMap.put(++this._typeIdIndex, typeId);
            return typeId;
        }

        protected Class<?> resolveClass(String typeId) {
            Class<?> cls = null;
            if (this._typeIdCache == null) {
                this._typeIdCache = new HashMap();
            } else {
                cls = this._typeIdCache.get(typeId);
            }
            if (cls == EncapsDecoder.class) {
                cls = null;
            } else if (cls == null) {
                try {
                    if (this._classResolver != null) {
                        cls = this._classResolver.apply(typeId);
                        this._typeIdCache.put(typeId, cls != null ? cls : EncapsDecoder.class);
                    }
                }
                catch (Exception ex) {
                    throw new NoValueFactoryException("no value factory", typeId, ex);
                }
            }
            return cls;
        }

        protected Value newInstance(String typeId) {
            Class<?> cls;
            ValueFactory userFactory = this._valueFactoryManager.find(typeId);
            Value v = null;
            if (userFactory != null) {
                v = userFactory.create(typeId);
            }
            if (v == null && (userFactory = this._valueFactoryManager.find("")) != null) {
                v = userFactory.create(typeId);
            }
            if (v == null && (cls = this.resolveClass(typeId)) != null) {
                try {
                    v = (Value)cls.getDeclaredConstructor(new Class[0]).newInstance(new java.lang.Object[0]);
                }
                catch (Exception ex) {
                    throw new NoValueFactoryException("no value factory", typeId, ex);
                }
            }
            return v;
        }

        protected void addPatchEntry(int index, Consumer<Value> cb) {
            LinkedList<Consumer<Value>> l;
            assert (index > 0);
            Value obj = this._unmarshaledMap.get(index);
            if (obj != null) {
                cb.accept(obj);
                return;
            }
            if (this._patchMap == null) {
                this._patchMap = new TreeMap();
            }
            if ((l = this._patchMap.get(index)) == null) {
                l = new LinkedList();
                this._patchMap.put(index, l);
            }
            l.add(cb);
        }

        protected void unmarshal(int index, Value v) {
            LinkedList<Consumer<Value>> l;
            this._unmarshaledMap.put(index, v);
            v._iceRead(this._stream);
            if (this._patchMap != null && (l = this._patchMap.get(index)) != null) {
                assert (l.size() > 0);
                for (Consumer consumer : l) {
                    consumer.accept(v);
                }
                this._patchMap.remove(index);
            }
            if ((this._patchMap == null || this._patchMap.isEmpty()) && this._valueList == null) {
                try {
                    v.ice_postUnmarshal();
                }
                catch (Exception ex) {
                    String s = "exception raised by ice_postUnmarshal:\n" + Ex.toString(ex);
                    this._stream.instance().initializationData().logger.warning(s);
                }
            } else {
                if (this._valueList == null) {
                    this._valueList = new ArrayList<Value>();
                }
                this._valueList.add(v);
                if (this._patchMap == null || this._patchMap.isEmpty()) {
                    for (Value p : this._valueList) {
                        try {
                            p.ice_postUnmarshal();
                        }
                        catch (Exception exception) {
                            String s = "exception raised by ice_postUnmarshal:\n" + Ex.toString(exception);
                            this._stream.instance().initializationData().logger.warning(s);
                        }
                    }
                    this._valueList.clear();
                }
            }
        }
    }

    private static final class EncapsDecoder10
    extends EncapsDecoder {
        private SliceType _sliceType = SliceType.NoSlice;
        private boolean _skipFirstSlice;
        private int _sliceSize;
        private String _typeId;

        EncapsDecoder10(InputStream stream, boolean sliceValues, ValueFactoryManager f, Function<String, Class<?>> cr) {
            super(stream, sliceValues, f, cr);
        }

        @Override
        void readValue(Consumer<Value> cb) {
            assert (cb != null);
            int index = this._stream.readInt();
            if (index > 0) {
                throw new MarshalException("invalid object id");
            }
            if ((index = -index) == 0) {
                cb.accept(null);
            } else {
                this.addPatchEntry(index, cb);
            }
        }

        @Override
        void throwException(UserExceptionFactory factory2) throws UserException {
            assert (this._sliceType == SliceType.NoSlice);
            boolean usesClasses = this._stream.readBool();
            this._sliceType = SliceType.ExceptionSlice;
            this._skipFirstSlice = false;
            this.startSlice();
            String mostDerivedId = this._typeId;
            while (true) {
                UserException userEx = null;
                if (factory2 != null) {
                    try {
                        factory2.createAndThrow(this._typeId);
                    }
                    catch (UserException ex) {
                        userEx = ex;
                    }
                }
                if (userEx == null) {
                    userEx = this._stream.createUserException(this._typeId);
                }
                if (userEx != null) {
                    userEx._read(this._stream);
                    if (usesClasses) {
                        this.readPendingValues();
                    }
                    throw userEx;
                }
                this.skipSlice();
                try {
                    this.startSlice();
                }
                catch (UnmarshalOutOfBoundsException ex) {
                    ex.reason = "unknown exception type `" + mostDerivedId + "'";
                    throw ex;
                }
            }
        }

        @Override
        void startInstance(SliceType sliceType) {
            assert (this._sliceType == sliceType);
            this._skipFirstSlice = true;
        }

        @Override
        SlicedData endInstance(boolean preserve) {
            if (this._sliceType == SliceType.ValueSlice) {
                this.startSlice();
                int sz = this._stream.readSize();
                if (sz != 0) {
                    throw new MarshalException("invalid Object slice");
                }
                this.endSlice();
            }
            this._sliceType = SliceType.NoSlice;
            return null;
        }

        @Override
        String startSlice() {
            if (this._skipFirstSlice) {
                this._skipFirstSlice = false;
                return this._typeId;
            }
            if (this._sliceType == SliceType.ValueSlice) {
                boolean isIndex = this._stream.readBool();
                this._typeId = this.readTypeId(isIndex);
            } else {
                this._typeId = this._stream.readString();
            }
            this._sliceSize = this._stream.readInt();
            if (this._sliceSize < 4) {
                throw new UnmarshalOutOfBoundsException();
            }
            return this._typeId;
        }

        @Override
        void endSlice() {
        }

        @Override
        void skipSlice() {
            this._stream.traceSkipSlice(this._typeId, this._sliceType);
            assert (this._sliceSize >= 4);
            this._stream.skip(this._sliceSize - 4);
        }

        @Override
        void readPendingValues() {
            int num;
            do {
                for (int k = num = this._stream.readSize(); k > 0; --k) {
                    this.readInstance();
                }
            } while (num > 0);
            if (this._patchMap != null && !this._patchMap.isEmpty()) {
                throw new MarshalException("index for class received, but no instance");
            }
        }

        private void readInstance() {
            int index = this._stream.readInt();
            if (index <= 0) {
                throw new MarshalException("invalid object id");
            }
            this._sliceType = SliceType.ValueSlice;
            this._skipFirstSlice = false;
            this.startSlice();
            String mostDerivedId = this._typeId;
            Value v = null;
            while (true) {
                if (this._typeId.equals(Value.ice_staticId())) {
                    throw new NoValueFactoryException("", mostDerivedId);
                }
                v = this.newInstance(this._typeId);
                if (v != null) break;
                if (!this._sliceValues) {
                    throw new NoValueFactoryException("no value factory found and slicing is disabled", this._typeId);
                }
                this.skipSlice();
                this.startSlice();
            }
            this.unmarshal(index, v);
        }
    }

    private static class EncapsDecoder11
    extends EncapsDecoder {
        private IntFunction<String> _compactIdResolver;
        private InstanceData _current;
        private int _valueIdIndex;
        private TreeMap<Integer, Class<?>> _compactIdCache;

        EncapsDecoder11(InputStream stream, boolean sliceValues, ValueFactoryManager f, Function<String, Class<?>> cr, IntFunction<String> r) {
            super(stream, sliceValues, f, cr);
            this._compactIdResolver = r;
            this._current = null;
            this._valueIdIndex = 1;
        }

        @Override
        void readValue(Consumer<Value> cb) {
            int index = this._stream.readSize();
            if (index < 0) {
                throw new MarshalException("invalid object id");
            }
            if (index == 0) {
                if (cb != null) {
                    cb.accept(null);
                }
            } else if (this._current != null && (this._current.sliceFlags & 8) != 0) {
                if (cb != null) {
                    if (this._current.indirectPatchList == null) {
                        this._current.indirectPatchList = new ArrayDeque<IndirectPatchEntry>();
                    }
                    IndirectPatchEntry e = new IndirectPatchEntry();
                    e.index = index - 1;
                    e.cb = cb;
                    this._current.indirectPatchList.push(e);
                }
            } else {
                this.readInstance(index, cb);
            }
        }

        @Override
        void throwException(UserExceptionFactory factory2) throws UserException {
            assert (this._current == null);
            this.push(SliceType.ExceptionSlice);
            this.startSlice();
            String mostDerivedId = this._current.typeId;
            while (true) {
                UserException userEx = null;
                if (factory2 != null) {
                    try {
                        factory2.createAndThrow(this._current.typeId);
                    }
                    catch (UserException ex) {
                        userEx = ex;
                    }
                }
                if (userEx == null) {
                    userEx = this._stream.createUserException(this._current.typeId);
                }
                if (userEx != null) {
                    userEx._read(this._stream);
                    throw userEx;
                }
                this.skipSlice();
                if ((this._current.sliceFlags & 0x20) != 0) {
                    if (mostDerivedId.startsWith("::")) {
                        throw new UnknownUserException(mostDerivedId.substring(2));
                    }
                    throw new UnknownUserException(mostDerivedId);
                }
                this.startSlice();
            }
        }

        @Override
        void startInstance(SliceType sliceType) {
            assert (this._current.sliceType == sliceType);
            this._current.skipFirstSlice = true;
        }

        @Override
        SlicedData endInstance(boolean preserve) {
            SlicedData slicedData = null;
            if (preserve) {
                slicedData = this.readSlicedData();
            }
            if (this._current.slices != null) {
                this._current.slices.clear();
                this._current.indirectionTables.clear();
            }
            this._current = this._current.previous;
            return slicedData;
        }

        @Override
        String startSlice() {
            if (this._current.skipFirstSlice) {
                this._current.skipFirstSlice = false;
                return this._current.typeId;
            }
            this._current.sliceFlags = this._stream.readByte();
            if (this._current.sliceType == SliceType.ValueSlice) {
                if ((this._current.sliceFlags & 3) == 3) {
                    this._current.typeId = "";
                    this._current.compactId = this._stream.readSize();
                } else if ((this._current.sliceFlags & 3) != 0) {
                    this._current.typeId = this.readTypeId((this._current.sliceFlags & 2) != 0);
                    this._current.compactId = -1;
                } else {
                    this._current.typeId = "";
                    this._current.compactId = -1;
                }
            } else {
                this._current.typeId = this._stream.readString();
                this._current.compactId = -1;
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                this._current.sliceSize = this._stream.readInt();
                if (this._current.sliceSize < 4) {
                    throw new UnmarshalOutOfBoundsException();
                }
            } else {
                this._current.sliceSize = 0;
            }
            return this._current.typeId;
        }

        @Override
        void endSlice() {
            if ((this._current.sliceFlags & 4) != 0) {
                this._stream.skipOptionals();
            }
            if ((this._current.sliceFlags & 8) != 0) {
                int[] indirectionTable = new int[this._stream.readAndCheckSeqSize(1)];
                for (int i = 0; i < indirectionTable.length; ++i) {
                    indirectionTable[i] = this.readInstance(this._stream.readSize(), null);
                }
                if (indirectionTable.length == 0) {
                    throw new MarshalException("empty indirection table");
                }
                if ((this._current.indirectPatchList == null || this._current.indirectPatchList.isEmpty()) && (this._current.sliceFlags & 4) == 0) {
                    throw new MarshalException("no references to indirection table");
                }
                if (this._current.indirectPatchList != null) {
                    for (IndirectPatchEntry e : this._current.indirectPatchList) {
                        assert (e.index >= 0);
                        if (e.index >= indirectionTable.length) {
                            throw new MarshalException("indirection out of range");
                        }
                        this.addPatchEntry(indirectionTable[e.index], e.cb);
                    }
                    this._current.indirectPatchList.clear();
                }
            }
        }

        @Override
        void skipSlice() {
            int end;
            this._stream.traceSkipSlice(this._current.typeId, this._current.sliceType);
            int start = this._stream.pos();
            if ((this._current.sliceFlags & 0x10) != 0) {
                assert (this._current.sliceSize >= 4);
            } else {
                if (this._current.sliceType == SliceType.ValueSlice) {
                    throw new NoValueFactoryException("no value factory found and compact format prevents slicing (the sender should use the sliced format instead)", this._current.typeId);
                }
                if (this._current.typeId.startsWith("::")) {
                    throw new UnknownUserException(this._current.typeId.substring(2));
                }
                throw new UnknownUserException(this._current.typeId);
            }
            this._stream.skip(this._current.sliceSize - 4);
            SliceInfo info = new SliceInfo();
            info.typeId = this._current.typeId;
            info.compactId = this._current.compactId;
            info.hasOptionalMembers = (this._current.sliceFlags & 4) != 0;
            info.isLastSlice = (this._current.sliceFlags & 0x20) != 0;
            Buffer buffer = this._stream.getBuffer();
            int dataEnd = end = buffer.b.position();
            if (info.hasOptionalMembers) {
                --dataEnd;
            }
            info.bytes = new byte[dataEnd - start];
            buffer.position(start);
            buffer.b.get(info.bytes);
            buffer.position(end);
            if (this._current.slices == null) {
                this._current.slices = new ArrayList<SliceInfo>();
                this._current.indirectionTables = new ArrayList<int[]>();
            }
            if ((this._current.sliceFlags & 8) != 0) {
                int[] indirectionTable = new int[this._stream.readAndCheckSeqSize(1)];
                for (int i = 0; i < indirectionTable.length; ++i) {
                    indirectionTable[i] = this.readInstance(this._stream.readSize(), null);
                }
                this._current.indirectionTables.add(indirectionTable);
            } else {
                this._current.indirectionTables.add(null);
            }
            this._current.slices.add(info);
        }

        @Override
        boolean readOptional(int readTag, OptionalFormat expectedFormat) {
            if (this._current == null) {
                return this._stream.readOptImpl(readTag, expectedFormat);
            }
            if ((this._current.sliceFlags & 4) != 0) {
                return this._stream.readOptImpl(readTag, expectedFormat);
            }
            return false;
        }

        private int readInstance(int index, Consumer<Value> cb) {
            assert (index > 0);
            if (index > 1) {
                if (cb != null) {
                    this.addPatchEntry(index, cb);
                }
                return index;
            }
            this.push(SliceType.ValueSlice);
            index = ++this._valueIdIndex;
            this.startSlice();
            String mostDerivedId = this._current.typeId;
            Value v = null;
            while (true) {
                boolean updateCache = false;
                if (this._current.compactId >= 0) {
                    updateCache = true;
                    if (this._compactIdCache == null) {
                        this._compactIdCache = new TreeMap();
                    } else {
                        Class<?> cls = this._compactIdCache.get(this._current.compactId);
                        if (cls != null) {
                            try {
                                v = (Value)cls.getDeclaredConstructor(new Class[0]).newInstance(new java.lang.Object[0]);
                                updateCache = false;
                            }
                            catch (Exception ex) {
                                throw new NoValueFactoryException("no value factory", "compact ID " + this._current.compactId, ex);
                            }
                        }
                    }
                    if (v == null) {
                        this._current.typeId = "";
                        if (this._compactIdResolver != null) {
                            try {
                                this._current.typeId = this._compactIdResolver.apply(this._current.compactId);
                            }
                            catch (LocalException ex) {
                                throw ex;
                            }
                            catch (Throwable ex) {
                                throw new MarshalException("exception in compact ID resolver for ID " + this._current.compactId, ex);
                            }
                        }
                        if (this._current.typeId.isEmpty()) {
                            this._current.typeId = this._stream.instance().resolveCompactId(this._current.compactId);
                        }
                    }
                }
                if (v == null && !this._current.typeId.isEmpty()) {
                    v = this.newInstance(this._current.typeId);
                }
                if (v != null) {
                    if (!updateCache) break;
                    assert (this._current.compactId >= 0);
                    this._compactIdCache.put(this._current.compactId, v.getClass());
                    break;
                }
                if (!this._sliceValues) {
                    throw new NoValueFactoryException("no value factory found and slicing is disabled", this._current.typeId);
                }
                this.skipSlice();
                if ((this._current.sliceFlags & 0x20) != 0) {
                    v = this.newInstance(Value.ice_staticId());
                    if (v != null) break;
                    v = new UnknownSlicedValue(mostDerivedId);
                    break;
                }
                this.startSlice();
            }
            this.unmarshal(index, v);
            if (this._current == null && this._patchMap != null && !this._patchMap.isEmpty()) {
                throw new MarshalException("index for class received, but no instance");
            }
            if (cb != null) {
                cb.accept(v);
            }
            return index;
        }

        private SlicedData readSlicedData() {
            if (this._current.slices == null) {
                return null;
            }
            assert (this._current.slices.size() == this._current.indirectionTables.size());
            for (int n = 0; n < this._current.slices.size(); ++n) {
                int[] table = this._current.indirectionTables.get(n);
                SliceInfo info = this._current.slices.get(n);
                info.instances = new Value[table != null ? table.length : 0];
                for (int j = 0; j < info.instances.length; ++j) {
                    int k = j;
                    this.addPatchEntry(table[j], v -> {
                        info.instances[k] = v;
                    });
                }
            }
            SliceInfo[] arr = new SliceInfo[this._current.slices.size()];
            this._current.slices.toArray(arr);
            return new SlicedData(arr);
        }

        private void push(SliceType sliceType) {
            this._current = this._current == null ? new InstanceData(null) : (this._current.next == null ? new InstanceData(this._current) : this._current.next);
            this._current.sliceType = sliceType;
            this._current.skipFirstSlice = false;
        }

        private static final class InstanceData {
            SliceType sliceType;
            boolean skipFirstSlice;
            List<SliceInfo> slices;
            List<int[]> indirectionTables;
            byte sliceFlags;
            int sliceSize;
            String typeId;
            int compactId;
            Deque<IndirectPatchEntry> indirectPatchList;
            final InstanceData previous;
            InstanceData next;

            InstanceData(InstanceData previous) {
                if (previous != null) {
                    previous.next = this;
                }
                this.previous = previous;
                this.next = null;
            }
        }

        private static final class IndirectPatchEntry {
            int index;
            Consumer<Value> cb;

            private IndirectPatchEntry() {
            }
        }
    }

    @FunctionalInterface
    public static interface Unmarshaler {
        public void unmarshal(InputStream var1);
    }
}

