/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.FileException;
import com.zeroc.Ice.InitializationException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.SyscallException;
import com.zeroc.Ice.Util;
import com.zeroc.IceInternal.PropertyNames;
import com.zeroc.IceUtilInternal.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertiesI
implements Properties {
    private static final int ParseStateKey = 0;
    private static final int ParseStateValue = 1;
    private HashMap<String, PropertyValue> _properties = new HashMap();

    @Override
    public synchronized String getProperty(String key) {
        PropertyValue pv = this._properties.get(key);
        if (pv != null) {
            pv.used = true;
            return pv.value;
        }
        return "";
    }

    @Override
    public synchronized String getPropertyWithDefault(String key, String value) {
        PropertyValue pv = this._properties.get(key);
        if (pv != null) {
            pv.used = true;
            return pv.value;
        }
        return value;
    }

    @Override
    public int getPropertyAsInt(String key) {
        return this.getPropertyAsIntWithDefault(key, 0);
    }

    @Override
    public synchronized int getPropertyAsIntWithDefault(String key, int value) {
        PropertyValue pv = this._properties.get(key);
        if (pv != null) {
            pv.used = true;
            try {
                return Integer.parseInt(pv.value);
            }
            catch (NumberFormatException ex) {
                Util.getProcessLogger().warning("numeric property " + key + " set to non-numeric value, defaulting to " + value);
            }
        }
        return value;
    }

    @Override
    public String[] getPropertyAsList(String key) {
        return this.getPropertyAsListWithDefault(key, null);
    }

    @Override
    public synchronized String[] getPropertyAsListWithDefault(String key, String[] value) {
        PropertyValue pv;
        if (value == null) {
            value = new String[]{};
        }
        if ((pv = this._properties.get(key)) != null) {
            pv.used = true;
            String[] result = StringUtil.splitString(pv.value, ", \t\r\n");
            if (result == null) {
                Util.getProcessLogger().warning("mismatched quotes in property " + key + "'s value, returning default value");
                return value;
            }
            if (result.length == 0) {
                result = value;
            }
            return result;
        }
        return value;
    }

    @Override
    public synchronized Map<String, String> getPropertiesForPrefix(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, PropertyValue> p : this._properties.entrySet()) {
            String key = p.getKey();
            if (prefix.length() != 0 && !key.startsWith(prefix)) continue;
            PropertyValue pv = p.getValue();
            pv.used = true;
            result.put(key, pv.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, String value) {
        if (key != null) {
            key = key.trim();
        }
        Logger logger = Util.getProcessLogger();
        if (key == null || key.length() == 0) {
            throw new InitializationException("Attempt to set property with empty key");
        }
        int dotPos = key.indexOf(46);
        if (dotPos != -1) {
            String prefix = key.substring(0, dotPos);
            int i = 0;
            while (PropertyNames.validProps[i] != null) {
                String pattern = PropertyNames.validProps[i][0].pattern();
                dotPos = pattern.indexOf(46);
                assert (dotPos != -1);
                String propPrefix = pattern.substring(0, dotPos - 1);
                boolean mismatchCase = false;
                String otherKey = "";
                if (propPrefix.toUpperCase().equals(prefix.toUpperCase())) {
                    boolean found = false;
                    int j = 0;
                    while (PropertyNames.validProps[i][j] != null && !found) {
                        pattern = PropertyNames.validProps[i][j].pattern();
                        Pattern pComp = Pattern.compile(pattern);
                        Matcher m = pComp.matcher(key);
                        found = m.matches();
                        if (found && PropertyNames.validProps[i][j].deprecated()) {
                            logger.warning("deprecated property: " + key);
                            if (PropertyNames.validProps[i][j].deprecatedBy() != null) {
                                key = PropertyNames.validProps[i][j].deprecatedBy();
                            }
                        }
                        if (!found && (m = (pComp = Pattern.compile(pattern.toUpperCase())).matcher(key.toUpperCase())).matches()) {
                            found = true;
                            mismatchCase = true;
                            otherKey = pattern.replaceAll("\\\\", "");
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        logger.warning("unknown property: " + key);
                    } else if (mismatchCase) {
                        logger.warning("unknown property: `" + key + "'; did you mean `" + otherKey + "'");
                    }
                }
                ++i;
            }
        }
        PropertiesI propertiesI = this;
        synchronized (propertiesI) {
            if (value != null && value.length() > 0) {
                PropertyValue pv = this._properties.get(key);
                if (pv != null) {
                    pv.value = value;
                } else {
                    pv = new PropertyValue(value, false);
                }
                this._properties.put(key, pv);
            } else {
                this._properties.remove(key);
            }
        }
    }

    @Override
    public synchronized String[] getCommandLineOptions() {
        String[] result = new String[this._properties.size()];
        int i = 0;
        for (Map.Entry<String, PropertyValue> p : this._properties.entrySet()) {
            result[i++] = "--" + p.getKey() + "=" + p.getValue().value;
        }
        assert (i == result.length);
        return result;
    }

    @Override
    public String[] parseCommandLineOptions(String pfx, String[] options) {
        if (pfx.length() > 0 && pfx.charAt(pfx.length() - 1) != '.') {
            pfx = pfx + '.';
        }
        pfx = "--" + pfx;
        ArrayList<String> result = new ArrayList<String>();
        for (String opt : options) {
            if (opt.startsWith(pfx)) {
                if (opt.indexOf(61) == -1) {
                    opt = opt + "=1";
                }
                this.parseLine(opt.substring(2));
                continue;
            }
            result.add(opt);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String[] parseIceCommandLineOptions(String[] options) {
        String[] args2 = options;
        int i = 0;
        while (PropertyNames.clPropNames[i] != null) {
            args2 = this.parseCommandLineOptions(PropertyNames.clPropNames[i], args2);
            ++i;
        }
        return args2;
    }

    @Override
    public void load(String file) {
        if (System.getProperty("os.name").startsWith("Windows") && (file.startsWith("HKCU\\") || file.startsWith("HKLM\\"))) {
            try {
                String[] result;
                int c;
                Process process = Runtime.getRuntime().exec(new String[]{"reg", "query", file});
                process.waitFor();
                if (process.exitValue() != 0) {
                    InitializationException ie = new InitializationException();
                    ie.reason = "Could not read Windows registry key `" + file + "'";
                    throw ie;
                }
                InputStream is = process.getInputStream();
                StringWriter sw = new StringWriter();
                while ((c = is.read()) != -1) {
                    sw.write(c);
                }
                for (String line : result = sw.toString().split("\n")) {
                    int pos = line.indexOf("REG_SZ");
                    if (pos != -1) {
                        this.setProperty(line.substring(0, pos).trim(), line.substring(pos + 6, line.length()).trim());
                        continue;
                    }
                    pos = line.indexOf("REG_EXPAND_SZ");
                    if (pos == -1) continue;
                    String name = line.substring(0, pos).trim();
                    line = line.substring(pos + 13, line.length()).trim();
                    while (true) {
                        int start = line.indexOf("%", 0);
                        int end = line.indexOf("%", start + 1);
                        if (start == -1 || end == -1) break;
                        String envKey = line.substring(start + 1, end);
                        String envValue = System.getenv(envKey);
                        if (envValue == null) {
                            envValue = "";
                        }
                        envKey = "%" + envKey + "%";
                        while ((line = line.replace(envKey, envValue)).indexOf(envKey) != -1) {
                        }
                    }
                    this.setProperty(name, line);
                }
            }
            catch (LocalException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new InitializationException("Could not read Windows registry key `" + file + "'", ex);
            }
        }
        PushbackInputStream is = null;
        try {
            InputStream f = com.zeroc.IceInternal.Util.openResource(this.getClass().getClassLoader(), file);
            if (f == null) {
                FileException fe = new FileException();
                fe.path = file;
                throw fe;
            }
            byte[] bom = new byte[3];
            is = new PushbackInputStream(f, bom.length);
            int read = is.read(bom, 0, bom.length);
            if ((read < 3 || bom[0] != -17 || bom[1] != -69 || bom[2] != -65) && read > 0) {
                is.unread(bom, 0, read);
            }
            InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            this.parse(br);
        }
        catch (IOException ex) {
            throw new FileException(0, file, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public synchronized Properties _clone() {
        return new PropertiesI(this);
    }

    public synchronized List<String> getUnusedProperties() {
        ArrayList<String> unused = new ArrayList<String>();
        for (Map.Entry<String, PropertyValue> p : this._properties.entrySet()) {
            PropertyValue pv = p.getValue();
            if (pv.used) continue;
            unused.add(p.getKey());
        }
        return unused;
    }

    PropertiesI(PropertiesI props) {
        for (Map.Entry<String, PropertyValue> p : props._properties.entrySet()) {
            this._properties.put(p.getKey(), new PropertyValue(p.getValue()));
        }
    }

    PropertiesI() {
    }

    void init(String[] args2, Properties defaults, List<String> rArgs) {
        if (defaults != null) {
            for (Map.Entry<String, PropertyValue> p : ((PropertiesI)defaults)._properties.entrySet()) {
                this._properties.put(p.getKey(), new PropertyValue(p.getValue()));
            }
        }
        boolean loadConfigFiles = false;
        for (int i = 0; i < args2.length; ++i) {
            if (!args2[i].startsWith("--Ice.Config")) continue;
            String line = args2[i];
            if (line.indexOf(61) == -1) {
                line = line + "=1";
            }
            this.parseLine(line.substring(2));
            loadConfigFiles = true;
            String[] arr = new String[args2.length - 1];
            System.arraycopy(args2, 0, arr, 0, i);
            if (i < args2.length - 1) {
                System.arraycopy(args2, i + 1, arr, i, args2.length - i - 1);
            }
            args2 = arr;
        }
        if (!loadConfigFiles) {
            boolean bl = loadConfigFiles = !this._properties.containsKey("Ice.Config");
        }
        if (loadConfigFiles) {
            this.loadConfig();
        }
        args2 = this.parseIceCommandLineOptions(args2);
        if (rArgs != null) {
            rArgs.clear();
            if (args2.length > 0) {
                rArgs.addAll(Arrays.asList(args2));
            }
        }
    }

    private void parse(BufferedReader in) {
        try {
            String line;
            while ((line = in.readLine()) != null) {
                this.parseLine(line);
            }
        }
        catch (IOException ex) {
            throw new SyscallException(ex);
        }
    }

    private void parseLine(String line) {
        String key = "";
        String value = "";
        int state = 0;
        String whitespace = "";
        String escapedspace = "";
        boolean finished = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\\': {
                            if (i < line.length() - 1) {
                                c = line.charAt(++i);
                                switch (c) {
                                    case '#': 
                                    case '=': 
                                    case '\\': {
                                        key = key + whitespace;
                                        whitespace = "";
                                        key = key + c;
                                        break block0;
                                    }
                                    case ' ': {
                                        if (key.length() == 0) break block0;
                                        whitespace = whitespace + c;
                                        break block0;
                                    }
                                }
                                key = key + whitespace;
                                whitespace = "";
                                key = key + '\\';
                                key = key + c;
                                break block0;
                            }
                            key = key + whitespace;
                            key = key + c;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (key.length() == 0) break block0;
                            whitespace = whitespace + c;
                            break block0;
                        }
                        case '=': {
                            whitespace = "";
                            state = 1;
                            break block0;
                        }
                        case '#': {
                            finished = true;
                            break block0;
                        }
                    }
                    key = key + whitespace;
                    whitespace = "";
                    key = key + c;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            if (i < line.length() - 1) {
                                c = line.charAt(++i);
                                switch (c) {
                                    case '#': 
                                    case '=': 
                                    case '\\': {
                                        value = value + (value.length() == 0 ? escapedspace : whitespace);
                                        whitespace = "";
                                        escapedspace = "";
                                        value = value + c;
                                        break block0;
                                    }
                                    case ' ': {
                                        whitespace = whitespace + c;
                                        escapedspace = escapedspace + c;
                                        break block0;
                                    }
                                }
                                value = value + (value.length() == 0 ? escapedspace : whitespace);
                                whitespace = "";
                                escapedspace = "";
                                value = value + '\\';
                                value = value + c;
                                break block0;
                            }
                            value = value + (value.length() == 0 ? escapedspace : whitespace);
                            value = value + c;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (value.length() == 0) break block0;
                            whitespace = whitespace + c;
                            break block0;
                        }
                        case '#': {
                            finished = true;
                            break block0;
                        }
                    }
                    value = value + (value.length() == 0 ? escapedspace : whitespace);
                    whitespace = "";
                    escapedspace = "";
                    value = value + c;
                }
            }
            if (finished) break;
        }
        value = value + escapedspace;
        if (state == 0 && key.length() != 0 || state == 1 && key.length() == 0) {
            Util.getProcessLogger().warning("invalid config file entry: \"" + line + "\"");
            return;
        }
        if (key.length() == 0) {
            return;
        }
        this.setProperty(key, value);
    }

    private void loadConfig() {
        String value = this.getProperty("Ice.Config");
        if (value.length() == 0 || value.equals("1")) {
            try {
                value = System.getenv("ICE_CONFIG");
                if (value == null) {
                    value = "";
                }
            }
            catch (SecurityException ex) {
                value = "";
            }
        }
        if (value.length() > 0) {
            for (String file : value.split(",")) {
                this.load(file.trim());
            }
            this._properties.put("Ice.Config", new PropertyValue(value, true));
        }
    }

    static class PropertyValue {
        public String value;
        public boolean used;

        public PropertyValue(PropertyValue v) {
            this.value = v.value;
            this.used = v.used;
        }

        public PropertyValue(String v, boolean u) {
            this.value = v;
            this.used = u;
        }
    }
}

