/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.EndpointParseException;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OutputStream;
import com.zeroc.IceInternal.EndpointFactory;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.OpaqueEndpointI;
import com.zeroc.IceInternal.Protocol;
import com.zeroc.IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class EndpointFactoryManager {
    private Instance _instance;
    private List<EndpointFactory> _factories = new ArrayList<EndpointFactory>();

    EndpointFactoryManager(Instance instance) {
        this._instance = instance;
    }

    public void initialize() {
        for (EndpointFactory f : this._factories) {
            f.initialize();
        }
    }

    public synchronized void add(EndpointFactory factory2) {
        for (EndpointFactory f : this._factories) {
            if (f.type() == factory2.type()) assert (false);
        }
        this._factories.add(factory2);
    }

    public synchronized EndpointFactory get(short type) {
        for (EndpointFactory f : this._factories) {
            if (f.type() != type) continue;
            return f;
        }
        return null;
    }

    public synchronized EndpointI create(String str, boolean oaEndpoint) {
        EndpointParseException ex;
        String[] arr = StringUtil.splitString(str, " \t\r\n");
        if (arr == null) {
            EndpointParseException e = new EndpointParseException();
            e.str = "mismatched quote";
            throw e;
        }
        if (arr.length == 0) {
            EndpointParseException e = new EndpointParseException();
            e.str = "value has no non-whitespace characters";
            throw e;
        }
        ArrayList<String> v = new ArrayList<String>(Arrays.asList(arr));
        String protocol = v.get(0);
        v.remove(0);
        if (protocol.equals("default")) {
            protocol = this._instance.defaultsAndOverrides().defaultProtocol;
        }
        EndpointFactory factory2 = null;
        for (EndpointFactory f : this._factories) {
            if (!f.protocol().equals(protocol)) continue;
            factory2 = f;
        }
        if (factory2 != null) {
            EndpointI e = factory2.create(v, oaEndpoint);
            if (!v.isEmpty()) {
                ex = new EndpointParseException();
                ex.str = "unrecognized argument `" + v.get(0) + "' in endpoint `" + str + "'";
                throw ex;
            }
            return e;
        }
        if (protocol.equals("opaque")) {
            OpaqueEndpointI ue = new OpaqueEndpointI(v);
            if (!v.isEmpty()) {
                ex = new EndpointParseException();
                ex.str = "unrecognized argument `" + v.get(0) + "' in endpoint `" + str + "'";
                throw ex;
            }
            factory2 = this.get(((EndpointI)ue).type());
            if (factory2 != null) {
                OutputStream os = new OutputStream(this._instance, Protocol.currentProtocolEncoding, false);
                os.writeShort(((EndpointI)ue).type());
                ((EndpointI)ue).streamWrite(os);
                InputStream is = new InputStream(this._instance, Protocol.currentProtocolEncoding, os.getBuffer(), true);
                is.pos(0);
                is.readShort();
                is.startEncapsulation();
                EndpointI e = factory2.read(is);
                is.endEncapsulation();
                return e;
            }
            return ue;
        }
        return null;
    }

    public synchronized EndpointI read(InputStream s) {
        short type = s.readShort();
        EndpointFactory factory2 = this.get(type);
        EndpointI e = null;
        s.startEncapsulation();
        if (factory2 != null) {
            e = factory2.read(s);
        }
        if (e == null) {
            e = new OpaqueEndpointI(type, s);
        }
        s.endEncapsulation();
        return e;
    }

    void destroy() {
        for (EndpointFactory f : this._factories) {
            f.destroy();
        }
        this._factories.clear();
    }
}

