/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.Connection;
import com.zeroc.Ice.Exception;
import com.zeroc.Ice.Instrumentation.InvocationObserver;
import com.zeroc.Ice.InvocationCanceledException;
import com.zeroc.Ice.InvocationFuture;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.IceInternal.CancellationHandler;
import com.zeroc.IceInternal.DispatchWorkItem;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.OutgoingAsyncBase;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public abstract class InvocationFutureI<T>
extends InvocationFuture<T> {
    protected final Instance _instance;
    protected InvocationObserver _observer;
    protected Connection _cachedConnection;
    protected boolean _sentSynchronously;
    protected boolean _doneInSent;
    protected boolean _synchronous;
    protected CompletableFuture<Boolean> _sentFuture;
    protected final Communicator _communicator;
    protected final String _operation;
    protected Exception _exception;
    private CancellationHandler _cancellationHandler;
    private LocalException _cancellationException;
    protected static final byte StateOK = 1;
    protected static final byte StateDone = 2;
    protected static final byte StateSent = 4;
    protected static final byte StateCachedBuffers = 8;
    protected byte _state;

    @Override
    public boolean cancel() {
        return this.cancel(false);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean r = super.cancel(mayInterruptIfRunning);
        this.cancel(new InvocationCanceledException());
        return r;
    }

    @Override
    public Communicator getCommunicator() {
        return this._communicator;
    }

    @Override
    public Connection getConnection() {
        return null;
    }

    @Override
    public ObjectPrx getProxy() {
        return null;
    }

    @Override
    public final String getOperation() {
        return this._operation;
    }

    @Override
    public final void waitForCompleted() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        try {
            this.join();
        }
        catch (java.lang.Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isSent() {
        InvocationFutureI invocationFutureI = this;
        synchronized (invocationFutureI) {
            return (this._state & 4) > 0;
        }
    }

    @Override
    public final synchronized void waitForSent() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        while ((this._state & 4) == 0 && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                throw new OperationInterruptedException();
            }
        }
    }

    @Override
    public final boolean sentSynchronously() {
        return this._sentSynchronously;
    }

    @Override
    public final synchronized CompletableFuture<Boolean> whenSent(BiConsumer<Boolean, ? super Throwable> action) {
        if (this._sentFuture == null) {
            this._sentFuture = new CompletableFuture();
        }
        CompletionStage r = this._sentFuture.whenComplete(action);
        if (!((this._state & 4) <= 0 && this._exception == null || this._sentFuture.isDone())) {
            if (this._exception != null) {
                this._sentFuture.completeExceptionally(this._exception);
            } else {
                this._sentFuture.complete(this._sentSynchronously);
            }
        }
        return r;
    }

    @Override
    public final synchronized CompletableFuture<Boolean> whenSentAsync(BiConsumer<Boolean, ? super Throwable> action) {
        return this.whenSentAsync(action, null);
    }

    @Override
    public final synchronized CompletableFuture<Boolean> whenSentAsync(BiConsumer<Boolean, ? super Throwable> action, Executor executor) {
        if (this._sentFuture == null) {
            this._sentFuture = new CompletableFuture();
        }
        CompletionStage r = executor == null ? this._sentFuture.whenCompleteAsync(action) : this._sentFuture.whenCompleteAsync(action, executor);
        if (!((this._state & 4) <= 0 && this._exception == null || this._sentFuture.isDone())) {
            if (this._exception != null) {
                this._sentFuture.completeExceptionally(this._exception);
            } else {
                this._sentFuture.complete(this._sentSynchronously);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeSent() {
        ObjectPrx proxy;
        block9: {
            try {
                InvocationFutureI invocationFutureI = this;
                synchronized (invocationFutureI) {
                    if (this._sentFuture != null && !this._sentFuture.isDone()) {
                        this._sentFuture.complete(this._sentSynchronously);
                    }
                }
                if (this._doneInSent) {
                    this.markCompleted();
                }
            }
            catch (RuntimeException ex) {
                this.warning(ex);
            }
            catch (Error exc) {
                this.error(exc);
                if (exc instanceof AssertionError || exc instanceof OutOfMemoryError) break block9;
                throw exc;
            }
        }
        if (!(this._observer == null || (proxy = this.getProxy()) != null && proxy.ice_isTwoway())) {
            this._observer.detach();
            this._observer = null;
        }
    }

    protected abstract void markCompleted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeCompleted() {
        block10: {
            try {
                if (this._exception != null) {
                    InvocationFutureI invocationFutureI = this;
                    synchronized (invocationFutureI) {
                        if (this._sentFuture != null && !this._sentFuture.isDone()) {
                            this._sentFuture.completeExceptionally(this._exception);
                        }
                    }
                    this.completeExceptionally(this._exception);
                    break block10;
                }
                this.markCompleted();
            }
            catch (RuntimeException ex) {
                this.warning(ex);
            }
            catch (AssertionError exc) {
                this.error((Error)((Object)exc));
            }
            catch (OutOfMemoryError exc) {
                this.error(exc);
            }
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
    }

    public final void invokeCompletedAsync() {
        this._instance.clientThreadPool().dispatch(new DispatchWorkItem(this._cachedConnection){

            @Override
            public void run() {
                InvocationFutureI.this.invokeCompleted();
            }
        });
    }

    public synchronized void cancelable(CancellationHandler handler) {
        if (this._cancellationException != null) {
            try {
                throw this._cancellationException;
            }
            catch (Throwable throwable) {
                this._cancellationException = null;
                throw throwable;
            }
        }
        this._cancellationHandler = handler;
    }

    protected InvocationFutureI(Communicator communicator, Instance instance, String op) {
        this._communicator = communicator;
        this._instance = instance;
        this._operation = op;
        this._state = 0;
        this._sentSynchronously = false;
        this._doneInSent = false;
        this._synchronous = false;
        this._exception = null;
    }

    protected void cacheMessageBuffers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sent(boolean done) {
        InvocationFutureI invocationFutureI = this;
        synchronized (invocationFutureI) {
            boolean invoke2;
            assert (this._exception == null);
            boolean alreadySent = (this._state & 4) != 0;
            this._state = (byte)(this._state | 4);
            if (done) {
                this._state = (byte)(this._state | 3);
                this._cancellationHandler = null;
                this._doneInSent = true;
                this.cacheMessageBuffers();
            }
            boolean bl = invoke2 = (!alreadySent && this._sentFuture != null || done) && !this._synchronous;
            if (!invoke2 && done && this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            if (!invoke2 && done) {
                this.markCompleted();
                return false;
            }
            this.notifyAll();
            return invoke2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finished(boolean ok, boolean invoke2) {
        InvocationFutureI invocationFutureI = this;
        synchronized (invocationFutureI) {
            this._state = (byte)(this._state | 2);
            if (ok) {
                this._state = (byte)(this._state | 1);
            }
            this._cancellationHandler = null;
            if (!(invoke2 &= !this._synchronous) && this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            if (!invoke2) {
                if (this._exception != null) {
                    this.completeExceptionally(this._exception);
                } else {
                    this.markCompleted();
                }
                return false;
            }
            this.notifyAll();
            return invoke2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finished(Exception ex) {
        InvocationFutureI invocationFutureI = this;
        synchronized (invocationFutureI) {
            boolean invoke2;
            this._state = (byte)(this._state | 2);
            this._exception = ex;
            this._cancellationHandler = null;
            if (this._observer != null) {
                this._observer.failed(ex.ice_id());
            }
            boolean bl = invoke2 = !this._synchronous;
            if (!invoke2 && this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            if (!invoke2) {
                if (this._exception != null) {
                    this.completeExceptionally(this._exception);
                } else {
                    this.markCompleted();
                }
                return false;
            }
            this.notifyAll();
            return invoke2;
        }
    }

    public final void invokeSentAsync() {
        this.dispatch(() -> this.invokeSent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(LocalException ex) {
        CancellationHandler handler;
        InvocationFutureI invocationFutureI = this;
        synchronized (invocationFutureI) {
            if (this._cancellationHandler == null) {
                this._cancellationException = ex;
                return;
            }
            handler = this._cancellationHandler;
        }
        handler.asyncRequestCanceled((OutgoingAsyncBase)((Object)this), ex);
    }

    protected InvocationObserver getObserver() {
        return this._observer;
    }

    protected void dispatch(final Runnable runnable2) {
        try {
            this._instance.clientThreadPool().dispatch(new DispatchWorkItem(this._cachedConnection){

                @Override
                public void run() {
                    runnable2.run();
                }
            });
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
            // empty catch block
        }
    }

    private void warning(RuntimeException ex) {
        if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.AMICallback", 1) > 0) {
            String s = "exception raised by AMI callback:\n" + Ex.toString(ex);
            this._instance.initializationData().logger.warning(s);
        }
    }

    private void error(Error error) {
        String s = "error raised by AMI callback:\n" + Ex.toString(error);
        this._instance.initializationData().logger.error(s);
    }
}

