/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.CompressBatch;
import com.zeroc.Ice.ConnectionClose;
import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.Instrumentation.CommunicatorObserver;
import com.zeroc.Ice.Instrumentation.Observer;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.IceInternal.CommunicatorFlushBatch;
import com.zeroc.IceInternal.Connector;
import com.zeroc.IceInternal.DefaultsAndOverrides;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.EndpointI_connectors;
import com.zeroc.IceInternal.FactoryACMMonitor;
import com.zeroc.IceInternal.Holder;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.RouterInfo;
import com.zeroc.IceInternal.TraceLevels;
import com.zeroc.IceInternal.Transceiver;
import com.zeroc.IceUtilInternal.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class OutgoingConnectionFactory {
    private Communicator _communicator;
    private final Instance _instance;
    private final FactoryACMMonitor _monitor;
    private boolean _destroyed;
    private MultiHashMap<Connector, ConnectionI> _connections = new MultiHashMap();
    private MultiHashMap<EndpointI, ConnectionI> _connectionsByEndpoint = new MultiHashMap();
    private Map<Connector, HashSet<ConnectCallback>> _pending = new HashMap<Connector, HashSet<ConnectCallback>>();
    private int _pendingConnectCount = 0;

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        for (List connectionList : this._connections.values()) {
            for (ConnectionI connection : connectionList) {
                connection.destroy(1);
            }
        }
        this._destroyed = true;
        this._communicator = null;
        this.notifyAll();
    }

    public synchronized void updateConnectionObservers() {
        for (List connectionList : this._connections.values()) {
            for (ConnectionI connection : connectionList) {
                connection.updateObserver();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        HashMap<Connector, ConnectionI> connections = null;
        Object object = this;
        synchronized (object) {
            while (!this._destroyed || !this._pending.isEmpty() || this._pendingConnectCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException();
                }
            }
            connections = new HashMap<Connector, ConnectionI>(this._connections);
        }
        for (List connectionList : connections.values()) {
            for (ConnectionI connection : connectionList) {
                try {
                    connection.waitUntilFinished();
                }
                catch (InterruptedException e) {
                    for (List l : connections.values()) {
                        for (ConnectionI c : l) {
                            c.close(ConnectionClose.Forcefully);
                        }
                    }
                    throw new OperationInterruptedException();
                }
            }
        }
        object = this;
        synchronized (object) {
            List<ConnectionI> cons = this._monitor.swapReapedConnections();
            if (cons != null) {
                int size = 0;
                for (List connectionList : this._connections.values()) {
                    size += connectionList.size();
                }
                assert (cons.size() == size);
                this._connections.clear();
                this._connectionsByEndpoint.clear();
            } else {
                assert (this._connections.isEmpty());
                assert (this._connectionsByEndpoint.isEmpty());
            }
        }
        this._monitor.destroy();
    }

    public void create(EndpointI[] endpts, boolean hasMore, EndpointSelectionType selType, CreateConnectionCallback callback) {
        assert (endpts.length > 0);
        List<EndpointI> endpoints = this.applyOverrides(endpts);
        try {
            Holder<Boolean> compress = new Holder<Boolean>();
            ConnectionI connection = this.findConnectionByEndpoint(endpoints, compress);
            if (connection != null) {
                callback.setConnection(connection, (Boolean)compress.value);
                return;
            }
        }
        catch (LocalException ex) {
            callback.setException(ex);
            return;
        }
        final ConnectCallback cb = new ConnectCallback(this, endpoints, hasMore, callback, selType);
        if (this._instance.queueRequests()) {
            this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    cb.getConnectors();
                    return null;
                }
            });
        } else {
            cb.getConnectors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRouterInfo(RouterInfo routerInfo) {
        assert (routerInfo != null);
        ObjectAdapter adapter = routerInfo.getAdapter();
        EndpointI[] endpoints = routerInfo.getClientEndpoints();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
            for (EndpointI endpoint : endpoints) {
                if (defaultsAndOverrides.overrideTimeout) {
                    endpoint = endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
                }
                endpoint = endpoint.compress(false);
                for (List connectionList : this._connections.values()) {
                    for (ConnectionI connection : connectionList) {
                        if (connection.endpoint() != endpoint) continue;
                        connection.setAdapter(adapter);
                    }
                }
            }
        }
    }

    public synchronized void removeAdapter(ObjectAdapter adapter) {
        if (this._destroyed) {
            return;
        }
        for (List connectionList : this._connections.values()) {
            for (ConnectionI connection : connectionList) {
                if (connection.getAdapter() != adapter) continue;
                connection.setAdapter(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAsyncBatchRequests(CompressBatch compressBatch, CommunicatorFlushBatch outAsync) {
        LinkedList<ConnectionI> c = new LinkedList<ConnectionI>();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            if (!this._destroyed) {
                for (List connectionList : this._connections.values()) {
                    for (ConnectionI connection : connectionList) {
                        if (!connection.isActiveOrHolding()) continue;
                        c.add(connection);
                    }
                }
            }
        }
        for (ConnectionI conn : c) {
            try {
                outAsync.flushConnection(conn, compressBatch);
            }
            catch (LocalException localException) {}
        }
    }

    OutgoingConnectionFactory(Communicator communicator, Instance instance) {
        this._communicator = communicator;
        this._instance = instance;
        this._monitor = new FactoryACMMonitor(instance, instance.clientACM());
        this._destroyed = false;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._destroyed);
            Assert.FinalizerAssert(this._connections.isEmpty());
            Assert.FinalizerAssert(this._connectionsByEndpoint.isEmpty());
            Assert.FinalizerAssert(this._pendingConnectCount == 0);
            Assert.FinalizerAssert(this._pending.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private List<EndpointI> applyOverrides(EndpointI[] endpts) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        for (EndpointI endpoint : endpts) {
            if (defaultsAndOverrides.overrideTimeout) {
                endpoints.add(endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue));
                continue;
            }
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    private synchronized ConnectionI findConnectionByEndpoint(List<EndpointI> endpoints, Holder<Boolean> compress) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        assert (!endpoints.isEmpty());
        for (EndpointI endpoint : endpoints) {
            List connectionList = (List)this._connectionsByEndpoint.get(endpoint);
            if (connectionList == null) continue;
            for (ConnectionI connection : connectionList) {
                if (!connection.isActiveOrHolding()) continue;
                compress.value = defaultsAndOverrides.overrideCompress ? Boolean.valueOf(defaultsAndOverrides.overrideCompressValue) : Boolean.valueOf(endpoint.compress());
                return connection;
            }
        }
        return null;
    }

    private ConnectionI findConnection(List<ConnectorInfo> connectors, Holder<Boolean> compress) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        for (ConnectorInfo ci : connectors) {
            List connectionList;
            if (this._pending.containsKey(ci.connector) || (connectionList = (List)this._connections.get(ci.connector)) == null) continue;
            for (ConnectionI connection : connectionList) {
                if (!connection.isActiveOrHolding()) continue;
                compress.value = defaultsAndOverrides.overrideCompress ? Boolean.valueOf(defaultsAndOverrides.overrideCompressValue) : Boolean.valueOf(ci.endpoint.compress());
                return connection;
            }
        }
        return null;
    }

    private synchronized void incPendingConnectCount() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        ++this._pendingConnectCount;
    }

    private synchronized void decPendingConnectCount() {
        --this._pendingConnectCount;
        assert (this._pendingConnectCount >= 0);
        if (this._destroyed && this._pendingConnectCount == 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionI getConnection(List<ConnectorInfo> connectors, ConnectCallback cb, Holder<Boolean> compress) {
        assert (cb != null);
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            List<ConnectionI> cons = this._monitor.swapReapedConnections();
            if (cons != null) {
                for (ConnectionI c : cons) {
                    this._connections.removeElementWithValue(c.connector(), c);
                    this._connectionsByEndpoint.removeElementWithValue(c.endpoint(), c);
                    this._connectionsByEndpoint.removeElementWithValue(c.endpoint().compress(true), c);
                }
            }
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            ConnectionI connection = this.findConnection(connectors, compress);
            if (connection != null) {
                return connection;
            }
            if (this.addToPending(cb, connectors)) {
                return null;
            }
        }
        if (cb != null) {
            cb.nextConnector();
        }
        return null;
    }

    private synchronized ConnectionI createConnection(Transceiver transceiver, ConnectorInfo ci) {
        assert (this._pending.containsKey(ci.connector) && transceiver != null);
        ConnectionI connection = null;
        try {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            connection = new ConnectionI(this._communicator, this._instance, this._monitor, transceiver, ci.connector, ci.endpoint.compress(false), null);
        }
        catch (LocalException ex) {
            try {
                transceiver.close();
            }
            catch (LocalException localException) {
                // empty catch block
            }
            throw ex;
        }
        this._connections.putOne(ci.connector, connection);
        this._connectionsByEndpoint.putOne(connection.endpoint(), connection);
        this._connectionsByEndpoint.putOne(connection.endpoint().compress(true), connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishGetConnection(List<ConnectorInfo> connectors, ConnectorInfo ci, ConnectionI connection, ConnectCallback cb) {
        HashSet<ConnectCallback> connectionCallbacks = new HashSet<ConnectCallback>();
        if (cb != null) {
            connectionCallbacks.add(cb);
        }
        HashSet<ConnectCallback> callbacks = new HashSet<ConnectCallback>();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            for (ConnectorInfo c : connectors) {
                Set cbs = this._pending.remove(c.connector);
                if (cbs == null) continue;
                for (ConnectCallback cc : cbs) {
                    if (cc.hasConnector(ci)) {
                        connectionCallbacks.add(cc);
                        continue;
                    }
                    callbacks.add(cc);
                }
            }
            for (ConnectCallback cc : connectionCallbacks) {
                cc.removeFromPending();
                callbacks.remove(cc);
            }
            for (ConnectCallback cc : callbacks) {
                cc.removeFromPending();
            }
            this.notifyAll();
        }
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        boolean compress = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : ci.endpoint.compress();
        for (ConnectCallback cc : callbacks) {
            cc.getConnection();
        }
        for (ConnectCallback cc : connectionCallbacks) {
            cc.setConnection(connection, compress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishGetConnection(List<ConnectorInfo> connectors, LocalException ex, ConnectCallback cb) {
        HashSet<ConnectCallback> failedCallbacks = new HashSet<ConnectCallback>();
        if (cb != null) {
            failedCallbacks.add(cb);
        }
        HashSet<ConnectCallback> callbacks = new HashSet<ConnectCallback>();
        Iterator iterator2 = this;
        synchronized (iterator2) {
            for (ConnectorInfo c : connectors) {
                Set cbs = this._pending.remove(c.connector);
                if (cbs == null) continue;
                for (ConnectCallback cc : cbs) {
                    if (cc.removeConnectors(connectors)) {
                        failedCallbacks.add(cc);
                        continue;
                    }
                    callbacks.add(cc);
                }
            }
            for (ConnectCallback cc : callbacks) {
                assert (!failedCallbacks.contains(cc));
                cc.removeFromPending();
            }
            this.notifyAll();
        }
        for (ConnectCallback cc : callbacks) {
            cc.getConnection();
        }
        for (ConnectCallback cc : failedCallbacks) {
            cc.setException(ex);
        }
    }

    private boolean addToPending(ConnectCallback cb, List<ConnectorInfo> connectors) {
        boolean found = false;
        for (ConnectorInfo p : connectors) {
            Set cbs = this._pending.get(p.connector);
            if (cbs == null) continue;
            found = true;
            if (cb == null) continue;
            cbs.add(cb);
        }
        if (found) {
            return true;
        }
        for (ConnectorInfo p : connectors) {
            if (this._pending.containsKey(p.connector)) continue;
            this._pending.put(p.connector, new HashSet());
        }
        return false;
    }

    private void removeFromPending(ConnectCallback cb, List<ConnectorInfo> connectors) {
        for (ConnectorInfo p : connectors) {
            Set cbs = this._pending.get(p.connector);
            if (cbs == null) continue;
            cbs.remove(cb);
        }
    }

    private void handleConnectionException(LocalException ex, boolean hasMore) {
        TraceLevels traceLevels = this._instance.traceLevels();
        if (traceLevels.network >= 2) {
            StringBuilder s = new StringBuilder(128);
            s.append("connection to endpoint failed");
            if (ex instanceof CommunicatorDestroyedException) {
                s.append("\n");
            } else if (hasMore) {
                s.append(", trying next endpoint\n");
            } else {
                s.append(" and no more endpoints to try\n");
            }
            s.append(ex.toString());
            this._instance.initializationData().logger.trace(traceLevels.networkCat, s.toString());
        }
    }

    private void handleException(LocalException ex, boolean hasMore) {
        TraceLevels traceLevels = this._instance.traceLevels();
        if (traceLevels.network >= 2) {
            StringBuilder s = new StringBuilder(128);
            s.append("couldn't resolve endpoint host");
            if (ex instanceof CommunicatorDestroyedException) {
                s.append("\n");
            } else if (hasMore) {
                s.append(", trying next endpoint\n");
            } else {
                s.append(" and no more endpoints to try\n");
            }
            s.append(ex.toString());
            this._instance.initializationData().logger.trace(traceLevels.networkCat, s.toString());
        }
    }

    private static class ConnectCallback
    implements ConnectionI.StartCallback,
    EndpointI_connectors {
        private final OutgoingConnectionFactory _factory;
        private final boolean _hasMore;
        private final CreateConnectionCallback _callback;
        private final List<EndpointI> _endpoints;
        private final EndpointSelectionType _selType;
        private Iterator<EndpointI> _endpointsIter;
        private EndpointI _currentEndpoint;
        private List<ConnectorInfo> _connectors = new ArrayList<ConnectorInfo>();
        private Iterator<ConnectorInfo> _iter;
        private ConnectorInfo _current;
        private Observer _observer;

        ConnectCallback(OutgoingConnectionFactory f, List<EndpointI> endpoints, boolean more, CreateConnectionCallback cb, EndpointSelectionType selType) {
            this._factory = f;
            this._endpoints = endpoints;
            this._hasMore = more;
            this._callback = cb;
            this._selType = selType;
            this._endpointsIter = this._endpoints.iterator();
        }

        @Override
        public void connectionStartCompleted(ConnectionI connection) {
            if (this._observer != null) {
                this._observer.detach();
            }
            connection.activate();
            this._factory.finishGetConnection(this._connectors, this._current, connection, this);
        }

        @Override
        public void connectionStartFailed(ConnectionI connection, LocalException ex) {
            assert (this._current != null);
            if (this.connectionStartFailedImpl(ex)) {
                this.nextConnector();
            }
        }

        @Override
        public void connectors(List<Connector> cons) {
            for (Connector p : cons) {
                this._connectors.add(new ConnectorInfo(p, this._currentEndpoint));
            }
            if (this._endpointsIter.hasNext()) {
                this.nextEndpoint();
            } else {
                assert (!this._connectors.isEmpty());
                this._iter = this._connectors.iterator();
                this.getConnection();
            }
        }

        @Override
        public void exception(LocalException ex) {
            this._factory.handleException(ex, this._hasMore || this._endpointsIter.hasNext());
            if (this._endpointsIter.hasNext()) {
                this.nextEndpoint();
            } else if (!this._connectors.isEmpty()) {
                this._iter = this._connectors.iterator();
                this.getConnection();
            } else {
                this._callback.setException(ex);
                this._factory.decPendingConnectCount();
            }
        }

        void setConnection(ConnectionI connection, boolean compress) {
            this._callback.setConnection(connection, compress);
            this._factory.decPendingConnectCount();
        }

        void setException(LocalException ex) {
            this._callback.setException(ex);
            this._factory.decPendingConnectCount();
        }

        boolean hasConnector(ConnectorInfo ci) {
            return this._connectors.contains(ci);
        }

        boolean removeConnectors(List<ConnectorInfo> connectors) {
            this._connectors.removeAll(connectors);
            this._iter = this._connectors.iterator();
            return this._connectors.isEmpty();
        }

        void removeFromPending() {
            this._factory.removeFromPending(this, this._connectors);
        }

        private void getConnectors() {
            try {
                this._factory.incPendingConnectCount();
            }
            catch (LocalException ex) {
                this._callback.setException(ex);
                return;
            }
            this.nextEndpoint();
        }

        private void nextEndpoint() {
            try {
                assert (this._endpointsIter.hasNext());
                this._currentEndpoint = this._endpointsIter.next();
                this._currentEndpoint.connectors_async(this._selType, this);
            }
            catch (LocalException ex) {
                this.exception(ex);
            }
        }

        private void getConnection() {
            try {
                Holder compress = new Holder();
                ConnectionI connection = this._factory.getConnection(this._connectors, this, compress);
                if (connection == null) {
                    return;
                }
                this._callback.setConnection(connection, (Boolean)compress.value);
                this._factory.decPendingConnectCount();
            }
            catch (LocalException ex) {
                this._callback.setException(ex);
                this._factory.decPendingConnectCount();
            }
        }

        private void nextConnector() {
            while (true) {
                StringBuffer s;
                try {
                    assert (this._iter.hasNext());
                    this._current = this._iter.next();
                    CommunicatorObserver obsv = ((OutgoingConnectionFactory)this._factory)._instance.initializationData().observer;
                    if (obsv != null) {
                        this._observer = obsv.getConnectionEstablishmentObserver(this._current.endpoint, this._current.connector.toString());
                        if (this._observer != null) {
                            this._observer.attach();
                        }
                    }
                    if (((OutgoingConnectionFactory)this._factory)._instance.traceLevels().network >= 2) {
                        s = new StringBuffer("trying to establish ");
                        s.append(this._current.endpoint.protocol());
                        s.append(" connection to ");
                        s.append(this._current.connector.toString());
                        ((OutgoingConnectionFactory)this._factory)._instance.initializationData().logger.trace(((OutgoingConnectionFactory)this._factory)._instance.traceLevels().networkCat, s.toString());
                    }
                    ConnectionI connection = this._factory.createConnection(this._current.connector.connect(), this._current);
                    connection.start(this);
                }
                catch (LocalException ex) {
                    if (((OutgoingConnectionFactory)this._factory)._instance.traceLevels().network < 2) continue;
                    s = new StringBuffer("failed to establish ");
                    s.append(this._current.endpoint.protocol());
                    s.append(" connection to ");
                    s.append(this._current.connector.toString());
                    s.append("\n");
                    s.append(ex);
                    ((OutgoingConnectionFactory)this._factory)._instance.initializationData().logger.trace(((OutgoingConnectionFactory)this._factory)._instance.traceLevels().networkCat, s.toString());
                    if (this.connectionStartFailedImpl(ex)) continue;
                }
                break;
            }
        }

        private boolean connectionStartFailedImpl(LocalException ex) {
            if (this._observer != null) {
                this._observer.failed(ex.ice_id());
                this._observer.detach();
            }
            this._factory.handleConnectionException(ex, this._hasMore || this._iter.hasNext());
            if (ex instanceof CommunicatorDestroyedException) {
                this._factory.finishGetConnection(this._connectors, ex, this);
            } else {
                if (this._iter.hasNext()) {
                    return true;
                }
                this._factory.finishGetConnection(this._connectors, ex, this);
            }
            return false;
        }
    }

    private static class ConnectorInfo {
        public Connector connector;
        public EndpointI endpoint;

        public ConnectorInfo(Connector c, EndpointI e) {
            this.connector = c;
            this.endpoint = e;
        }

        public boolean equals(Object obj) {
            ConnectorInfo r = (ConnectorInfo)obj;
            return this.connector.equals(r.connector);
        }

        public int hashCode() {
            return this.connector.hashCode();
        }
    }

    private static class MultiHashMap<K, V>
    extends HashMap<K, List<V>> {
        public static final long serialVersionUID = 0L;

        private MultiHashMap() {
        }

        public void putOne(K key, V value) {
            LinkedList<V> list = (LinkedList<V>)this.get(key);
            if (list == null) {
                list = new LinkedList<V>();
                this.put(key, list);
            }
            list.add(value);
        }

        public boolean removeElementWithValue(K key, V value) {
            List list = (List)this.get(key);
            assert (list != null);
            boolean v = list.remove(value);
            if (list.isEmpty()) {
                this.remove(key);
            }
            return v;
        }
    }

    static interface CreateConnectionCallback {
        public void setConnection(ConnectionI var1, boolean var2);

        public void setException(LocalException var1);
    }
}

