/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.IceInternal.Connector;
import com.zeroc.IceInternal.HashUtil;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.NetworkProxy;
import com.zeroc.IceInternal.ProtocolInstance;
import com.zeroc.IceInternal.StreamSocket;
import com.zeroc.IceInternal.TcpTransceiver;
import com.zeroc.IceInternal.Transceiver;
import java.net.InetSocketAddress;

final class TcpConnector
implements Connector {
    private ProtocolInstance _instance;
    private InetSocketAddress _addr;
    private NetworkProxy _proxy;
    private InetSocketAddress _sourceAddr;
    private int _timeout;
    private String _connectionId = "";
    private int _hashCode;

    @Override
    public Transceiver connect() {
        return new TcpTransceiver(this._instance, new StreamSocket(this._instance, this._proxy, this._addr, this._sourceAddr));
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String toString() {
        return Network.addrToString(this._proxy == null ? this._addr : this._proxy.getAddress());
    }

    public int hashCode() {
        return this._hashCode;
    }

    TcpConnector(ProtocolInstance instance, InetSocketAddress addr, NetworkProxy proxy, InetSocketAddress sourceAddr, int timeout2, String connectionId) {
        this._instance = instance;
        this._addr = addr;
        this._proxy = proxy;
        this._sourceAddr = sourceAddr;
        this._timeout = timeout2;
        this._connectionId = connectionId;
        this._hashCode = 5381;
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getAddress().getHostAddress());
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getPort());
        if (this._sourceAddr != null) {
            this._hashCode = HashUtil.hashAdd(this._hashCode, this._sourceAddr.getAddress().getHostAddress());
        }
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._timeout);
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._connectionId);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TcpConnector)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TcpConnector p = (TcpConnector)obj;
        if (this._timeout != p._timeout) {
            return false;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return false;
        }
        if (Network.compareAddress(this._sourceAddr, p._sourceAddr) != 0) {
            return false;
        }
        return Network.compareAddress(this._addr, p._addr) == 0;
    }
}

