/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.apifan.common.random.entity.Area;
import com.apifan.common.random.entity.CountryOrRegionCode;
import com.apifan.common.random.source.NumberSource;
import com.apifan.common.random.util.ResourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaSource {
    private static final Logger logger = LoggerFactory.getLogger(AreaSource.class);
    private static final Pattern ALPHA_1 = Pattern.compile("[a-zA-Z]");
    private List<Area> areaList = new ArrayList<Area>();
    private List<String> directionList = Lists.newArrayList((Object[])new String[]{"\u4e1c", "\u897f", "\u5357", "\u5317", "\u4e2d"});
    private List<String> communityNameList = new ArrayList<String>();
    private List<String> communitySuffixList = new ArrayList<String>();
    private List<String> addressWordList = new ArrayList<String>();
    private List<String> townSuffixList = Lists.newArrayList((Object[])new String[]{"\u4e61", "\u9547"});
    private Map<String, List<String>> phoneCodeMap = new HashMap<String, List<String>>();
    private List<CountryOrRegionCode> countryOrRegionCodeList = new ArrayList<CountryOrRegionCode>();
    private static final AreaSource instance = new AreaSource();

    private AreaSource() {
        try {
            List<String> areaLines = ResourceUtils.readLines("area.csv");
            if (CollectionUtils.isNotEmpty(areaLines)) {
                areaLines.forEach(i -> {
                    if (StringUtils.isEmpty((CharSequence)i)) {
                        return;
                    }
                    List row = Splitter.on((String)",").splitToList((CharSequence)i);
                    Area area = new Area();
                    area.setProvince((String)row.get(0));
                    area.setCity((String)row.get(1));
                    area.setCounty((String)row.get(2));
                    area.setZipCode((String)row.get(3));
                    this.areaList.add(area);
                });
            }
            this.communityNameList = ResourceUtils.readLines("community-name.txt");
            this.communitySuffixList = ResourceUtils.readLines("community-suffix.txt");
            this.addressWordList = ResourceUtils.readLines("address-word-cn.txt");
            List<Map<String, Object>> phoneCodeMapList = ResourceUtils.readAsMapList("phone-code.json");
            if (CollectionUtils.isNotEmpty(phoneCodeMapList)) {
                phoneCodeMapList.forEach(p -> {
                    String areaName = Objects.toString(p.get("area"));
                    List codeList = (List)p.get("code");
                    this.phoneCodeMap.put(areaName, codeList);
                });
            }
            List<String> countryOrRegionCodes = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("iso-3166-1.txt"));
            countryOrRegionCodes.forEach(c -> {
                if (StringUtils.isBlank((CharSequence)c)) {
                    return;
                }
                String[] tmp = c.split(",");
                if (tmp.length != 5) {
                    return;
                }
                CountryOrRegionCode regionCode = new CountryOrRegionCode();
                regionCode.setNameEN(tmp[0]);
                regionCode.setAlpha2(tmp[1]);
                regionCode.setAlpha3(tmp[2]);
                regionCode.setNumber(tmp[3]);
                regionCode.setNameCN(tmp[4]);
                this.countryOrRegionCodeList.add(regionCode);
            });
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public static AreaSource getInstance() {
        return instance;
    }

    public Area nextArea() {
        return ResourceUtils.getRandomElement(this.areaList);
    }

    public String randomProvince() {
        return this.nextArea().getProvince();
    }

    public String randomCity(String separator) {
        Area area = this.nextArea();
        return area.getProvince() + Objects.toString(separator, "") + area.getCity();
    }

    public String randomZipCode() {
        return this.nextArea().getZipCode();
    }

    public String randomAddress() {
        Area area = this.nextArea();
        String prefix = area.getProvince() + area.getCity() + Objects.toString(area.getCounty(), "");
        if (prefix.endsWith("\u53bf") || prefix.endsWith("\u65d7")) {
            String town = ResourceUtils.getRandomString(this.addressWordList, 2) + ResourceUtils.getRandomElement(this.townSuffixList);
            String village = ResourceUtils.getRandomString(this.addressWordList, 2) + "\u6751";
            String group = ResourceUtils.getRandomString(this.addressWordList, 2) + "\u7ec4";
            return prefix + town + village + group + RandomUtils.nextInt((int)1, (int)100) + "\u53f7";
        }
        String road = ResourceUtils.getRandomString(this.addressWordList, 2) + ResourceUtils.getRandomElement(this.directionList);
        String community = ResourceUtils.getRandomElement(this.communityNameList) + ResourceUtils.getRandomElement(this.communitySuffixList);
        String extra = "";
        int x = NumberSource.getInstance().randomInt(0, 11);
        if (x % 3 == 0) {
            extra = ResourceUtils.getRandomElement(this.directionList);
        }
        String building = RandomUtils.nextInt((int)1, (int)20) + "\u680b";
        String unit = RandomUtils.nextInt((int)1, (int)5) + "\u5355\u5143";
        String room = String.format("%02d", RandomUtils.nextInt((int)1, (int)31)) + String.format("%02d", RandomUtils.nextInt((int)1, (int)5)) + "\u623f";
        return prefix + road + "\u8def" + RandomUtils.nextInt((int)1, (int)1000) + "\u53f7" + community + extra + building + unit + room;
    }

    public double randomLatitude() {
        return NumberSource.getInstance().randomDouble(3.86, 53.55);
    }

    public double randomLongitude() {
        return NumberSource.getInstance().randomDouble(73.66, 135.05);
    }

    public String randomPhoneCode(String province) {
        if (StringUtils.isBlank((CharSequence)province)) {
            return null;
        }
        if (!this.phoneCodeMap.containsKey(province = province.replace("\u7701", "").replace("\u5e02", "").replace("\u81ea\u6cbb\u533a", ""))) {
            throw new IllegalArgumentException("\u6682\u4e0d\u5b58\u5728\u7701\u4efd\u540d\u79f0 " + province + " \u5bf9\u5e94\u7684\u533a\u53f7\u6570\u636e!");
        }
        List<String> codeList = this.phoneCodeMap.get(province);
        return CollectionUtils.isNotEmpty(codeList) ? codeList.get(RandomUtils.nextInt((int)0, (int)codeList.size())) : null;
    }

    public String randomPhoneNumber(String province, String delimiter) {
        String prefix = this.randomPhoneCode(province);
        if (StringUtils.isBlank((CharSequence)province)) {
            return null;
        }
        if (delimiter == null) {
            delimiter = " ";
        }
        return prefix + delimiter + RandomUtils.nextLong((long)10000000L, (long)99999999L);
    }

    public CountryOrRegionCode randomCountryOrRegionCode(String startsWith) {
        Preconditions.checkArgument((boolean)ALPHA_1.matcher(startsWith).matches(), (Object)"startsWith \u5fc5\u987b\u4e3a\u5355\u4e2a\u5b57\u6bcd");
        List<CountryOrRegionCode> filteredList = this.countryOrRegionCodeList.stream().filter(i -> i.getAlpha2().startsWith(startsWith.toUpperCase()) || i.getAlpha3().startsWith(startsWith.toUpperCase())).collect(Collectors.toList());
        return this.randomCountryOrRegionCode(filteredList);
    }

    public CountryOrRegionCode randomCountryOrRegionCode() {
        return this.randomCountryOrRegionCode(this.countryOrRegionCodeList);
    }

    private CountryOrRegionCode randomCountryOrRegionCode(List<CountryOrRegionCode> list) {
        return CollectionUtils.isNotEmpty(list) ? list.get(RandomUtils.nextInt((int)0, (int)(list.size() - 1))) : null;
    }
}

