/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.apifan.common.random.constant.CreditCardType;
import com.apifan.common.random.constant.RandomConstant;
import com.apifan.common.random.entity.IdPrefix;
import com.apifan.common.random.source.DateTimeSource;
import com.apifan.common.random.source.FinancialSource;
import com.apifan.common.random.util.PinyinUtils;
import com.apifan.common.random.util.ResourceUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonInfoSource {
    private static final Logger logger = LoggerFactory.getLogger(PersonInfoSource.class);
    private static final Font defaultFont = new Font("Dialog", 0, 78);
    private static final List<String> namePictureColorsList = Lists.newArrayList((Object[])new String[]{"255,111,97", "107,91,149", "136,176,75", "146,168,209", "149,82,81", "181,101,167", "0,155,119", "221,65,36", "214,80,118", "68,184,172", "239,192,80", "91,94,166", "155,35,53", "223,207,190", "85,180,176", "225,93,68", "127,205,205", "188,36,60", "195,68,122", "152,180,212"});
    private static Map<Integer, Integer> weightingFactorMap = Maps.newHashMap();
    private static Map<Integer, String> checkNumMap;
    private static Map<String, Font> fontMap;
    private List<String> lastNamesCN;
    private List<String> femaleFirstNamesCN;
    private List<String> maleFirstNamesCN;
    private List<String> lastNamesEN;
    private List<String> firstNamesEN;
    private List<IdPrefix> idPrefixList = Lists.newArrayList();
    private List<String> qqNames;
    private Map<String, List<String>> provinceIdPrefixMap = Maps.newHashMap();
    private static final PersonInfoSource instance;

    private PersonInfoSource() {
        this.lastNamesCN = ResourceUtils.readLines("last-names-cn.txt");
        this.femaleFirstNamesCN = ResourceUtils.readLines("female-first-names-cn.txt");
        this.maleFirstNamesCN = ResourceUtils.readLines("male-first-names-cn.txt");
        this.lastNamesEN = ResourceUtils.readLines("last-names-en.txt");
        this.firstNamesEN = ResourceUtils.readLines("first-names-en.txt");
        this.qqNames = ResourceUtils.readLines("qq-name.txt");
        List<String> lines = ResourceUtils.readLines("id-prefix.csv");
        if (CollectionUtils.isNotEmpty(lines)) {
            lines.forEach(i -> {
                if (StringUtils.isEmpty((CharSequence)i)) {
                    return;
                }
                List row = Splitter.on((String)",").splitToList((CharSequence)i);
                IdPrefix prefix = new IdPrefix();
                prefix.setPrefix((String)row.get(0));
                prefix.setLocation((String)row.get(1));
                prefix.setParent((String)row.get(2));
                this.idPrefixList.add(prefix);
            });
            HashSet provinceSet = new HashSet();
            this.idPrefixList.forEach(i -> {
                if (i == null) {
                    return;
                }
                if ("0".equals(i.getParent())) {
                    provinceSet.add(i);
                }
            });
            provinceSet.forEach(p -> {
                if (p == null) {
                    return;
                }
                this.provinceIdPrefixMap.put(p.getLocation(), this.findIdPrefixByProvince((IdPrefix)p));
            });
        }
    }

    public static PersonInfoSource getInstance() {
        return instance;
    }

    public String randomChineseName() {
        return this.randomChineseName(-1);
    }

    public String randomMaleChineseName() {
        return this.randomChineseName(1);
    }

    public String randomFemaleChineseName() {
        return this.randomChineseName(0);
    }

    private String randomChineseName(int gender) {
        Optional<String> lastName = Optional.ofNullable(ResourceUtils.getRandomElement(this.lastNamesCN));
        StringBuilder name = new StringBuilder(lastName.orElse(""));
        int length = RandomUtils.nextInt((int)1, (int)3);
        boolean isFemale = gender == 0 ? true : (gender == 1 ? false : RandomUtils.nextInt((int)1, (int)99999) % 2 == 0);
        for (int i = 0; i < length; ++i) {
            if (isFemale) {
                name.append(ResourceUtils.getRandomElement(this.femaleFirstNamesCN));
                continue;
            }
            name.append(ResourceUtils.getRandomElement(this.maleFirstNamesCN));
        }
        return name.toString();
    }

    public String randomEnglishName() {
        return ResourceUtils.getRandomElement(this.firstNamesEN) + " " + ResourceUtils.getRandomElement(this.lastNamesEN);
    }

    public String randomNickName(int maxLength) {
        if (maxLength < 4) {
            maxLength = 4;
        }
        StringBuilder sb = new StringBuilder(RandomStringUtils.randomAlphabetic((int)1));
        int actualLength = RandomUtils.nextInt((int)4, (int)(maxLength + 1));
        sb.append(RandomStringUtils.randomAlphanumeric((int)(actualLength - 1)));
        return sb.toString();
    }

    public String randomChineseNickName(int maxLength) {
        int x;
        if (maxLength < 4) {
            maxLength = 4;
        }
        if ((x = RandomUtils.nextInt((int)1, (int)11)) % 2 == 0) {
            return ResourceUtils.getRandomString(this.femaleFirstNamesCN, RandomUtils.nextInt((int)2, (int)(maxLength + 1)));
        }
        return ResourceUtils.getRandomString(this.maleFirstNamesCN, RandomUtils.nextInt((int)2, (int)(maxLength + 1)));
    }

    public String randomPinyinNickName(int maxLength) {
        String nickName = this.randomChineseNickName(maxLength);
        return PinyinUtils.toPinyin(nickName, true);
    }

    public String randomChineseMobile() {
        Optional<String> prefix = Optional.ofNullable(ResourceUtils.getRandomElement(RandomConstant.mobilePrefixList));
        StringBuilder mobile = new StringBuilder(prefix.orElse(""));
        int x = mobile.length() == 3 ? 8 : 11 - mobile.length();
        for (int i = 0; i < x; ++i) {
            mobile.append(RandomUtils.nextInt((int)0, (int)10));
        }
        return mobile.toString();
    }

    public String randomStrongPassword(int length, boolean useSpecialChar) {
        int i;
        int b;
        if (length < 8) {
            length = 8;
        }
        ArrayList<String> pwd = new ArrayList<String>();
        int oneThirdCount = length / 3;
        for (int i2 = 0; i2 < oneThirdCount; ++i2) {
            pwd.add(RandomStringUtils.randomAlphabetic((int)1).toUpperCase());
            pwd.add(RandomStringUtils.randomAlphabetic((int)1).toLowerCase());
        }
        if (useSpecialChar && (b = RandomUtils.nextInt((int)1, (int)oneThirdCount)) > 0) {
            for (i = 0; i < b; ++i) {
                pwd.add(ResourceUtils.getRandomElement(RandomConstant.specialCharList));
            }
        }
        if (pwd.size() < length) {
            int digitCount = length - pwd.size();
            for (i = 0; i < digitCount; ++i) {
                pwd.add(RandomStringUtils.randomNumeric((int)1));
            }
        }
        Collections.shuffle(pwd);
        return Joiner.on((String)"").join(pwd);
    }

    public String randomQQAccount() {
        return String.valueOf(RandomUtils.nextLong((long)10000L, (long)100000000000L));
    }

    public String randomQQNickName() {
        String name = ResourceUtils.getRandomString(this.qqNames, 1);
        return ResourceUtils.base64Decode(name);
    }

    public String randomMaleIdCard(String province, LocalDate beginDate, LocalDate endDate) {
        return this.randomIdCard(province, beginDate, endDate, 1);
    }

    public String randomMaleIdCard(String province, int age) {
        LocalDate today = LocalDate.now();
        int year = today.getYear() - age;
        LocalDate beginDate = LocalDate.of(year, 1, 1);
        LocalDate endDate = LocalDate.of(year, 12, 31);
        return this.randomIdCard(province, beginDate, endDate, 1);
    }

    public String randomMaleIdCard(String province, int minAge, int maxAge) {
        Preconditions.checkArgument((minAge < maxAge ? 1 : 0) != 0, (Object)"\u5e74\u9f84\u6bb5\u9519\u8bef");
        LocalDate today = LocalDate.now();
        int beginYear = today.getYear() - maxAge;
        int endYear = today.getYear() - minAge;
        LocalDate beginDate = LocalDate.of(beginYear, 1, 1);
        LocalDate endDate = LocalDate.of(endYear, 12, 31);
        return this.randomIdCard(province, beginDate, endDate, 1);
    }

    public String randomFemaleIdCard(String province, LocalDate beginDate, LocalDate endDate) {
        return this.randomIdCard(province, beginDate, endDate, 0);
    }

    public String randomFemaleIdCard(String province, int minAge, int maxAge) {
        Preconditions.checkArgument((minAge < maxAge ? 1 : 0) != 0, (Object)"\u5e74\u9f84\u6bb5\u9519\u8bef");
        LocalDate today = LocalDate.now();
        int beginYear = today.getYear() - maxAge;
        int endYear = today.getYear() - minAge;
        LocalDate beginDate = LocalDate.of(beginYear, 1, 1);
        LocalDate endDate = LocalDate.of(endYear, 12, 31);
        return this.randomIdCard(province, beginDate, endDate, 0);
    }

    public String randomFemaleIdCard(String province, int age) {
        LocalDate today = LocalDate.now();
        int year = today.getYear() - age;
        LocalDate beginDate = LocalDate.of(year, 1, 1);
        LocalDate endDate = LocalDate.of(year, 12, 31);
        return this.randomIdCard(province, beginDate, endDate, 0);
    }

    @Deprecated
    public String randomCreditCardNo(CreditCardType type) {
        return FinancialSource.getInstance().randomCreditCardNo(type);
    }

    public void generateNamePicture(String name, String savePath, String fontPath) throws IOException {
        File file;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name), (Object)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)savePath), (Object)"\u56fe\u7247\u4fdd\u5b58\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        String text = name;
        if (name.length() > 1) {
            int i = RandomUtils.nextInt((int)0, (int)name.length());
            text = name.substring(i, i + 1);
        }
        if ((file = new File(savePath)).exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6 " + savePath + " \u5df2\u5b58\u5728");
        }
        int width = 200;
        int height = 200;
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setBackground(this.getRandomColor());
        g2.clearRect(0, 0, width, height);
        g2.setPaint(Color.WHITE);
        g2.setFont(this.getFont(fontPath));
        g2.drawString(text, 62, 126);
        ImageIO.write((RenderedImage)bi, "png", file);
        logger.info("{} \u7684\u59d3\u540d\u56fe\u7247\u5df2\u751f\u6210\u5230 {}", (Object)name, (Object)savePath);
    }

    public void generateNamePicture(String name, String savePath) throws IOException {
        this.generateNamePicture(name, savePath, null);
    }

    public int randomGender() {
        return RandomUtils.nextInt((int)0, (int)2);
    }

    private Font getFont(String fontPath) {
        if (StringUtils.isEmpty((CharSequence)fontPath)) {
            logger.warn("\u5b57\u4f53\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a! \u5c06\u4f7f\u7528\u9ed8\u8ba4\u5b57\u4f53 {}", (Object)defaultFont.getName());
            return defaultFont;
        }
        File fontFile = new File(fontPath);
        if (!fontFile.exists()) {
            logger.warn("\u5b57\u4f53\u6587\u4ef6 {} \u4e0d\u5b58\u5728! \u5c06\u4f7f\u7528\u9ed8\u8ba4\u5b57\u4f53 {}", (Object)fontPath, (Object)defaultFont.getName());
            return defaultFont;
        }
        return fontMap.computeIfAbsent(fontPath, k -> {
            try {
                Font font = Font.createFont(0, fontFile).deriveFont(Float.parseFloat("78"));
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                ge.registerFont(font);
                return font;
            }
            catch (FontFormatException | IOException e) {
                logger.error("\u521d\u59cb\u5316\u5b57\u4f53\u5f02\u5e38", (Throwable)e);
                return null;
            }
        });
    }

    private Color getRandomColor() {
        String[] color = ResourceUtils.getRandomElement(namePictureColorsList).split(",");
        return new Color(Integer.parseInt(color[0]), Integer.parseInt(color[1]), Integer.parseInt(color[2]));
    }

    private String randomIdCard(String province, LocalDate beginDate, LocalDate endDate, int gender) {
        List<String> prefixList;
        Preconditions.checkArgument((beginDate != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a");
        Preconditions.checkArgument((endDate != null ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a");
        String prefix = "";
        if (StringUtils.isNotEmpty((CharSequence)province) && CollectionUtils.isNotEmpty(prefixList = this.provinceIdPrefixMap.get(province))) {
            prefix = ResourceUtils.getRandomElement(prefixList);
        }
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            Optional<IdPrefix> idPrefix = Optional.ofNullable(ResourceUtils.getRandomElement(this.idPrefixList));
            prefix = idPrefix.isPresent() ? idPrefix.get().getPrefix() : "";
        }
        String date = DateTimeSource.getInstance().randomDate(beginDate, endDate, "yyyyMMdd");
        int seq = RandomUtils.nextInt((int)1, (int)1000);
        if (gender == 0 && seq % 2 != 0) {
            --seq;
        } else if (gender == 1 && seq % 2 == 0) {
            ++seq;
        }
        String src = prefix + date + String.format("%03d", seq);
        int sum = 0;
        for (int i = 1; i <= src.length(); ++i) {
            int x = src.charAt(i - 1) - 48;
            int factor = i <= 10 ? weightingFactorMap.get(i).intValue() : weightingFactorMap.get(i - 10).intValue();
            sum += x * factor;
        }
        String checkNum = checkNumMap.get(sum % 11);
        return src + checkNum;
    }

    private List<String> findIdPrefixByProvince(IdPrefix provinceNode) {
        if (provinceNode == null || StringUtils.isEmpty((CharSequence)provinceNode.getPrefix())) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        this.idPrefixList.forEach(i -> {
            String shortPrefix = provinceNode.getPrefix().substring(0, 2);
            if (i.getPrefix().startsWith(shortPrefix)) {
                resultList.add(i.getPrefix());
            }
        });
        return resultList;
    }

    static {
        weightingFactorMap.put(1, 7);
        weightingFactorMap.put(2, 9);
        weightingFactorMap.put(3, 10);
        weightingFactorMap.put(4, 5);
        weightingFactorMap.put(5, 8);
        weightingFactorMap.put(6, 4);
        weightingFactorMap.put(7, 2);
        weightingFactorMap.put(8, 1);
        weightingFactorMap.put(9, 6);
        weightingFactorMap.put(10, 3);
        checkNumMap = Maps.newHashMap();
        checkNumMap.put(0, "1");
        checkNumMap.put(1, "0");
        checkNumMap.put(2, "X");
        checkNumMap.put(3, "9");
        checkNumMap.put(4, "8");
        checkNumMap.put(5, "7");
        checkNumMap.put(6, "6");
        checkNumMap.put(7, "5");
        checkNumMap.put(8, "4");
        checkNumMap.put(9, "3");
        checkNumMap.put(10, "2");
        fontMap = new ConcurrentHashMap<String, Font>();
        instance = new PersonInfoSource();
    }
}

