/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test;

import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.test.dao.DaoHelper;
import com.dtstep.lighthouse.test.mode.AiShortVideoTrainMonitorSample;
import com.dtstep.lighthouse.test.mode.BizHousePriceChangeDTSample;
import com.dtstep.lighthouse.test.mode.BizOrderConversionRateSample;
import com.dtstep.lighthouse.test.mode.BizOrderStatSample;
import com.dtstep.lighthouse.test.mode.FeAppStartAdvStatSample;
import com.dtstep.lighthouse.test.mode.ITKVDBRequestMonitorSample;
import com.dtstep.lighthouse.test.mode.OmAppStartDauStatSample;
import com.dtstep.lighthouse.test.mode.OmDauPromoteMonitor;
import com.dtstep.lighthouse.test.mode.OpsNodesLoadStateMonitorSample;
import com.dtstep.lighthouse.test.mode.OpsNodesLoginStateDTSample;
import com.dtstep.lighthouse.test.mode.OpsNodesRunStatusMonitorSample;
import com.dtstep.lighthouse.test.mode.PMFeedNewsBehaviorStatSample;
import com.dtstep.lighthouse.test.mode.PMSocialPrichatEnvelopeSample;
import com.dtstep.lighthouse.test.mode.PMSocialPrivateChatMsgStat;
import com.dtstep.lighthouse.test.mode.RDShortRecallCostSample;
import com.dtstep.lighthouse.test.mode.RDShortVideoRecallSizeSample;
import com.dtstep.lighthouse.test.mode.RDShortVideoRequestStatSample;
import com.dtstep.lighthouse.test.mode.SimulationModalSample;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;

public class LDPSimulationInstance {
    private static final ScheduledExecutorService service = Executors.newScheduledThreadPool(6);
    private static final Queue<TaskConfig> tasksQueue = new LinkedBlockingDeque<TaskConfig>();

    public static void main(String[] args) throws Exception {
        LDPConfig.loadConfiguration();
        LightHouse.init((String)LDPConfig.getVal((String)"lighthouse.ice.locators"));
        List<Group> groupEntityList = LDPSimulationInstance.loadTokenList();
        Runnable runnable = () -> {
            try {
                if (CollectionUtils.isNotEmpty((Collection)groupEntityList)) {
                    for (Group groupEntity : groupEntityList) {
                        long batch = DateUtil.batchTime((int)1, (TimeUnit)TimeUnit.MINUTES, (long)System.currentTimeMillis());
                        TaskConfig taskConfig = new TaskConfig();
                        taskConfig.setToken(groupEntity.getToken());
                        taskConfig.setGroupEntity(groupEntity);
                        taskConfig.setTimestamp(batch);
                        tasksQueue.add(taskConfig);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        };
        service.scheduleAtFixedRate(runnable, 0L, 30L, TimeUnit.SECONDS);
    }

    public static void process(TaskConfig task) throws Exception {
        String token = task.getToken();
        long time = task.getTimestamp();
        SimulationModalSample<HashMap<String, Object>> sample = null;
        if ("om_appstart_dau_stat".equals(token)) {
            sample = new OmAppStartDauStatSample();
        } else if ("biz_house_price_change_dt".equals(token)) {
            sample = new BizHousePriceChangeDTSample();
        } else if ("biz_order_stat".equals(token)) {
            sample = new BizOrderStatSample();
        } else if ("pm_social_privatechat_msg_dt".equals(token)) {
            sample = new PMSocialPrivateChatMsgStat();
        } else if ("pm_social_prichat_envelope".equals(token)) {
            sample = new PMSocialPrichatEnvelopeSample();
        } else if ("it_kvdb_request_monitor".equals(token)) {
            sample = new ITKVDBRequestMonitorSample();
        } else if ("ops_nodes_run_status_monitor".equals(token)) {
            sample = new OpsNodesRunStatusMonitorSample();
        } else if ("ops_nodes_load_state_dt".equals(token)) {
            sample = new OpsNodesLoadStateMonitorSample();
        } else if ("ops_nodes_login_state_dt".equals(token)) {
            sample = new OpsNodesLoginStateDTSample();
        } else if ("pm_feednews_behavior_stat".equals(token)) {
            sample = new PMFeedNewsBehaviorStatSample();
        } else if ("ai_shortvideo_train_monitor".equals(token)) {
            sample = new AiShortVideoTrainMonitorSample();
        } else if ("fe_appstart_adv_stat".equals(token)) {
            sample = new FeAppStartAdvStatSample();
        } else if ("rd_shortvideo_request_stat".equals(token)) {
            sample = new RDShortVideoRequestStatSample();
        } else if ("rd_shortvideo_recall_size_dt".equals(token)) {
            sample = new RDShortVideoRecallSizeSample();
        } else if ("rd_shortvideo_recall_cost".equals(token)) {
            sample = new RDShortRecallCostSample();
        } else if ("om_dau_promote_monitor".equals(token)) {
            sample = new OmDauPromoteMonitor();
        } else if ("biz_order_conversion_rate".equals(token)) {
            sample = new BizOrderConversionRateSample();
        }
        if (sample == null) {
            return;
        }
        int onceSize = 50 + ThreadLocalRandom.current().nextInt(10);
        for (int i = 0; i < onceSize; ++i) {
            HashMap<String, Object> paramMap = sample.generateSample();
            LightHouse.stat((String)token, (String)task.getGroupEntity().getSecretKey(), paramMap, (long)time);
        }
        System.out.println("send success,batch:" + DateUtil.formatTimeStamp((long)task.getTimestamp(), (String)"yyyy-MM-dd HH:mm:ss") + ",token: " + token + ",size:" + onceSize);
    }

    public static List<Group> loadTokenList() throws Exception {
        String clusterId = LDPConfig.getVal((String)"lighthouse.cluster.id");
        List<Group> list = DaoHelper.sql.getList(Group.class, "SELECT token,secret_key FROM cluster_" + clusterId + "_ldp_cmdb.ldp_stat_group", new Object[0]);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list;
    }

    private void initSimulationConfig() {
    }

    static {
        for (int i = 0; i < 5; ++i) {
            service.scheduleWithFixedDelay(new ProcessThread(), 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public static class ProcessThread
    extends Thread {
        @Override
        public void run() {
            TaskConfig msg = tasksQueue.poll();
            if (msg == null) {
                return;
            }
            try {
                LDPSimulationInstance.process(msg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class TaskConfig {
        private String token;
        private long timestamp;
        private Group groupEntity;

        private TaskConfig() {
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public Group getGroupEntity() {
            return this.groupEntity;
        }

        public void setGroupEntity(Group groupEntity) {
            this.groupEntity = groupEntity;
        }
    }
}

