/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test.impl;

import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.OkHttpUtil;
import com.dtstep.lighthouse.test.config.TestConfigContext;
import com.dtstep.lighthouse.test.entity.BehaviorSampleEntity;
import com.dtstep.lighthouse.test.entity.SampleEntity;
import com.dtstep.lighthouse.test.impl.TestModel;
import com.dtstep.lighthouse.test.mode.ModalSample;
import com.dtstep.lighthouse.test.util.BeanUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class FlowModeTestImpl
implements TestModel {
    private static final ScheduledExecutorService service = Executors.newScheduledThreadPool(5);

    @Override
    public void send(TestConfigContext testConfigContext) throws Exception {
        Runnable runnable = () -> {
            try {
                long t1 = System.currentTimeMillis();
                long timestamp = DateUtil.batchTime((int)1, (TimeUnit)TimeUnit.MINUTES, (long)System.currentTimeMillis());
                long messageTime = timestamp + (long)ThreadLocalRandom.current().nextInt(60000);
                String token = testConfigContext.getToken();
                String secretKey = testConfigContext.getSecretKey();
                ModalSample<BehaviorSampleEntity> modalSample = testConfigContext.getModalSample();
                int size = testConfigContext.getMessageSize();
                String method = testConfigContext.getMethod();
                if (method.equals("rpc")) {
                    for (int i = 0; i < size * 30; ++i) {
                        SampleEntity sampleEntity = modalSample.generateSample();
                        LightHouse.stat((String)token, (String)secretKey, BeanUtil.beanToMap(sampleEntity), (long)messageTime);
                    }
                    long t2 = System.currentTimeMillis();
                    System.out.println("send result:success,method:rpc,batchTime:" + DateUtil.formatTimeStamp((long)timestamp, (String)"yyyy-MM-dd HH:mm:ss") + ",execute time:" + DateUtil.formatTimeStamp((long)t1, (String)"yyyy-MM-dd HH:mm:ss") + ",cost:" + (t2 - t1));
                } else {
                    ArrayList requestList = new ArrayList();
                    for (int i = 0; i < size * 30; ++i) {
                        HashMap<String, Object> requestMap = new HashMap<String, Object>();
                        requestMap.put("token", token);
                        requestMap.put("secretKey", secretKey);
                        requestMap.put("timestamp", messageTime);
                        SampleEntity sampleEntity = modalSample.generateSample();
                        Map<String, Object> paramsMap = BeanUtil.beanToMap(sampleEntity);
                        requestMap.put("params", paramsMap);
                        requestList.add(requestMap);
                    }
                    String requestParams = JsonUtil.toJSONString(requestList);
                    String apiUrl = String.format("http://%s:18101/api/rpc/v1/stats", testConfigContext.getIps().get(ThreadLocalRandom.current().nextInt(testConfigContext.getIps().size())));
                    String response = OkHttpUtil.post((String)apiUrl, (String)requestParams);
                    long t2 = System.currentTimeMillis();
                    System.out.println("send result:" + response + ",method:http,batchTime:" + DateUtil.formatTimeStamp((long)timestamp, (String)"yyyy-MM-dd HH:mm:ss") + ",execute time:" + DateUtil.formatTimeStamp((long)t1, (String)"yyyy-MM-dd HH:mm:ss") + ",cost:" + (t2 - t1));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        };
        service.scheduleAtFixedRate(runnable, 0L, 30L, TimeUnit.SECONDS);
    }
}

