/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test.impl;

import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.test.config.TestConfigContext;
import com.dtstep.lighthouse.test.entity.BehaviorSampleEntity;
import com.dtstep.lighthouse.test.entity.SampleEntity;
import com.dtstep.lighthouse.test.impl.TestModel;
import com.dtstep.lighthouse.test.mode.ModalSample;
import com.dtstep.lighthouse.test.util.BeanUtil;
import java.util.concurrent.TimeUnit;

public class OnceModeTestImpl
implements TestModel {
    @Override
    public void send(TestConfigContext testConfigContext) throws Exception {
        long t1 = System.currentTimeMillis();
        long batchTime = DateUtil.batchTime((int)1, (TimeUnit)TimeUnit.MINUTES, (long)System.currentTimeMillis());
        String token = testConfigContext.getToken();
        String secretKey = testConfigContext.getSecretKey();
        ModalSample<BehaviorSampleEntity> modalSample = testConfigContext.getModalSample();
        int size = testConfigContext.getMessageSize();
        for (int i = 0; i < size; ++i) {
            SampleEntity sampleEntity = modalSample.generateSample();
            sampleEntity.setTimestamp(batchTime);
            LightHouse.stat((String)token, (String)secretKey, BeanUtil.beanToMap(sampleEntity), (long)batchTime);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("send success,batchTime:" + DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss") + ",execute time:" + DateUtil.formatTimeStamp((long)t1, (String)"yyyy-MM-dd HH:mm:ss") + ",cost:" + (t2 - t1));
    }
}

