/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test.relation;

import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupHandler {
    private static final Logger logger = LoggerFactory.getLogger(GroupHandler.class);

    public static Integer createGroup(Connection conn, Group group) throws Exception {
        String insertSql = "INSERT INTO ldp_groups (token,project_id,columns,random_id,secret_key,`state`,refresh_time,create_time,update_time,`desc`) VALUES (?, ?, ?, ?, ?,?, ?, ?, ?,?)";
        QueryRunner queryRunner = new QueryRunner();
        BigInteger permissionId = (BigInteger)queryRunner.insert(conn, insertSql, (ResultSetHandler)new ScalarHandler(), new Object[]{group.getToken(), group.getProjectId(), JsonUtil.toJSONString((Object)group.getColumns()), group.getRandomId(), group.getSecretKey(), group.getState().getState(), group.getRefreshTime(), group.getCreateTime(), group.getUpdateTime(), group.getDesc()});
        return permissionId.intValue();
    }

    public static Group queryGroupInfo(String token) throws Exception {
        try {
            Connection conn = (Connection)CMDBStorageEngineProxy.getInstance().getConnection();
            QueryRunner qr = new QueryRunner();
            List list = (List)qr.query(conn, "select id,project_id from ldp_groups where token = ?", (ResultSetHandler)new MapListHandler(), new Object[]{token});
            if (CollectionUtils.isEmpty((Collection)list)) {
                Group group = null;
                return group;
            }
            Map infoMap = (Map)list.get(0);
            Integer id = (Integer)infoMap.get("id");
            Integer projectId = (Integer)infoMap.get("project_id");
            Group group = new Group();
            group.setId(id);
            group.setProjectId(projectId);
            Group group2 = group;
            return group2;
        }
        catch (Exception ex) {
            logger.error("query valid meta info error!", (Throwable)ex);
            ex.printStackTrace();
            throw ex;
        }
        finally {
            CMDBStorageEngineProxy.getInstance().closeConnection();
        }
    }

    public static void delete(Connection connection, Integer groupId) throws Exception {
        String sql = "DELETE FROM ldp_groups WHERE id = ?";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setInt(1, groupId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            logger.error("delete mysql data error!", (Throwable)ex);
            ex.printStackTrace();
        }
    }
}

