/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test.relation;

import com.dtstep.lighthouse.common.modal.MetaTable;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngineProxy;
import com.dtstep.lighthouse.core.wrapper.MetaTableWrapper;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetaHandler.class);

    public static Integer createMeta(Connection conn, MetaTable metaTable) throws Exception {
        String metaName = metaTable.getMetaName();
        try {
            WarehouseStorageEngineProxy.getInstance().createResultTable(metaName);
            logger.info("create stat storage table success,metaName:{}", (Object)metaName);
        }
        catch (Exception ex) {
            logger.error("create stat storage table error,metaName:{}", (Object)metaName, (Object)ex);
            throw ex;
        }
        String insertSql = "INSERT INTO ldp_metas (meta_name,type,state,create_time,update_time) VALUES (?, ?, ?, ?, ?)";
        QueryRunner queryRunner = new QueryRunner();
        BigInteger metaId = (BigInteger)queryRunner.insert(conn, insertSql, (ResultSetHandler)new ScalarHandler(), new Object[]{metaTable.getMetaName(), metaTable.getMetaTableType().getType(), metaTable.getState().getState(), metaTable.getCreateTime(), metaTable.getUpdateTime()});
        return metaId.intValue();
    }

    private static Integer queryDBValidMetaId() throws Exception {
        try {
            Connection conn = (Connection)CMDBStorageEngineProxy.getInstance().getConnection();
            QueryRunner qr = new QueryRunner();
            List list = (List)qr.query(conn, "select id from ldp_metas where `state` = ? and `type` = ? order by create_time desc limit 1", (ResultSetHandler)new MapListHandler(), new Object[]{1, 3});
            if (CollectionUtils.isEmpty((Collection)list)) {
                Integer n = -1;
                return n;
            }
            Map infoMap = (Map)list.get(0);
            Integer n = (Integer)infoMap.get("id");
            return n;
        }
        catch (Exception ex) {
            logger.error("query valid meta info error!", (Throwable)ex);
            ex.printStackTrace();
            throw ex;
        }
        finally {
            CMDBStorageEngineProxy.getInstance().closeConnection();
        }
    }

    public static Integer queryValidMetaId() throws Exception {
        Integer metaId = MetaHandler.queryDBValidMetaId();
        if (metaId == -1) {
            metaId = MetaTableWrapper.createStatStorageAndMetaTable();
        }
        return metaId;
    }
}

