/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.standalone.rpc;

import com.dtstep.lighthouse.common.entity.rpc.RpcMsgType;
import com.dtstep.lighthouse.common.entity.rpc.RpcRequest;
import com.dtstep.lighthouse.common.entity.rpc.RpcResponse;
import com.dtstep.lighthouse.common.ice.LightRpcException;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.standalone.rpc.provider.StandaloneRemoteServiceImpl;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyServerHandler
extends SimpleChannelInboundHandler<RpcRequest> {
    private static final ConcurrentHashMap<String, Object> registryMap = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(NettyServerHandler.class);

    public static void register() {
        registryMap.put("com.dtstep.lighthouse.common.rpc.BasicRemoteLightServerPrx", new StandaloneRemoteServiceImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, RpcRequest request) throws Exception {
        block11: {
            try {
                Object result = new Object();
                String error = null;
                if (request.getType() == RpcMsgType.Normal) {
                    if (registryMap.containsKey(request.getClassName())) {
                        try {
                            Object provider = registryMap.get(request.getClassName());
                            Method method = provider.getClass().getMethod(request.getMethodName(), request.getParameterTypes());
                            result = method.invoke(provider, request.getParameterValues());
                        }
                        catch (InvocationTargetException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof LightRpcException) {
                                LightRpcException lightRpcException = (LightRpcException)cause;
                                String errorMessage = lightRpcException.getMessage();
                                error = errorMessage == null ? "Remote Server process error!" : errorMessage;
                            } else {
                                logger.error("method process error,request:{}!", (Object)JsonUtil.toJSONString((Object)request), (Object)ex);
                                error = ex.getMessage() == null ? "Remote Server process error!" : cause.getMessage();
                            }
                        }
                        catch (Exception ex) {
                            logger.error("method process error,request:{}!", (Object)JsonUtil.toJSONString((Object)request), (Object)ex);
                            error = ex.getMessage() == null ? "Remote Server process error!" : ex.getMessage();
                        }
                    }
                    RpcResponse response = new RpcResponse();
                    response.setRequestId(request.getRequestId());
                    response.setType(RpcMsgType.Normal);
                    response.setResult(result);
                    response.setError(error);
                    ctx.writeAndFlush((Object)response);
                    break block11;
                }
                if (request.getType() == RpcMsgType.HeartBeat) {
                    RpcResponse response = new RpcResponse();
                    response.setRequestId(request.getRequestId());
                    response.setType(RpcMsgType.HeartBeat);
                    response.setError(error);
                    ctx.writeAndFlush((Object)response);
                }
            }
            finally {
                ReferenceCountUtil.release((Object)request);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

