/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.standalone.rpc;

import com.dtstep.lighthouse.common.entity.rpc.RpcRequest;
import com.dtstep.lighthouse.common.entity.rpc.RpcResponse;
import com.dtstep.lighthouse.common.rpc.netty.RpcDecoder;
import com.dtstep.lighthouse.common.rpc.netty.RpcEncoder;
import com.dtstep.lighthouse.common.serializer.KryoSerializer;
import com.dtstep.lighthouse.common.serializer.Serializer;
import com.dtstep.lighthouse.standalone.rpc.NettyServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public class ServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final NettyServerHandler nettyServerHandler = new NettyServerHandler();

    protected void initChannel(SocketChannel ch) {
        int fieldLength = 4;
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, fieldLength, 0, fieldLength)});
        pipeline.addLast(new ChannelHandler[]{new LengthFieldPrepender(fieldLength)});
        pipeline.addLast("encoder", (ChannelHandler)new RpcEncoder(RpcResponse.class, (Serializer)new KryoSerializer()));
        pipeline.addLast("decoder", (ChannelHandler)new RpcDecoder(RpcRequest.class, (Serializer)new KryoSerializer()));
        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, 30L, TimeUnit.SECONDS)});
        pipeline.addLast(new ChannelHandler[]{nettyServerHandler});
    }
}

