/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.standalone.rpc.provider;

import com.dtstep.lighthouse.common.entity.group.GroupVerifyEntity;
import com.dtstep.lighthouse.common.entity.stat.StatVerifyEntity;
import com.dtstep.lighthouse.common.entity.view.LimitValue;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.ice.LightRpcException;
import com.dtstep.lighthouse.common.rpc.BasicRemoteLightServerPrx;
import com.dtstep.lighthouse.core.builtin.CallerStat;
import com.dtstep.lighthouse.core.ipc.RPCServer;
import com.dtstep.lighthouse.core.ipc.impl.RPCServerImpl;
import com.dtstep.lighthouse.core.tools.ObjectSize;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneRemoteServiceImpl
implements BasicRemoteLightServerPrx {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneRemoteServiceImpl.class);
    private static final RPCServer rpc = new RPCServerImpl();

    public void process(byte[] bytes) throws LightRpcException {
        try {
            rpc.process(bytes);
        }
        catch (Exception ex) {
            logger.error("process message error!", (Throwable)ex);
            throw new LightRpcException(ex.getMessage());
        }
    }

    public GroupVerifyEntity queryGroupInfo(String token) throws LightRpcException {
        try {
            return rpc.queryGroupInfo(token);
        }
        catch (Exception ex) {
            logger.error("query group error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public StatVerifyEntity queryStatInfo(int id) throws LightRpcException {
        try {
            return rpc.queryStatInfo(id);
        }
        catch (Exception ex) {
            logger.error("query stat error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public List<StatValue> dataQuery(int statId, String dimensValue, List<Long> batchTime) throws LightRpcException {
        try {
            return rpc.dataQuery(statId, dimensValue, batchTime);
        }
        catch (Exception ex) {
            logger.error("call dataQuery error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public List<StatValue> dataDurationQuery(int statId, String dimensValue, long startTime, long endTime) throws LightRpcException {
        try {
            return rpc.dataDurationQuery(statId, dimensValue, startTime, endTime);
        }
        catch (Exception ex) {
            logger.error("call dataDurationQuery error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public Map<String, List<StatValue>> dataQueryWithDimensList(int statId, List<String> dimensValueList, List<Long> batchTime) throws LightRpcException {
        try {
            return rpc.dataQueryWithDimensList(statId, dimensValueList, batchTime);
        }
        catch (Exception ex) {
            logger.error("call dataQueryWithDimensList error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public Map<String, List<StatValue>> dataDurationQueryWithDimensList(int statId, List<String> dimensValueList, long startTime, long endTime) throws LightRpcException {
        try {
            return rpc.dataDurationQueryWithDimensList(statId, dimensValueList, startTime, endTime);
        }
        catch (Exception ex) {
            logger.error("call dataDurationQueryWithDimensList error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public List<LimitValue> limitQuery(int statId, long batchTime) throws LightRpcException {
        try {
            return rpc.limitQuery(statId, batchTime);
        }
        catch (Exception ex) {
            logger.error("call limitQuery error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public List<StatValue> dataQueryV2(String callerName, String callerKey, int statId, String dimensValue, List<Long> batchTime) throws LightRpcException {
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException((Throwable)ex);
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey) + ObjectSize.getObjectSize((Object)dimensValue);
        long outBytes = 0L;
        try {
            List data = rpc.dataQuery(statId, dimensValue, batchTime);
            outBytes = ObjectSize.getObjectSize((Object)data);
            CallerStat.stat((int)callerId, (String)"dataQuery", (int)0, (Long)inBytes, (Long)outBytes);
            return data;
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"dataQuery", (int)1, (Long)inBytes, (Long)outBytes);
            logger.error("call dataQuery error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public List<StatValue> dataDurationQueryV2(String callerName, String callerKey, int statId, String dimensValue, long startTime, long endTime) throws LightRpcException {
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException((Throwable)ex);
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey) + ObjectSize.getObjectSize((Object)dimensValue);
        long outBytes = 0L;
        try {
            List data = rpc.dataDurationQuery(statId, dimensValue, startTime, endTime);
            outBytes = ObjectSize.getObjectSize((Object)data);
            CallerStat.stat((int)callerId, (String)"dataDurationQuery", (int)0, (Long)inBytes, (Long)outBytes);
            return data;
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"dataDurationQuery", (int)1, (Long)inBytes, (Long)outBytes);
            logger.error("call dataDurationQuery error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public Map<String, List<StatValue>> dataQueryWithDimensListV2(String callerName, String callerKey, int statId, List<String> dimensValueList, List<Long> batchTime) throws LightRpcException {
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException((Throwable)ex);
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey) + ObjectSize.getObjectSize(batchTime) + ObjectSize.getObjectSize(dimensValueList);
        long outBytes = 0L;
        try {
            Map data = rpc.dataQueryWithDimensList(statId, dimensValueList, batchTime);
            outBytes = ObjectSize.getObjectSize((Object)data);
            CallerStat.stat((int)callerId, (String)"dataQueryWithDimensList", (int)0, (Long)inBytes, (Long)outBytes);
            return data;
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"dataQueryWithDimensList", (int)1, (Long)inBytes, (Long)outBytes);
            logger.error("call dataQueryWithDimensList error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public Map<String, List<StatValue>> dataDurationQueryWithDimensListV2(String callerName, String callerKey, int statId, List<String> dimensValueList, long startTime, long endTime) throws LightRpcException {
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException((Throwable)ex);
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey) + ObjectSize.getObjectSize((Object)statId) + ObjectSize.getObjectSize(dimensValueList);
        long outBytes = 0L;
        try {
            Map data = rpc.dataDurationQueryWithDimensList(statId, dimensValueList, startTime, endTime);
            outBytes = ObjectSize.getObjectSize((Object)data);
            CallerStat.stat((int)callerId, (String)"dataDurationQueryWithDimensList", (int)0, (Long)inBytes, (Long)outBytes);
            return data;
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"dataDurationQueryWithDimensList", (int)1, (Long)inBytes, (Long)outBytes);
            logger.error("call dataDurationQueryWithDimensList error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }

    public List<LimitValue> limitQueryV2(String callerName, String callerKey, int statId, long batchTime) throws LightRpcException {
        int callerId;
        try {
            callerId = rpc.authVerification(callerName, callerKey, statId, ResourceTypeEnum.Stat);
        }
        catch (Exception ex) {
            throw new LightRpcException((Throwable)ex);
        }
        long inBytes = ObjectSize.getObjectSize((Object)callerName) + ObjectSize.getObjectSize((Object)callerKey) + ObjectSize.getObjectSize((Object)statId) + ObjectSize.getObjectSize((Object)batchTime);
        long outBytes = 0L;
        try {
            List data = rpc.limitQuery(statId, batchTime);
            outBytes = ObjectSize.getObjectSize((Object)data);
            CallerStat.stat((int)callerId, (String)"limitQuery", (int)0, (Long)inBytes, (Long)outBytes);
            return data;
        }
        catch (Exception ex) {
            CallerStat.stat((int)callerId, (String)"limitQuery", (int)1, (Long)inBytes, (Long)outBytes);
            logger.error("call limitQuery error!", (Throwable)ex);
            throw new LightRpcException((Throwable)ex);
        }
    }
}

