/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.aggregator;

import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.aggregator.SlotsGroup;
import com.dtstep.lighthouse.common.entity.event.SlotEvent;
import com.dtstep.lighthouse.common.hash.HashUtil;
import java.util.Comparator;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingEventPool<T extends SlotEvent<T>>
implements EventPool<T> {
    private static final Logger logger = LoggerFactory.getLogger(BlockingEventPool.class);
    private String name;
    private final SlotsGroup<T> slotsGroup;
    private final int slotSize;

    public BlockingEventPool(int slotSize, int slotCapacity, Comparator<T> comparator) {
        this.slotSize = slotSize;
        this.slotsGroup = new SlotsGroup<T>(slotSize, slotCapacity, comparator);
    }

    public BlockingEventPool(int slotCapacity, Comparator<T> comparator) {
        this.slotSize = 10;
        this.slotsGroup = new SlotsGroup<T>(this.slotSize, slotCapacity, comparator);
    }

    public BlockingEventPool(int slotSize, int slotCapacity) {
        this.slotSize = slotSize;
        this.slotsGroup = new SlotsGroup(slotSize, slotCapacity);
    }

    public BlockingEventPool(String name, int slotSize, int slotCapacity) {
        this.name = name;
        this.slotSize = slotSize;
        this.slotsGroup = new SlotsGroup(slotSize, slotCapacity);
    }

    @Override
    public void put(int slot, T t) throws Exception {
        if (slot < 0 || slot > this.slotSize) {
            throw new IllegalArgumentException("Illegal parameter slot:" + slot + ",max size:" + this.slotSize);
        }
        if (t == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.slotsGroup.put(slot, t);
        long cost = stopWatch.getTime();
        if (cost > 10000L) {
            logger.warn("Put elements to event pool[{}],slot[{}] cost exceeds threshold[{}ms>{}ms]!", new Object[]{this.name, slot, cost, 10000});
        }
    }

    @Override
    @Deprecated
    public void put(T t) throws Exception {
        if (t == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int slot = HashUtil.getHashIndex(t.toString(), this.slotSize);
        this.slotsGroup.put(slot, t);
        long cost = stopWatch.getTime();
        if (cost > 10000L) {
            logger.warn("Put elements to event pool[{}],slot[{}] cost exceeds threshold[{}ms>{}ms]!", new Object[]{this.name, slot, cost, 10000});
        }
    }

    @Override
    public SlotsGroup.SlotWrapper<T> take(int slot) throws Exception {
        return this.slotsGroup.getSlotWrapper(slot);
    }

    @Override
    public int slotSize() {
        return this.slotSize;
    }

    @Override
    public boolean isEmpty() throws Exception {
        for (int i = 0; i < this.slotSize; ++i) {
            SlotsGroup.SlotWrapper<T> slotWrapper = this.take(i);
            if (slotWrapper.getQueue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() throws Exception {
        for (int i = 0; i < this.slotSize; ++i) {
            SlotsGroup.SlotWrapper<T> slotWrapper = this.take(i);
            slotWrapper.getQueue().clear();
        }
    }
}

