/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.entity.stat;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public final class TimeParam
implements Serializable {
    private static final long serialVersionUID = 3077691198272246436L;
    private int interval;
    private TimeUnit timeUnit;
    private long duration;

    public TimeParam() {
    }

    public TimeParam(int interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.timeUnit = timeUnit;
        this.duration = TimeParam.calculateDuration(interval, timeUnit);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public static long calculateDuration(TimeParam timeParam) {
        if (timeParam == null) {
            return 0L;
        }
        return timeParam.timeUnit.toMillis(timeParam.getDuration());
    }

    public static long calculateDuration(int interval, TimeUnit timeUnit) {
        return timeUnit.toMillis(interval);
    }

    public static long calculateDuration(String timeparam) {
        String[] arr = timeparam.split("-");
        int interval = Integer.parseInt(arr[0]);
        String timeunit = arr[1];
        if (timeunit.equals("second")) {
            return TimeUnit.SECONDS.toMillis(interval);
        }
        if (timeunit.equals("minute")) {
            return TimeUnit.MINUTES.toMillis(interval);
        }
        if (timeunit.equals("hour")) {
            return TimeUnit.HOURS.toMillis(interval);
        }
        return TimeUnit.DAYS.toMillis(interval);
    }
}

