/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.entity.state;

import com.dtstep.lighthouse.common.entity.state.StatUnit;
import com.dtstep.lighthouse.common.enums.function.FunctionEnum;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public final class StatState
implements Serializable {
    private static final long serialVersionUID = 7711305424710115418L;
    private int statId;
    private int groupId;
    private String stateBody;
    private FunctionEnum functionEnum;
    private String stateName;
    private int functionIndex;
    private List<StatUnit> unitList;
    private Set<String> relatedColumnSet;
    private boolean isBuiltIn = false;

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
        this.setFunctionEnum(FunctionEnum.getStatFunctionEnum(stateName));
    }

    public int getFunctionIndex() {
        return this.functionIndex;
    }

    public void setFunctionIndex(int functionIndex) {
        this.functionIndex = functionIndex;
    }

    public List<StatUnit> getUnitList() {
        return this.unitList;
    }

    public void setUnitList(List<StatUnit> unitList) {
        this.unitList = unitList;
    }

    public static void valid(StatState statState) throws Exception {
    }

    public String getStateBody() {
        return this.stateBody;
    }

    public void setStateBody(String stateBody) {
        this.stateBody = stateBody;
    }

    public Set<String> getRelatedColumnSet() {
        return this.relatedColumnSet;
    }

    public void setRelatedColumnSet(Set<String> relatedColumnSet) {
        this.relatedColumnSet = relatedColumnSet;
    }

    public FunctionEnum getFunctionEnum() {
        return this.functionEnum;
    }

    public void setFunctionEnum(FunctionEnum functionEnum) {
        this.functionEnum = functionEnum;
    }

    public int getStatId() {
        return this.statId;
    }

    public void setStatId(int statId) {
        this.statId = statId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.isBuiltIn = builtIn;
    }

    public static boolean isBitCountState(StatState statState) {
        return statState.getFunctionEnum() == FunctionEnum.BITCOUNT;
    }

    public static boolean isCountState(StatState statState) {
        return statState.getFunctionEnum() == FunctionEnum.COUNT;
    }

    public static int getFilterStartIndex(StatState statState) {
        return statState.getFunctionEnum() == FunctionEnum.COUNT ? 0 : 1;
    }

    public static String getFirstUnit(StatState statState) {
        return CollectionUtils.isEmpty(statState.getUnitList()) ? null : statState.getUnitList().get(0).getOrigin();
    }
}

