/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.lru.impl;

import com.dtstep.lighthouse.common.lru.Cache;
import com.dtstep.lighthouse.common.lru.LRU;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDPCache<K, V>
implements Cache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(LDPCache.class);
    private Map<K, Node<K, V>> cache;
    private final DoublyLinkedList<K, V> doublyQueue;
    private final LRU<? super K, ? super V> builder;
    private final StampedLock lock = new StampedLock();
    private int size;

    public LDPCache(LRU<? super K, ? super V> builder) {
        this.builder = builder;
        this.cache = new HashMap<K, Node<K, V>>();
        this.doublyQueue = new DoublyLinkedList();
        this.size = 0;
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("ldp-cache-clear-" + thread.getId());
            thread.setDaemon(true);
            return thread;
        });
        service.scheduleWithFixedDelay(new ClearThread(this, this.lock), 0L, 1L, TimeUnit.MINUTES);
    }

    public LRU<? super K, ? super V> getBuilder() {
        return this.builder;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K k) {
        long stamp = this.lock.tryOptimisticRead();
        V v = this.atomGet(k);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                v = this.atomGet(k);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K k, Function<? super K, ? extends V> f) {
        long stamp = this.lock.writeLock();
        V v = null;
        try {
            v = this.atomGet(k);
            if (v == null && (v = (V)f.apply(k)) != null) {
                this.atomPut(k, v);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.lock.unlock(stamp);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K k) {
        long stamp = this.lock.writeLock();
        try {
            this.atomRemove(k);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private void atomRemove(K k) {
        Node<K, V> node = this.cache.get(k);
        if (node == null) {
            return;
        }
        this.cache.remove(k);
        this.doublyQueue.remove(node);
        --this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K k, V v) {
        if (v == null) {
            return;
        }
        long stamp = this.lock.writeLock();
        try {
            this.atomPut(k, v);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private V atomGet(K k) {
        Node<K, V> node = this.cache.get(k);
        if (node == null) {
            return null;
        }
        if (this.isExpired(node)) {
            return null;
        }
        this.doublyQueue.moveToFirst(node);
        node.setAccessTime(System.currentTimeMillis());
        return node.getValue();
    }

    private void atomPut(K k, V v) {
        long t = System.currentTimeMillis();
        Node<K, V> node = this.cache.get(k);
        if (node == null) {
            node = new Node();
            node.setWriteTime(t);
            node.setAccessTime(t);
            node.setKey(k);
            node.setValue(v);
            this.cache.put(k, node);
            this.doublyQueue.addToFirst(node);
            ++this.size;
        } else {
            node.setWriteTime(t);
            node.setAccessTime(t);
            node.setKey(k);
            node.setValue(v);
            this.doublyQueue.moveToFirst(node);
        }
        if ((long)this.size > this.builder.getMaximumSize()) {
            K tailKey = this.doublyQueue.getTailKey();
            this.cache.remove(tailKey);
            this.doublyQueue.removeLast();
            --this.size;
        }
    }

    private boolean isExpired(Node<K, V> node) {
        long expireAfterAccessSeconds = this.builder.getExpireAfterAccessSeconds();
        long expireAfterWriteSeconds = this.builder.getExpireAfterWriteSeconds();
        long t = System.currentTimeMillis();
        boolean expired = false;
        if (expireAfterAccessSeconds != -1L && t - TimeUnit.SECONDS.toMillis(expireAfterAccessSeconds) > node.accessTime) {
            expired = true;
        }
        if (expireAfterWriteSeconds != -1L && t - TimeUnit.SECONDS.toMillis(expireAfterWriteSeconds) > node.writeTime) {
            expired = true;
        }
        return expired;
    }

    public Map<K, Node<K, V>> getCache() {
        return this.cache;
    }

    public void setCache(Map<K, Node<K, V>> cache) {
        this.cache = cache;
    }

    @Override
    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String toString() {
        StringBuilder sbr = new StringBuilder();
        long stamp = this.lock.readLock();
        try {
            Node node = this.doublyQueue.head;
            while (node != null) {
                if (this.isExpired(node)) {
                    node = node.next;
                    continue;
                }
                sbr.append(node.key).append(":").append(node.value.get()).append(";");
                node = node.next;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.lock.unlock(stamp);
        }
        return "data:" + sbr.toString() + ",data size:" + this.cache.size() + ",cache size:" + this.size;
    }

    public static class ClearThread<K, V>
    implements Runnable {
        private final LDPCache<K, V> ldpCache;
        private final StampedLock lock;

        private ClearThread(LDPCache<K, V> ldpCache, StampedLock lock) {
            this.ldpCache = ldpCache;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long stamp = this.lock.writeLock();
            ArrayList delKeys = new ArrayList();
            try {
                Map cache = this.ldpCache.cache;
                for (Map.Entry entry : cache.entrySet()) {
                    Node node = entry.getValue();
                    Object k = entry.getKey();
                    if (node != null && !this.ldpCache.isExpired(node) && node.value != null && node.value.get() != null) continue;
                    delKeys.add(k);
                }
                for (Map.Entry delKey : delKeys) {
                    try {
                        this.ldpCache.atomRemove(delKey);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("finished clear ldp-cache,delete size:{},current size:{}", (Object)delKeys.size(), (Object)cache.size());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
    }

    public static class DoublyLinkedList<K, V> {
        private Node<K, V> head = null;
        private Node<K, V> tail = null;

        public void addToFirst(Node<K, V> node) {
            if (this.tail == null) {
                this.tail = node;
                this.head = this.tail;
            } else {
                node.next = this.head;
                this.head.pre = node;
                this.head = node;
            }
        }

        public Node<K, V> getHead() {
            return this.head;
        }

        public void setHead(Node<K, V> head) {
            this.head = head;
        }

        public Node<K, V> getTail() {
            return this.tail;
        }

        public void setTail(Node<K, V> tail) {
            this.tail = tail;
        }

        public void moveToFirst(Node<K, V> node) {
            if (this.head == node) {
                return;
            }
            if (node == this.tail) {
                this.tail = node.pre;
                this.tail.next = null;
            } else {
                node.pre.next = node.next;
                node.next.pre = node.pre;
            }
            node.pre = null;
            node.next = this.head;
            this.head.pre = node;
            this.head = node;
        }

        public void remove(Node<K, V> node) {
            if (this.head == this.tail) {
                this.tail = null;
                this.head = null;
            } else if (node == this.tail) {
                this.removeLast();
            } else if (node == this.head) {
                this.removeFirst();
            } else {
                node.pre.next = node.next;
                node.next.pre = node.pre;
            }
        }

        public void removeLast() {
            if (this.tail == null) {
                return;
            }
            if (this.head == this.tail) {
                this.tail = null;
                this.head = null;
            } else {
                this.tail = this.tail.pre;
                this.tail.next = null;
            }
        }

        public void removeFirst() {
            if (this.head == null) {
                return;
            }
            if (this.head == this.tail) {
                this.tail = null;
                this.head = null;
            } else {
                this.head = this.head.next;
                this.head.pre = null;
            }
        }

        public K getTailKey() {
            return this.tail.key;
        }
    }

    public static class Node<K, V> {
        private K key;
        private SoftReference<V> value;
        private long accessTime;
        private long writeTime;
        private Node<K, V> pre;
        private Node<K, V> next;

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value.get();
        }

        public void setValue(V value) {
            this.value = new SoftReference<V>(value);
        }

        public long getAccessTime() {
            return this.accessTime;
        }

        public void setAccessTime(long accessTime) {
            this.accessTime = accessTime;
        }

        public long getWriteTime() {
            return this.writeTime;
        }

        public void setWriteTime(long writeTime) {
            this.writeTime = writeTime;
        }

        public Node<K, V> getPre() {
            return this.pre;
        }

        public void setPre(Node<K, V> pre) {
            this.pre = pre;
        }

        public Node<K, V> getNext() {
            return this.next;
        }

        public void setNext(Node<K, V> next) {
            this.next = next;
        }
    }
}

