/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.queue;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BoundedPriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private static final int TREE_ROOT_INDEX = 0;
    private static final int NO_INDEX = -1;
    private final Object[] queue;
    private int size;
    private final Comparator<? super E> comparator;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    public BoundedPriorityBlockingQueue(int capacity) {
        this(capacity, null, false);
    }

    public BoundedPriorityBlockingQueue(int capacity, boolean fair) {
        this(capacity, null, fair);
    }

    public BoundedPriorityBlockingQueue(int capacity, Comparator<? super E> comparator) {
        this(capacity, comparator, false);
    }

    public BoundedPriorityBlockingQueue(int capacity, boolean fair, Collection<? extends E> collection) {
        this(capacity, fair);
        if (capacity < collection.size()) {
            throw new IllegalArgumentException("Capacity must be greater than collection size");
        }
        for (E element : collection) {
            this.add(element);
        }
    }

    public BoundedPriorityBlockingQueue(int capacity, Comparator<? super E> comparator, boolean fair) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        this.comparator = comparator;
        this.queue = new Object[capacity];
    }

    @Override
    public boolean add(E element) {
        return super.add(element);
    }

    @Override
    public E take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            try {
                while (this.size == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            E e = this.extractElement();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void put(E element) throws InterruptedException {
        BoundedPriorityBlockingQueue.checkNotNull(element);
        this.lock.lockInterruptibly();
        try {
            try {
                while (this.size == this.queue.length) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException ie) {
                this.notFull.signal();
                throw ie;
            }
            this.insertElement(element);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(E element) {
        BoundedPriorityBlockingQueue.checkNotNull(element);
        boolean inserted = false;
        this.lock.lock();
        try {
            if (this.size < this.queue.length) {
                this.insertElement(element);
                inserted = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        return inserted;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(E element, long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E poll() {
        this.lock.lock();
        try {
            E e = this.extractElement();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E peek() {
        this.lock.lock();
        try {
            Object object = this.size > 0 ? this.queue[0] : null;
            return (E)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.queue.length - this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        boolean removed = false;
        this.lock.lock();
        try {
            int i = this.indexOf(object);
            if (i != -1) {
                this.removeAt(i);
                removed = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        return removed;
    }

    @Override
    public boolean contains(Object object) {
        this.lock.lock();
        try {
            boolean bl = this.indexOf(object) != -1;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collectionToDrainTo) {
        BoundedPriorityBlockingQueue.checkNotNull(collectionToDrainTo);
        BoundedPriorityBlockingQueue.checkNotSame(collectionToDrainTo, this);
        int numberOfDrainedElements = 0;
        this.lock.lock();
        try {
            E drainedElement = this.extractElementWithoutSignalingWaitingThread();
            while (drainedElement != null) {
                collectionToDrainTo.add(drainedElement);
                ++numberOfDrainedElements;
                drainedElement = this.extractElementWithoutSignalingWaitingThread();
            }
            if (numberOfDrainedElements > 0) {
                this.notFull.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        return numberOfDrainedElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collectionToDrainTo, int maxElementsToDrain) {
        int numberOfDrainedElements;
        BoundedPriorityBlockingQueue.checkNotNull(collectionToDrainTo);
        BoundedPriorityBlockingQueue.checkNotSame(collectionToDrainTo, this);
        this.lock.lock();
        try {
            E drainedElement;
            for (numberOfDrainedElements = 0; numberOfDrainedElements < maxElementsToDrain && (drainedElement = this.extractElementWithoutSignalingWaitingThread()) != null; ++numberOfDrainedElements) {
                collectionToDrainTo.add(drainedElement);
            }
            if (numberOfDrainedElements > 0) {
                this.notFull.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        return numberOfDrainedElements;
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            for (int i = 0; i < this.size; ++i) {
                this.queue[i] = null;
            }
            this.size = 0;
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] objectArray = Arrays.copyOf(this.queue, this.size);
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] newArray) {
        this.lock.lock();
        try {
            if (newArray.length < this.size) {
                T[] TArray = Arrays.copyOf(this.queue, this.size, newArray.getClass());
                return TArray;
            }
            System.arraycopy(this.queue, 0, newArray, 0, this.size);
            if (newArray.length > this.size) {
                newArray[this.size] = null;
            }
            T[] TArray = newArray;
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator(this.toArray());
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    private static void checkNotSame(Object first, Object second) {
        if (first == second) {
            throw new IllegalArgumentException("Not allowed due to same object");
        }
    }

    private void removeAt(int index) {
        int lastElementInQueue = this.size - 1;
        if (lastElementInQueue == index) {
            this.queue[index] = null;
        } else {
            Object movedElement = this.queue[lastElementInQueue];
            this.queue[lastElementInQueue] = null;
            BoundedPriorityBlockingQueue.siftDownElement(index, movedElement, this.queue, lastElementInQueue, this.comparator);
            if (this.queue[index] == movedElement) {
                BoundedPriorityBlockingQueue.siftUpElement(index, movedElement, this.queue, this.comparator);
            }
        }
        --this.size;
        this.notFull.signal();
    }

    private int indexOf(Object object) {
        if (object != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.queue[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private void insertElement(E element) {
        BoundedPriorityBlockingQueue.siftUpElement(this.size, element, this.queue, this.comparator);
        ++this.size;
        this.notEmpty.signal();
    }

    private E extractElement() {
        E element = this.extractElementWithoutSignalingWaitingThread();
        if (element != null) {
            this.notFull.signal();
        }
        return element;
    }

    private E extractElementWithoutSignalingWaitingThread() {
        Object element = null;
        if (this.size > 0) {
            int lastIndexOfQueue = this.size - 1;
            element = this.queue[0];
            Object elementToMove = this.queue[lastIndexOfQueue];
            this.queue[lastIndexOfQueue] = null;
            BoundedPriorityBlockingQueue.siftDownElement(0, elementToMove, this.queue, lastIndexOfQueue, this.comparator);
            --this.size;
        }
        return (E)element;
    }

    private static <T> void siftUpElement(int insertionIndex, T element, Object[] heap, Comparator<? super T> comparator) {
        Comparable comparableElement;
        boolean hasComparator = comparator != null;
        Comparable comparable = comparableElement = hasComparator ? null : (Comparable)element;
        while (insertionIndex > 0) {
            boolean equalOrGreaterThanZero;
            int parentIndex = insertionIndex - 1 >>> 1;
            Object parentElement = heap[parentIndex];
            boolean bl = hasComparator ? comparator.compare(element, parentElement) >= 0 : (equalOrGreaterThanZero = comparableElement.compareTo(parentElement) >= 0);
            if (equalOrGreaterThanZero) break;
            heap[insertionIndex] = parentElement;
            insertionIndex = parentIndex;
        }
        heap[insertionIndex] = element;
    }

    private static <T> void siftDownElement(int insertionIndex, T element, Object[] heap, int heapSize, Comparator<? super T> comparator) {
        boolean hasComparator = comparator != null;
        Comparable comparableElement = hasComparator ? null : (Comparable)element;
        int half = heapSize >>> 1;
        while (insertionIndex < half) {
            boolean equalOrLessThanZero;
            int childIndex = (insertionIndex << 1) + 1;
            Object childElement = heap[childIndex];
            int rightIndex = childIndex + 1;
            if (rightIndex < heapSize) {
                boolean greaterThanZero;
                boolean bl = hasComparator ? comparator.compare(childElement, heap[rightIndex]) > 0 : (greaterThanZero = ((Comparable)childElement).compareTo(heap[rightIndex]) > 0);
                if (greaterThanZero) {
                    childIndex = rightIndex;
                    childElement = heap[childIndex];
                }
            }
            boolean bl = hasComparator ? comparator.compare(element, childElement) <= 0 : (equalOrLessThanZero = comparableElement.compareTo(childElement) <= 0);
            if (equalOrLessThanZero) break;
            heap[insertionIndex] = childElement;
            insertionIndex = childIndex;
        }
        heap[insertionIndex] = element;
    }

    private final class QueueIterator
    implements Iterator<E> {
        private final Object[] array;
        private int indexToReturn;
        private int lastReturnedIndex = -1;

        QueueIterator(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.indexToReturn < this.array.length;
        }

        @Override
        public E next() {
            if (this.indexToReturn >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.indexToReturn;
            return this.array[this.indexToReturn++];
        }

        @Override
        public void remove() {
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            this.removeElementByIdentity(this.array[this.lastReturnedIndex]);
            this.lastReturnedIndex = -1;
        }

        private void removeElementByIdentity(Object object) {
            BoundedPriorityBlockingQueue.this.lock.lock();
            try {
                for (int i = 0; i < BoundedPriorityBlockingQueue.this.size; ++i) {
                    if (object != BoundedPriorityBlockingQueue.this.queue[i]) continue;
                    BoundedPriorityBlockingQueue.this.removeAt(i);
                    break;
                }
            }
            finally {
                BoundedPriorityBlockingQueue.this.lock.unlock();
            }
        }
    }
}

